/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class SuperbladeListMacCommand
extends SuperBladeCommand {
    StringBuffer formatedString;
    String formatTemplate = "  %-12s | %18s | %18s | %18s | %18s | %18s |\n";

    public SuperbladeListMacCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public void runCommand() throws Exception {
        this.formatedString = new StringBuffer();
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIsQueryMBSensorEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        String Hmac1 = "";
        String Hmac2 = "";
        String Hmac3 = "";
        String Hmac4 = "";
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        this.formatedString.append(String.format(this.formatTemplate, "Module", "Management MAC", "Host MAC1", "Host MAC2", "Host MAC3", "Host MAC4"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "--------------", "---------", "---------", "---------", "---------"));
        String Mmac1 = ipmiLanCommand.getMACEx();
        this.formatedString.append(String.format(this.formatTemplate, "CMM", Mmac1, "N/A", "N/A", "N/A", "N/A"));
        for (int i = 0; i < bladeSystem.getBlades().length; ++i) {
            BladeEntity b = bladeSystem.getBlades()[i];
            if (b.getPresent() <= 0) continue;
            byte bladeIndex = (byte)b.getModuleIndex();
            IPMICMMOEMCommand.BladeHWInfo bladeHWInfo = this.ipmiCMMOEMCommand.getBladeHWInfo(bladeIndex);
            if (bladeHWInfo.isDataReady()) {
                int lanTotal = bladeHWInfo.getNumberOfOnboardLanValue();
                if (lanTotal == 2) {
                    Hmac1 = bladeHWInfo.getMAC(0);
                    Hmac2 = bladeHWInfo.getMAC(1);
                    Hmac3 = bladeHWInfo.getMAC3();
                    Hmac4 = bladeHWInfo.getMAC4();
                    if (Hmac3.equalsIgnoreCase(Hmac2)) {
                        Hmac3 = "not presented";
                    }
                } else if (lanTotal == 1) {
                    Hmac1 = bladeHWInfo.getMAC(0);
                    Hmac2 = bladeHWInfo.getMAC3();
                    Hmac3 = bladeHWInfo.getMAC4();
                    Hmac4 = bladeHWInfo.getMAC5();
                }
            } else {
                Hmac1 = "";
                Hmac2 = "";
                Hmac3 = "";
                Hmac4 = "";
            }
            Mmac1 = "";
            if (bladeHWInfo.isDataReady() && this.sessionController != null) {
                if (bladeSystem.isIsSupportIPMB()) {
                    Mmac1 = this.showSIMBLMac(bladeIndex);
                } else {
                    MOut.G(this).println("BMC installed, but cannot get MAC address");
                    this.statusCode = 149;
                }
            }
            this.formatedString.append(String.format(this.formatTemplate, "Blade " + bladeIndex, Mmac1, Hmac1, Hmac2, Hmac3, Hmac4));
            MOut.G(this).println("Get data from blade " + bladeIndex);
            Thread.sleep(500L);
        }
        MOut.G(this).print(this.formatedString.toString());
        this.statusCode = 0;
    }

    public String showSIMBLMac(byte bladeIndex) throws IPMIException {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel(bladeIndex);
        if (this.sessionController != null) {
            String mac;
            this.ipmiCMMOEMCommand.setEnabledNormalFunctionCommand(false);
            try {
                mac = ipmiLanCommand.getMACEx();
            }
            catch (IPMIException e) {
                mac = "BMC Installed";
            }
            this.ipmiCMMOEMCommand.setEnabledNormalFunctionCommand(true);
            if (mac != null) {
                return mac;
            }
            return "BMC Installed";
        }
        return "unknown";
    }
}

