/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.traps.SNMPv1Trap;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class TrapSaveCommand
extends Command {
    @Override
    public void execute() throws Exception {
        int sizeOfTrapV1 = Receiver.getInstance().getTrapCollector().getTrapV1Count();
        if (sizeOfTrapV1 == 0) {
            MOut.G(this).println("No SNMPv1 trap received");
            this.statusCode = 0;
            return;
        }
        if (this.parameters == null || this.parameters.length < 1) {
            MOut.G(this).print("Filename required");
            this.statusCode = 147;
            return;
        }
        String filename = this.parameters[0];
        boolean result = this.save(filename);
        if (result) {
            MOut.G(this).print("\"" + filename + "\" file saved");
        } else {
            MOut.G(this).print("save \"" + filename + "\" file failed");
        }
        this.statusCode = 0;
    }

    public boolean save(String filename) {
        PrintStream ps = null;
        try {
            ps = new PrintStream(filename);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        for (int index = 0; index < Receiver.getInstance().getTrapCollector().getTrapV1Count(); ++index) {
            SNMPv1Trap trap = Receiver.getInstance().getTrapCollector().getSNMPv1Traps().get(index);
            ps.println("\n-------------------------------------------------------------------------");
            ps.print("Trap (" + (index++ + 1) + ")");
            ps.print(trap.dumpFormatTrap());
        }
        ps.close();
        return true;
    }
}

