/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.trap.usm.UserTable;
import com.supermicro.ipmi.trap.usm.UserTableUtils;
import java.util.List;

public class TrapUserTableDeleteCommand
extends SuperBladeCommand {
    private int deleteIndex;

    @Override
    public boolean preValidate() {
        block6: {
            if (null == this.parameters || this.parameters.length == 0) {
                MOut.G(this).println("Usage: trap userTable delete <number>");
            } else {
                try {
                    this.deleteIndex = Integer.valueOf(this.parameters[0]);
                }
                catch (NumberFormatException e) {
                    MOut.G(this).println("The setting number should be integer");
                    break block6;
                }
                if (this.deleteIndex < 1 || this.deleteIndex > 10) {
                    MOut.G(this).println("The setting number is out of valid range. 1 - 10");
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        List<UserTable> listUserTable = UserTableUtils.readPropertyFile(UserTableUtils.DEFAULT_FILE_PATH);
        if (listUserTable == null || listUserTable.size() == 0) {
            MOut.G(this).println("snmpUserTable.properties file does not exist or file is empty.");
            this.statusCode = 149;
            return;
        }
        if (listUserTable.size() <= this.deleteIndex - 1) {
            MOut.G(this).println("Number " + this.deleteIndex + " setting does not exist.");
            this.statusCode = 147;
            return;
        }
        listUserTable.remove(this.deleteIndex - 1);
        UserTableUtils.writePropertyFile(listUserTable, UserTableUtils.DEFAULT_FILE_PATH);
        this.statusCode = 0;
        MOut.G(this).println("Done");
    }
}

