/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TrapV3SavePETCommand
extends Command {
    @Override
    public void execute() throws Exception {
        int trapV3Count = Receiver.getInstance().getTrapCollector().getTrapV3Count();
        if (trapV3Count == 0) {
            MOut.G(this).println("No SNMPv3 trap received");
            this.statusCode = 0;
            return;
        }
        if (this.parameters == null || this.parameters.length < 1) {
            MOut.G(this).print("Filename required");
            this.statusCode = 147;
            return;
        }
        String filename = this.parameters[0];
        boolean result = this.save(filename);
        if (result) {
            MOut.G(this).print("\"" + filename + "\" file saved");
        } else {
            MOut.G(this).print("save \"" + filename + "\" file failed");
        }
        this.statusCode = 0;
    }

    public boolean save(String filename) {
        String fileVersion = "supermicro-trap-v3";
        File f = new File(filename);
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        dos = new DataOutputStream(fos);
        try {
            dos.writeBytes(fileVersion);
            for (int i = 0; i < Receiver.getInstance().getTrapCollector().getTrapV3Count(); ++i) {
                SNMPv3Trap trapV3 = Receiver.getInstance().getTrapCollector().getSNMPv3Traps().get(i);
                dos.writeInt(trapV3.getNum());
                dos.writeByte(trapV3.getTrapSourceIP().length());
                dos.write(trapV3.getTrapSourceIP().getBytes(), 0, trapV3.getTrapSourceIP().length());
                dos.writeInt(trapV3.getWholeMsgLength());
                dos.write(trapV3.getMsgWholeMsg(), 0, trapV3.getWholeMsgLength());
            }
            dos.close();
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

