/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.CommandIncompleteException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UKVMCommand
extends SuperBladeCommand {
    Parser parser;
    String[] subArgs;
    Command command;

    public UKVMCommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid;
        if (this.parameters != null && this.parameters.length > 0) {
            if ("-html5".equalsIgnoreCase(this.parameters[0].trim())) {
                this.runHTML5KVM();
                return;
            }
            if (!"-skipElevate".equalsIgnoreCase(this.parameters[0].trim())) {
                MOut.G(this).println("Invalid parameter " + this.parameters[0] + "\nUsage: ukvm [-html5]");
                this.statusCode = 147;
                return;
            }
        }
        if ((guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp())) == null) {
            MOut.G(this).println("Unknown KVM type");
            this.statusCode = 149;
            return;
        }
        if (IPMIMessagingCommand.isAMIAddOnGUID(guid)) {
            this.runAMIKVM();
        } else if (IPMIMessagingCommand.isAMIGUID(guid)) {
            this.runAMIKVM();
        } else if (IPMIMessagingCommand.isAMIOnBoardGUID(guid)) {
            this.runAMIKVM();
        } else if (IPMIMessagingCommand.isAMISIMBLGUID(guid)) {
            this.runAMIKVM();
        } else if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
            this.runAMIX9KVM();
        } else if (IPMIMessagingCommand.isATENGUID(guid)) {
            this.runATENKVM();
        } else if (IPMIMessagingCommand.isCMMGUID(guid)) {
            this.runPepperconKVM();
        } else if (IPMIMessagingCommand.isNormalBladeCMMGUID(guid)) {
            this.runPepperconKVM();
        } else if (IPMIMessagingCommand.isOfficeBladeCMMGUID(guid)) {
            this.runPepperconKVM();
        } else {
            if (IPMIMessagingCommand.isOSAGUID(guid)) {
                MOut.G(this).println("Unsupported KVM type");
                this.statusCode = 149;
                return;
            }
            if (IPMIMessagingCommand.isPepperconGUID(guid)) {
                this.runPepperconKVM();
            } else {
                if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
                    MOut.G(this).println("Unsupported KVM type");
                    this.statusCode = 149;
                    return;
                }
                if (IPMIMessagingCommand.isSIMBL(guid)) {
                    this.runPepperconKVM();
                } else if (IPMIMessagingCommand.isTwinBladeCMMGUID(guid)) {
                    this.runPepperconKVM();
                } else if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
                    this.runAMIX9KVM();
                } else if (IPMIMessagingCommand.isAMIAspeedGUID(guid)) {
                    this.runAMIX9KVM();
                } else if (IPMIMessagingCommand.isMicroBladeNodeGUID(guid)) {
                    this.runATENKVM();
                } else if (IPMIMessagingCommand.isATENSuperBladeGUID(guid)) {
                    this.runATENKVM();
                } else if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
                    this.runMicroBladeKVM();
                } else {
                    if (IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
                        MOut.G(this).println("Unsupported KVM type");
                        this.statusCode = 149;
                        return;
                    }
                    this.runATENKVM();
                }
            }
        }
    }

    private void runHTML5KVM() {
        this.subArgs = new String[]{"redfish", "kvm"};
        this.runKVM();
    }

    public void runPepperconKVM() {
        this.subArgs = new String[]{"kvm"};
        this.runKVM();
    }

    public void runAMIKVM() {
        this.subArgs = new String[]{"kvmw"};
        this.runKVM();
    }

    public void runAMIX9KVM() {
        this.subArgs = new String[]{"kvmwx9"};
        this.runKVM();
    }

    public void runATENKVM() {
        this.subArgs = new String[]{"kvmwa"};
        this.runKVM();
    }

    public void runMicroBladeKVM() {
        this.subArgs = new String[]{"microblade", "kvm"};
        this.runKVM();
    }

    public void runKVM() {
        this.parser = new Parser();
        try {
            this.command = this.parser.parse(this.parser.argumentRoot, this.subArgs);
        }
        catch (CommandIncompleteException commandIncompleteException) {
            // empty catch block
        }
        if (this.command == null) {
            MOut.G(this).println("run KVM parser failed.");
            this.statusCode = 149;
            return;
        }
        this.command.setConfig(this.config);
        try {
            this.command.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.statusCode = this.command.getStatusCode();
    }
}

