/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.text.UserAccountHelper;

public class UserAddCommand
extends SuperBladeCommand {
    byte userID;
    String username;
    String password;
    byte privilege;
    private UserAccountHelper helper = new UserAccountHelper();

    @Override
    public boolean preValidate() {
        String usage = "Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo Access           : 15\n";
        if (this.config.getPrivilege() != 4) {
            MOut.G(this).println("Your privilege is not enough to do this action");
            return false;
        }
        if (this.parameters == null || this.parameters.length != 4) {
            MOut.G(this).println("Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo Access           : 15\n");
            return false;
        }
        this.username = this.parameters[1];
        this.password = this.parameters[2];
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
            this.privilege = Byte.parseByte(this.parameters[3]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!UserAccountHelper.isValidUserID(this.parameters[0])) {
            MOut.G(this).println("user id is out of range");
            MOut.G(this).println("Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo Access           : 15\n");
            return false;
        }
        if (UserAccountHelper.isReservedUserID(this.parameters[0])) {
            MOut.G(this).println("The user id has been reserved.");
            MOut.G(this).println("Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo Access           : 15\n");
            return false;
        }
        if (!UserAccountHelper.isValidPrivilege(this.parameters[3])) {
            MOut.G(this).println("Privilege level error");
            MOut.G(this).println("Administrator level : 4");
            MOut.G(this).println("Operator level      : 3");
            MOut.G(this).println("User level          : 2");
            MOut.G(this).println("No access           : 15");
            return false;
        }
        if (!UserAccountHelper.isValidUsernameLength(this.username)) {
            MOut.G(this).println("User name must be " + UserAccountHelper.USERNANE_LENGTH_MIN + " ~ " + UserAccountHelper.USERNANE_LENGTH_MAX + " characters");
            MOut.G(this).println("Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo Access           : 15\n");
            return false;
        }
        int passwordVerifyState = UserAccountHelper.isValidPassword(this.password, this.username, false);
        if (passwordVerifyState == 1) {
            MOut.G(this).println("Invalid Password\n(Password must be " + UserAccountHelper.PASSWORD_LENGTH_MIN + " ~ " + UserAccountHelper.PASSWORD_LENGTH_MAX + " characters)");
            MOut.G(this).println("Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo Access           : 15\n");
            return false;
        }
        if (passwordVerifyState == 2) {
            MOut.G(this).println("Username and password should not be identical");
            return false;
        }
        if (passwordVerifyState == 3) {
            MOut.G(this).println("Password can not be reverse of the user name");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int result = this.helper.addUser(ipmiMessagingCommand, this.userID, this.username, this.password, this.privilege);
        switch (result) {
            case 0: {
                MOut.G(this).println("Done");
                this.statusCode = 0;
                break;
            }
            case 5: {
                MOut.G(this).println("User ID should be 1-" + this.helper.getNumberOfAvailableUser(ipmiMessagingCommand));
                this.statusCode = 149;
                break;
            }
            case 6: {
                MOut.G(this).println("User ID " + this.userID + " is already used");
                this.statusCode = 149;
                break;
            }
            case 8: {
                MOut.G(this).println("Set enable user failed");
                this.statusCode = 149;
                break;
            }
            case 9: {
                MOut.G(this).println("Set user privilege failed");
                this.statusCode = 149;
                break;
            }
            case 11: {
                MOut.G(this).println("Invalid username");
                this.statusCode = 149;
                break;
            }
            case 12: {
                MOut.G(this).println("This user name has been used, please change to another one.");
                this.statusCode = 149;
                break;
            }
            case 4: {
                MOut.G(this).println("Invalid password. \nPassword require " + UserAccountHelper.PASSWORD_LENGTH_MIN + " to " + UserAccountHelper.PASSWORD_LENGTH_MAX + " characters includes at least " + UserAccountHelper.PASSWORD_SECURITY_POLICY + " of character classes from 'a-z','A-Z','0-9' or Special characters.");
                this.statusCode = 149;
                break;
            }
            case 10: {
                MOut.G(this).println("Set user password failed");
                this.statusCode = 149;
                break;
            }
            default: {
                MOut.G(this).println("Unknown error");
                this.statusCode = 149;
            }
        }
    }
}

