/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import tw.com.aten.vstorage.VirtualStorage;
import tw.com.aten.vstorage.VirtualStorageManager;

public class VMWACommand
extends SuperBladeCommand {
    boolean isForceStunnelVer11 = false;
    public static boolean isShowDebugMsg = false;
    private SubCommand subCommand = SubCommand.NO_COMMAND;

    public VMWACommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"dev1list", "dev1drv", "dev2list", "dev2cd", "dev2dvd", "dev2iso", "dev1stop", "dev2stop", "log", "status"};
    }

    @Override
    public boolean preValidate() {
        boolean passValidate = false;
        if (!this.isVirutalMediaSupported()) {
            this.printSlaveCMMUnavailableMessage();
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("dev1list")) {
                this.subCommand = SubCommand.DEV1_LIST;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev1drv")) {
                this.subCommand = SubCommand.DEV1_DRV;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2list")) {
                this.subCommand = SubCommand.DEV2_LIST;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2cd")) {
                this.subCommand = SubCommand.DEV2_CD;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2dvd")) {
                this.subCommand = SubCommand.DEV2_DVD;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2iso")) {
                this.subCommand = SubCommand.DEV2_ISO;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev1stop")) {
                this.subCommand = SubCommand.DEV1_STOP;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2stop")) {
                this.subCommand = SubCommand.DEV2_STOP;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("log")) {
                this.subCommand = SubCommand.LOG;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("status")) {
                this.subCommand = SubCommand.STATUS;
                passValidate = true;
            }
        } else {
            this.printUsage();
            return false;
        }
        switch (this.subCommand) {
            case DEV1_LIST: 
            case DEV2_LIST: 
            case DEV1_STOP: 
            case DEV2_STOP: 
            case LOG: 
            case ALL_STATUS: 
            case STATUS: {
                break;
            }
            case DEV1_DRV: 
            case DEV2_CD: 
            case DEV2_DVD: 
            case DEV2_ISO: {
                if (this.parameters.length < 2) {
                    passValidate = false;
                }
                if (this.parameters.length != 3 || !"ssl".equalsIgnoreCase(this.parameters[2])) break;
                this.isForceStunnelVer11 = true;
            }
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        MOut.G(this).println("Available commands:");
        MOut.G(this).println("dev1list             List available devices for virtual device 1");
        MOut.G(this).println("dev1drv <index>      Mount drive for virtual device 1");
        MOut.G(this).println("dev1stop             Stop virtual device 1");
        MOut.G(this).println("dev2list             List available devices for virtual device 2");
        MOut.G(this).println("dev2cd  <index>      Mount CD/DVD for virtual device 2");
        MOut.G(this).println("dev2iso <filename>   Mount ISO file for virtual device 2");
        MOut.G(this).println("dev2stop             Stop virtual device 2");
        MOut.G(this).println("status               Show status");
        MOut.G(this).println("log                  Show log");
        MOut.G(this).println("");
        MOut.G(this).println("");
        MOut.G(this).println("Note: ");
        MOut.G(this).println("* Support 2 virtual devices (device 1 & device 2)");
        MOut.G(this).println("  Device 1 will be Hard Disk,USB or Floppy");
        MOut.G(this).println("  Device 2 will be CD,DVD or ISO file");
        MOut.G(this).println("* List available devices before mount virtual media when plug in ");
        MOut.G(this).println("  Removable device");
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        switch (this.subCommand) {
            case DEV1_LIST: {
                this.dev1List();
                break;
            }
            case DEV2_LIST: {
                this.dev2List();
                break;
            }
            case DEV1_STOP: {
                this.dev1Stop();
                break;
            }
            case DEV2_STOP: {
                this.dev2Stop();
                break;
            }
            case LOG: {
                this.log();
                break;
            }
            case ALL_STATUS: {
                this.allStatus();
                break;
            }
            case STATUS: {
                this.status();
                break;
            }
            case DEV1_DRV: {
                this.dev1Drv();
                break;
            }
            case DEV2_CD: {
                this.dev2cd();
                break;
            }
            case DEV2_DVD: {
                this.dev2dvd();
                break;
            }
            case DEV2_ISO: {
                this.dev2iso();
            }
        }
    }

    public void dev1List() {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        String str = vs.dev1List();
        MOut.G(this).print(str);
    }

    public void dev2List() {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        String str = vs.dev2List();
        MOut.G(this).print(str);
    }

    public void dev1Stop() {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        vs.dev1Unmount();
        MOut.G(this).print(vs.lastMessage());
    }

    public void dev2Stop() {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        vs.dev2Unmount();
        MOut.G(this).print(vs.lastMessage());
    }

    public void log() {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        String str = vs.getLog();
        MOut.G(this).print(str);
    }

    public void allStatus() {
        String str = VirtualStorageManager.getInstance().getMountStatus();
        MOut.G(this).print(str);
    }

    public void status() {
        VirtualStorage vs;
        boolean isVSExist = VirtualStorageManager.getInstance().isVirtualStorageExist(this.config);
        String device1 = "";
        String device2 = "";
        int dev1MountIndex = 0;
        int dev2MountIndex = 0;
        if (isVSExist) {
            try {
                vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
                if (vs == null) {
                    MOut.G(this).print("Get VirtualStorage fail");
                    this.statusCode = 149;
                    return;
                }
                dev1MountIndex = vs.getDev1MountIndex();
                dev2MountIndex = vs.getDev2MountIndex();
            }
            catch (Exception e) {
                MOut.G(this).print("Get mount index fail");
                this.statusCode = 149;
                return;
            }
        }
        if ((vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config)) == null) {
            this.statusCode = 149;
            return;
        }
        if (dev1MountIndex != 0) {
            device1 = vs.mountStatus(1);
        }
        if (dev2MountIndex != 0) {
            device2 = vs.mountStatus(2);
        }
        if (dev1MountIndex == 0 || dev2MountIndex == 0) {
            if (!GlobalDefine.NUTANIX_PROJECT) {
                MOut.G(this).println("This command will take some time ...");
            }
            this.sessionController.closeSession();
            this.isSessionClosed = true;
            String str = VirtualStorageManager.getInstance().getMountStatus(this.config);
            if (str != null) {
                if (str.indexOf("Device 1") == -1 && dev1MountIndex == 0) {
                    device1 = "Device 1: None";
                }
                if (str.indexOf("Device 2") == -1 && dev2MountIndex == 0) {
                    device2 = "Device 2: None";
                }
                if (str.indexOf("|") > -1) {
                    String[] devices = str.split("\\|");
                    for (int i = 0; i < devices.length; ++i) {
                        if (dev1MountIndex == 0 && devices[i].indexOf("Device 1") > -1) {
                            device1 = devices[i];
                            continue;
                        }
                        if (dev2MountIndex != 0 || devices[i].indexOf("Device 2") <= -1) continue;
                        device2 = devices[i];
                    }
                }
            } else {
                MOut.G(this).println("get MountStatus failed");
            }
        }
        MOut.G(this).println(device1);
        MOut.G(this).println(device2);
    }

    public void dev1Drv() {
        int index;
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config, this.isForceStunnelVer11);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        String p1 = this.parameters[1];
        try {
            index = Integer.parseInt(p1);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        if (!vs.checkIsDev1IndexValid(index)) {
            MOut.G(this).print("Index invalid");
            return;
        }
        if (vs.getDev1MountIndex() != 0) {
            MOut.G(this).print("Device 1 is mounted already");
            return;
        }
        MOut.G(this).println("Mounting " + vs.getDev1Array()[index]);
        vs.dev1Mount(index);
        MOut.G(this).print(vs.lastMessage());
    }

    public void dev2cd() {
        int index;
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config, this.isForceStunnelVer11);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        String p1 = this.parameters[1];
        try {
            index = Integer.parseInt(p1);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        if (!vs.checkIsDev2IndexValid(index)) {
            MOut.G(this).print("Index invalid");
            return;
        }
        if (vs.getDev2MountIndex() != 0) {
            MOut.G(this).print("Device 2 is mounted already");
            return;
        }
        MOut.G(this).println("Mounting " + vs.getDev2Array()[index]);
        vs.dev2CDMount(index);
        MOut.G(this).print(vs.lastMessage());
    }

    public void dev2dvd() {
        int index;
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config, this.isForceStunnelVer11);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        String p1 = this.parameters[1];
        try {
            index = Integer.parseInt(p1);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        if (!vs.checkIsDev2IndexValid(index)) {
            MOut.G(this).print("Index invalid");
            return;
        }
        if (vs.getDev2MountIndex() != 0) {
            MOut.G(this).print("Device 2 is mounted already");
            return;
        }
        MOut.G(this).println("Mounting " + vs.getDev2Array()[index]);
        vs.dev2CDMount(index);
        MOut.G(this).print(vs.lastMessage());
    }

    public void dev2iso() {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config, this.isForceStunnelVer11);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        String p1 = this.parameters[1];
        File f = new File(p1);
        if (!f.exists()) {
            MOut.G(this).println(p1 + " is not exist");
            return;
        }
        if (vs.getDev2MountIndex() != 0) {
            MOut.G(this).print("Device 2 is mounted already");
            return;
        }
        MOut.G(this).println("Mounting ISO file: " + p1);
        vs.dev2ISOMount(p1);
        MOut.G(this).print(vs.lastMessage());
    }

    @Override
    public boolean isVirutalMediaSupported() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            return false;
        }
        return !IPMIMessagingCommand.isCMMGUID(guid) && !IPMIMessagingCommand.isSIMBL(guid) && !IPMIMessagingCommand.isPepperconGUID(guid) && !IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) && !IPMIMessagingCommand.isOSAGUID(guid) && !IPMIMessagingCommand.isAMIGUID(guid) && !IPMIMessagingCommand.isAMISIMBLGUID(guid) && !IPMIMessagingCommand.isAMIX9GUID(guid) && !IPMIMessagingCommand.isAMIAspeedGUID(guid) && !IPMIMessagingCommand.isMicroBladeCMMGUID(guid) && !IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) && !IPMIMessagingCommand.isCB3GUID(guid) && !IPMIMessagingCommand.isRenesasATENGUID(guid) && !IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid);
    }

    @Override
    public void printSlaveCMMUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device");
    }

    static enum SubCommand {
        DEV1_LIST,
        DEV1_DRV,
        DEV2_LIST,
        DEV2_CD,
        DEV2_DVD,
        DEV2_ISO,
        DEV1_STOP,
        DEV2_STOP,
        LOG,
        ALL_STATUS,
        STATUS,
        NO_COMMAND;

    }
}

