/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMINM20Command;

public class CUPSPolicyDto {
    private IPMINM20Command.CUPSPolicy cp;
    public final String state;
    public final String target;
    public final String domain;
    public final int threshold;

    public CUPSPolicyDto(IPMINM20Command.CUPSPolicy cp) {
        this.cp = cp;
        this.state = this.getState();
        this.target = this.getTarget();
        this.domain = this.getDomain();
        this.threshold = this.getThreshold();
    }

    private String getState() {
        return (this.cp.policyStatus & 1) == 1 ? "Enable" : "Disable";
    }

    private String getTarget() {
        return (this.cp.policyID & 0x10) == 16 ? "Remote Console" : "BMC";
    }

    private String getDomain() {
        if ((this.cp.policyID & 1) == 1) {
            return "Core";
        }
        if ((this.cp.policyID & 2) == 2) {
            return "Memory";
        }
        if ((this.cp.policyID & 4) == 4) {
            return "IO";
        }
        return "Undefined";
    }

    private int getThreshold() {
        return this.cp.cupsThreshold & 0xFF;
    }
}

