/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.util.StringUtil;

public class MEBasicInfo {
    private static final int OFF_MAJOR_FW_REV = 2;
    private static final int OFF_MINOR_FW_REV = 3;
    private static final int OFF_PRODUCT_ID_MINOR = 9;
    private static final int OFF_IMPL_FW_VER = 11;
    private static final int OFF_FW_BUILD = 12;
    private static final int OFF_FW_BUILD_PATCH = 13;
    private IPMINM20Command ipmiCommand;
    private String platform = "Undefined";
    private double nmVersion = 0.0;
    private String fwVersion = null;
    private String time = null;

    public MEBasicInfo(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
        try {
            this.getInfo();
        }
        catch (IPMIException e) {
            System.out.format("[Error] Get ME Basic Information %s", e.getMessage() == null ? "" : ":" + e.getMessage());
        }
    }

    private void getInfo() throws IPMIException {
        DeviceInfo info = this.ipmiCommand.getDeviceID();
        this.platform = Common.PRODUCT_NAME.get(info.raw[9] & 0xFF);
        this.fwVersion = MEBasicInfo.getFwVersion(info.raw);
        this.nmVersion = MEBasicInfo.getNmVersion(info.raw[11] & 0xF);
        this.time = this.ipmiCommand.getSELTime();
    }

    private static double getNmVersion(int raw) {
        switch (raw) {
            case 1: {
                return 1.5;
            }
        }
        return raw;
    }

    private static String getFwVersion(byte[] raw) {
        return (byte)(raw[2] & 0x7F) + "." + (byte)((raw[3] & 0xF0) >> 4) + "." + (byte)(raw[3] & 0xF) + "." + ((byte)((raw[12] & 0xFF) >> 4) == 0 ? "" : Byte.valueOf((byte)((raw[12] & 0xFF) >> 4))) + (byte)(raw[12] & 0xF) + (byte)((raw[13] & 0xFF) >> 4);
    }

    public double getNmVersion() {
        return this.nmVersion;
    }

    public void display(int maxSize) {
        System.out.println();
        if (this.nmVersion == 0.0) {
            System.out.println(StringUtil.center("Intel NM not implemented/enabled", maxSize));
            return;
        }
        String version = String.format("Intel Intelligent Power Node Manager %s (%s)", this.nmVersion, this.fwVersion);
        System.out.println(StringUtil.center(version, maxSize));
        System.out.println(StringUtil.center("SEL Time - " + this.time, maxSize));
    }
}

