/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap.auth;

import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class AuthGeneric {
    public static final int HMAC_BUFFER_SIZE = 0x100000;
    public static final int HMAC_BLOCK_SIZE = 64;
    public static final int AUTHENTICATION_CODE_LENGTH = 12;
    public static final int AUTHENTICATION_PROTOCOL_ENUM_MD5 = 0;
    public static final int AUTHENTICATION_PROTOCOL_ENUM_SHA1 = 1;
    public static final String AUTHENTICATION_PROTOCOL_MD5 = "MD5";
    public static final String AUTHENTICATION_PROTOCOL_SHA1 = "SHA-1";
    public static final String AUTHENTICATION_PROTOCOL_SHA96 = "SHA96";

    public byte[] passwordToKey(int authProtocol, byte[] password, byte[] engineID) throws NoSuchAlgorithmException {
        String authProtocolStr = null;
        if (authProtocol == 0) {
            authProtocolStr = AUTHENTICATION_PROTOCOL_MD5;
        } else if (authProtocol == 1) {
            authProtocolStr = AUTHENTICATION_PROTOCOL_SHA1;
        } else {
            System.out.println("Unsupportd authentication protocol: " + authProtocol);
            return null;
        }
        MessageDigest md = MessageDigest.getInstance(authProtocolStr);
        ByteBuffer buf = ByteBuffer.allocate(0x100000);
        int password_index = 0;
        int hmacBlockSize = 64;
        for (int count = 0; count < 0x100000; count += hmacBlockSize) {
            for (int i = 0; i < hmacBlockSize; ++i) {
                buf.put(password[password_index++ % password.length]);
            }
        }
        buf.flip();
        md.update(buf);
        byte[] digest = md.digest();
        md.reset();
        md.update(digest);
        md.update(engineID);
        md.update(digest);
        digest = md.digest();
        return digest;
    }

    public boolean isAuthentic(SNMPv3Trap trap, byte[] authenticationKey) throws NoSuchAlgorithmException {
        byte[] origDigest = new byte[12];
        System.arraycopy(trap.getMsgAuthenticationParameters(), 0, origDigest, 0, 12);
        if (!this.authenticate(trap, authenticationKey)) {
            return false;
        }
        byte[] authParameters = trap.getMsgAuthenticationParameters();
        for (int idx = 0; idx < 12; ++idx) {
            if (authParameters[idx] == origDigest[idx]) continue;
            trap.setMsgAuthenticationParameters(origDigest);
            return false;
        }
        return true;
    }

    public static int getProtocolEnum(String value) {
        if (null != value && value.contentEquals(AUTHENTICATION_PROTOCOL_MD5)) {
            return 0;
        }
        if (null != value && (value.contentEquals(AUTHENTICATION_PROTOCOL_SHA1) || value.contentEquals(AUTHENTICATION_PROTOCOL_SHA96))) {
            return 1;
        }
        return -1;
    }

    public static String getProtocolStr(int index) {
        if (index == 0) {
            return AUTHENTICATION_PROTOCOL_MD5;
        }
        if (index == 1) {
            return AUTHENTICATION_PROTOCOL_SHA1;
        }
        return null;
    }

    public abstract boolean authenticate(SNMPv3Trap var1, byte[] var2) throws NoSuchAlgorithmException;
}

