/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap.traps;

import com.supermicro.ipmi.trap.traps.BaseTrap;
import com.supermicro.ipmi.trap.traps.VariableBindings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SNMPv3Trap
extends BaseTrap {
    static final int AUTHENTICATION_PARAMETERS_LENGH = 12;
    static final int PRIVACY_PARAMETERS_LENGH = 8;
    private byte[] msgAuthoritativeEngineID;
    private byte[] msgAuthenticationParameters = new byte[12];
    private byte[] msgPrivacyParameters = new byte[8];
    private byte[] msgUserName;
    private byte[] msgWholeMsg;
    private long msgAuthoritativeEngineBoots;
    private long msgAuthoritativeEngineTime;
    private int wholeMsgLength;
    private int variableBindingsLength;
    private int encryptedPDUOffset;
    private int encryptedPDULength;
    private int msgAuthenticationParametersOffset;
    private int msgVersion;
    private String contextEngineID;
    private String contextName;
    private String seluserName;
    private String selSensorName;
    private String selSensorType;
    private String selDescription;
    private String selRawData;
    private String selGUID;
    private List<VariableBindings> variableBindingsList;

    public SNMPv3Trap() {
        this.trapType = 1;
        this.variableBindingsList = new ArrayList<VariableBindings>();
    }

    @Override
    public String dumpFormatTrap() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nSenderIP    : " + this.trapSourceIP);
        sb.append("\nSensorType  : " + this.selSensorType);
        sb.append("\nSensorName  : " + this.selSensorName);
        sb.append("\nraw data    : " + this.selRawData);
        sb.append("\nDescription : " + this.selDescription);
        return sb.toString();
    }

    @Override
    public void flushTrap() {
        this.selSensorType = null;
        this.selSensorName = null;
        this.selRawData = null;
        this.selDescription = null;
        this.variableBindingsList.clear();
    }

    public byte[] getMsgAuthoritativeEngineID() {
        return this.msgAuthoritativeEngineID;
    }

    public byte[] getMsgAuthenticationParameters() {
        return this.msgAuthenticationParameters;
    }

    public byte[] getMsgPrivacyParameters() {
        return this.msgPrivacyParameters;
    }

    public byte[] getMsgUserName() {
        return this.msgUserName;
    }

    public byte[] getMsgWholeMsg() {
        return this.msgWholeMsg;
    }

    public long getMsgAuthoritativeEngineBoots() {
        return this.msgAuthoritativeEngineBoots;
    }

    public long getMsgAuthoritativeEngineTime() {
        return this.msgAuthoritativeEngineTime;
    }

    public int getWholeMsgLength() {
        return this.wholeMsgLength;
    }

    public int getVariableBindingsLength() {
        return this.variableBindingsLength;
    }

    public int getEncryptedPDUOffset() {
        return this.encryptedPDUOffset;
    }

    public int getEncryptedPDULength() {
        return this.encryptedPDULength;
    }

    public int getMsgAuthenticationParametersOffset() {
        return this.msgAuthenticationParametersOffset;
    }

    public int getMsgVersion() {
        return this.msgVersion;
    }

    public String getContextEngineID() {
        return this.contextEngineID;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getSelUserName() {
        return this.seluserName;
    }

    public String getSelSensorName() {
        return this.selSensorName;
    }

    public String getSelSensorType() {
        return this.selSensorType;
    }

    public String getSelDescription() {
        return this.selDescription;
    }

    public String getSelRawData() {
        return this.selRawData;
    }

    public String getSelGUID() {
        return this.selGUID;
    }

    public List<VariableBindings> getVariableBindingsList() {
        return this.variableBindingsList;
    }

    public void setMsgAuthoritativeEngineID(byte[] authEngineID) {
        this.msgAuthoritativeEngineID = new byte[authEngineID.length];
        System.arraycopy(authEngineID, 0, this.msgAuthoritativeEngineID, 0, authEngineID.length);
    }

    public void setMsgAuthenticationParameters(byte[] authParameters) {
        System.arraycopy(authParameters, 0, this.msgAuthenticationParameters, 0, authParameters.length);
    }

    public void setMsgAuthenticationParameters(byte value, int offset) {
        this.msgAuthenticationParameters[offset] = value;
    }

    public void setMsgPrivacyParameters(byte[] privacyParameters) {
        System.arraycopy(privacyParameters, 0, this.msgPrivacyParameters, 0, privacyParameters.length);
    }

    public void setMsgUserName(byte[] username) {
        this.msgUserName = Arrays.copyOf(username, username.length);
    }

    public void setMsgWholeMsg(byte[] wholeMsg, int msgLength) {
        this.msgWholeMsg = Arrays.copyOf(wholeMsg, msgLength);
    }

    public void setMsgWholeMsg(byte value, int offset) {
        this.msgWholeMsg[offset] = value;
    }

    public void setMsgAuthoritativeEngineBoots(long authoritativeEngineBoots) {
        this.msgAuthoritativeEngineBoots = authoritativeEngineBoots;
    }

    public void setMsgAuthoritativeEngineTime(long authoritativeEngineTime) {
        this.msgAuthoritativeEngineTime = authoritativeEngineTime;
    }

    public void setWholeMsgLength(int msgLength) {
        this.wholeMsgLength = msgLength;
    }

    public void setVariableBindingsLength(int variableBindingsLen) {
        this.variableBindingsLength = variableBindingsLen;
    }

    public void setEncryptedPDUOffset(int pduOffset) {
        this.encryptedPDUOffset = pduOffset;
    }

    public void setEncryptedPDULength(int pduLength) {
        this.encryptedPDULength = pduLength;
    }

    public void setMsgAuthenticationParametersOffset(int authParametersOffset) {
        this.msgAuthenticationParametersOffset = authParametersOffset;
    }

    public void setMsgVersion(int msgVer) {
        this.msgVersion = msgVer;
    }

    public void setContextEngineID(String engineID) {
        this.contextEngineID = engineID;
    }

    public void setContextName(String name) {
        this.contextName = name;
    }

    public void setSelUserName(String username) {
        this.seluserName = username;
    }

    public void setSelSensorName(String sensorName) {
        this.selSensorName = sensorName;
    }

    public void setSelSensorType(String sensorType) {
        this.selSensorType = sensorType;
    }

    public void setSelDescription(String description) {
        this.selDescription = description;
    }

    public void setSelRawData(String rawData) {
        this.selRawData = rawData;
    }

    public void setSelGUID(String guid) {
        this.selGUID = guid;
    }

    public void setVariableBindingsList(VariableBindings variableBindings) {
        this.variableBindingsList.add(variableBindings);
    }
}

