/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RedfishFlashARM
implements IPMIDCMOEMCommand.Progress {
    public static final int UPDATE_TYPE_BMC = 0;
    public static final int UPDATE_TYPE_BIOS = 1;
    public static final int UPDATE_TYPE_SCP = 2;
    private int imageOffset;
    private String imageVersion;
    private String imageBuildDate;
    private String inventoryVersion;
    private String inventoryBuildDate;
    private MOut mout = MOut.G();
    private IPMIDCMOEMCommand.Progress progress = this;
    int valueBak = 0;

    public void setDebugMessageDisable(boolean enable) {
        Logger.getLogger("org.apache.http").setLevel(enable ? Level.FINEST : Level.OFF);
        Logger.getLogger("org.apache.http.impl").setLevel(enable ? Level.FINEST : Level.OFF);
        Logger.getLogger("org.apache.http.impl.execchain.RetryExec").setLevel(enable ? Level.FINEST : Level.OFF);
        Logger.getLogger("org.apache.http.wire").setLevel(Level.OFF);
        Logger.getLogger("org.apache.http.headers").setLevel(Level.OFF);
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "false");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "ERROR");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "ERROR");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.headers", "ERROR");
    }

    public boolean flash(IPMIInterfaceConfig config, String filename, int imageType) {
        BasicAuthClient authClient = null;
        this.setDebugMessageDisable(GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0);
        return this.getFileInfo(config, filename, imageType) && this.getTargetInfo(config, filename, imageType) && (authClient = this.setImageUpload(config, filename, imageType)) != null && this.getUpdateProgress(authClient, config, imageType) && this.checkFinalState(config, imageType);
        {
        }
    }

    private boolean getFileInfo(IPMIInterfaceConfig config, String filename, int imageType) {
        boolean result = true;
        if (imageType == 0 || imageType == 2) {
            this.mout.print("Check firmware file...");
            if (this.checkImageVersion(filename)) {
                String versionInfo = "ver:" + this.imageVersion;
                String buildDateInfo = imageType == 0 ? ", build:" + this.imageBuildDate : "";
                this.mout.println(" Done (" + versionInfo + buildDateInfo + ")");
            } else {
                this.mout.println(" Failed");
                result = false;
            }
        }
        return result;
    }

    private boolean getTargetInfo(IPMIInterfaceConfig config, String filename, int imageType) {
        block0: {
            block2: {
                block3: {
                    block1: {
                        if (imageType == 1) break block0;
                        this.mout.print("Check " + (imageType == 0 ? "BMC" : "SCP") + " status...");
                        if (imageType != 0) break block1;
                        if (!this.getFirmwareInventoryInfo(config, true)) break block2;
                        this.mout.println(" Done (ver:" + this.inventoryVersion + ", build:" + this.inventoryBuildDate + ")");
                        break block0;
                    }
                    if (imageType != 2) break block3;
                    if (!this.getScpInfo(config)) break block2;
                    this.mout.println(" Done (ver:" + this.inventoryVersion + ")");
                    break block0;
                }
                this.mout.println(" unkonwn type");
            }
            this.mout.println(" Failed");
            return false;
        }
        return true;
    }

    private BasicAuthClient setImageUpload(IPMIInterfaceConfig config, String filename, int imageType) {
        this.mout.print("Uploading file ");
        BasicAuthClient authClient = new BasicAuthClient(config);
        int statusCode = 0;
        try {
            String body = null;
            if (imageType == 0) {
                body = "{\"Targets\":[\"/redfish/v1/UpdateService/FirmwareInventory/BMC\"],\"@Redfish.OperationApplyTime\":\"Immediate\"}";
            } else if (imageType == 1) {
                body = "{\"Targets\":[\"/redfish/v1/UpdateService/FirmwareInventory/BIOS\"],\"@Redfish.OperationApplyTime\":\"Immediate\"}";
            } else if (imageType == 2) {
                body = "{\"Targets\":[],\"@Redfish.OperationApplyTime\":\"Immediate\"}";
            }
            statusCode = authClient.post_https_Update_multipart(this.getRestfulUrlUpdateService(config), filename, body, this.progress);
        }
        catch (Exception e) {
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                e.printStackTrace();
            }
            this.mout.print(" Failed");
            return null;
        }
        if (statusCode >= 200 && statusCode <= 210) {
            this.mout.println(" " + this.valueBak + "%");
            this.resetValue();
            return authClient;
        }
        RedfishHttpUtils.printFailMessage(statusCode, authClient.getResponseString());
        return null;
    }

    private boolean getUpdateProgress(BasicAuthClient authClient, IPMIInterfaceConfig config, int imageType) {
        this.mout.print("Updating       ");
        if (imageType != 0) {
            if (!this.pollingTaskProgress(authClient, config)) {
                this.mout.print(" Failed");
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean checkFinalState(IPMIInterfaceConfig config, int imageType) {
        if (this.isNetworkReachable(config.getIp()) && this.checkBootupState(config)) {
            this.mout.println(" Done");
            return true;
        }
        this.mout.println(" Failed");
        return false;
    }

    private boolean pollingTaskProgress(BasicAuthClient authClient, IPMIInterfaceConfig config) {
        long POLLING_INTERVAL = 1000L;
        int retryLimit = 5;
        int percentage = 0;
        int retryCount = 0;
        boolean result = false;
        String currentTaskURL = null;
        while (true) {
            block10: {
                try {
                    if (currentTaskURL == null) {
                        currentTaskURL = this.getRestfulUrlCurrentTask(authClient, config);
                    }
                    int n = percentage = currentTaskURL != null ? this.getTaskPercentage(authClient, currentTaskURL) : -1;
                    if (percentage >= 0) {
                        retryCount = 0;
                        this.progress.setValue(percentage);
                        if (percentage == 100) {
                            result = true;
                            this.mout.println(" " + this.valueBak + "%");
                            break;
                        }
                    } else {
                        if (percentage == -1) break;
                        ++retryCount;
                    }
                }
                catch (Exception e) {
                    if (retryCount++ == 5) {
                        this.progress.setValue(100);
                        break;
                    }
                    if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL <= 0) break block10;
                    this.mout.println(e.getMessage());
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL <= 0) continue;
                this.mout.println(e.getMessage());
            }
        }
        return result;
    }

    private boolean getFirmwareInventoryInfo(IPMIInterfaceConfig config, boolean isBMCType) {
        block6: {
            this.inventoryVersion = null;
            this.inventoryBuildDate = null;
            String url = this.getFirmwareInventoryURL(config, isBMCType);
            RedfishHttpUtils utils = new RedfishHttpUtils();
            try {
                int result = utils.sendRedfishProbe(config, url, true);
                if (200 <= result && result <= 210) {
                    HashMap<String, String> map = utils.getEntry();
                    this.inventoryVersion = Optional.ofNullable(map.get("Version")).orElse("");
                    this.inventoryBuildDate = Optional.ofNullable(map.get("ReleaseDate")).orElse("");
                    return true;
                }
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                    RedfishHttpUtils.printFailMessage(result, utils.getRedfishResponse());
                }
            }
            catch (IOException e) {
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                    this.mout.println(e.getMessage());
                }
            }
            catch (Exception e) {
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL <= 0) break block6;
                this.mout.println(e.getMessage());
            }
        }
        return false;
    }

    private boolean getScpInfo(IPMIInterfaceConfig config) {
        block5: {
            RedfishHttpUtils utils = new RedfishHttpUtils();
            String url = "https://" + RedfishHttpUtils.getUrlIP(config.getIp()) + "/redfish/v1/Systems/1/";
            try {
                int result = utils.sendRedfishGet(config, url);
                if (200 <= result && result <= 210) {
                    HashMap<String, String> map = utils.getEntry();
                    for (Map.Entry<String, String> set : map.entrySet()) {
                        if (!set.getKey().toLowerCase().contains("scpversion")) continue;
                        this.inventoryVersion = set.getValue();
                        break;
                    }
                    return true;
                }
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                    RedfishHttpUtils.printFailMessage(result, utils.getRedfishResponse());
                }
            }
            catch (Exception e) {
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL <= 0) break block5;
                e.printStackTrace();
            }
        }
        return true;
    }

    private String getFirmwareInventoryURL(IPMIInterfaceConfig config, boolean isBMCType) {
        return "https://" + RedfishHttpUtils.getUrlIP(config.getIp()) + "/redfish/v1/UpdateService/" + "FirmwareInventory" + (isBMCType ? "/BMC" : "/BIOS");
    }

    private String getRestfulUrlUpdateService(IPMIInterfaceConfig config) {
        return "https://" + RedfishHttpUtils.getUrlIP(config.getIp()) + "/redfish/v1/UpdateService/" + "update";
    }

    private String getRestfulUrlTaskService(IPMIInterfaceConfig config) {
        return "https://" + RedfishHttpUtils.getUrlIP(config.getIp()) + "/redfish/v1/TaskService/" + "Tasks";
    }

    private String getRestfulUrlCurrentTask(BasicAuthClient client, IPMIInterfaceConfig config) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode currentNode = mapper.readTree(client.getResponseString());
        JsonNode taskIdNode = currentNode != null ? currentNode.path("Id") : null;
        return taskIdNode != null ? this.getRestfulUrlTaskService(config) + "/" + taskIdNode.asText() : "";
    }

    private int getTaskPercentage(BasicAuthClient client, String url) throws Exception {
        int code = client.send_https_get(url);
        if (200 <= code && code <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode currentNode = mapper.readTree(client.getResponseString());
            JsonNode percentNode = currentNode.path("PercentComplete");
            JsonNode stateNode = currentNode.path("TaskState");
            String stateStr = stateNode.asText();
            int result = stateStr.equalsIgnoreCase("Running") || stateStr.equalsIgnoreCase("Completed") ? percentNode.asInt() : -1;
            return result;
        }
        return -2;
    }

    private boolean checkImageVersion(String filename) {
        File firmware = new File(filename);
        byte[] fileContent = null;
        try {
            fileContent = Files.readAllBytes(firmware.toPath());
        }
        catch (IOException e) {
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                e.printStackTrace();
            }
            return false;
        }
        String majorMarkerStr = "version=";
        String minorMarkerStr = "BuildId=";
        this.imageOffset = 0;
        this.imageVersion = null;
        this.imageBuildDate = null;
        this.imageVersion = this.findMatchString(fileContent, "version=", this.imageOffset);
        this.imageBuildDate = this.findMatchString(fileContent, "BuildId=", this.imageOffset);
        return this.imageVersion != null;
    }

    private boolean isNetworkReachable(String ipAddress) {
        int reachableTimes = 0;
        int stableTimes = 10;
        long durationBackup = 0L;
        long durationMills = 0L;
        boolean isReachable = false;
        int REACH_TIMEOUT = 250;
        int CHECK_TIMEOUT = 900000;
        int CHECK_INTERVAL = 1000;
        int PRINT_INTERVAL = 5000;
        Instant beginTimestamp = Instant.now();
        do {
            Instant currentTimestamp;
            try {
                Thread.sleep(1000L);
                InetAddress address = InetAddress.getByName(ipAddress);
                isReachable = address.isReachable(250);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            if (isReachable) {
                if (reachableTimes++ >= stableTimes) {
                    break;
                }
            } else {
                reachableTimes = 0;
            }
            if ((durationMills = Duration.between(beginTimestamp, currentTimestamp = Instant.now()).toMillis()) - durationBackup < 5000L) continue;
            this.mout.print(".");
            durationBackup = durationMills;
        } while (durationMills < 900000L);
        return isReachable;
    }

    private boolean checkBootupState(IPMIInterfaceConfig config) {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(config, ipmiSDRCommand, 10);
        if (sessionController == null) {
            return false;
        }
        byte[] guid = new IPMIMessagingCommand(ipmiSDRCommand.getIPMIInterface()).getSystemGUID();
        int retryLimit = 360;
        int retryCount = 0;
        block6: do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mout.print(".");
            SDRInfo sdrInfo = null;
            try {
                sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
                if (sdrInfo == null) {
                }
            }
            catch (Exception e) {}
            continue;
            ArrayList<String> sdrStringList = new ArrayList<String>();
            try {
                sdrStringList.addAll(ipmiSDRCommand.getSDRBuffer(sdrInfo.getRecordCount(), false, true, guid));
            }
            catch (Exception e) {
                continue;
            }
            for (String reading : sdrStringList) {
                if (!reading.contains("System Temp") || !reading.contains("OK")) continue;
                retryCount = 360;
                continue block6;
            }
        } while (retryCount++ < 360);
        if (sessionController != null) {
            sessionController.closeSession();
        }
        return true;
    }

    public void resetValue() {
        this.valueBak = 0;
    }

    public void printPercentage() {
        if (this.valueBak == 100) {
            this.mout.print(" 100%");
        }
    }

    @Override
    public void setValue(int value) {
        if (value > this.valueBak) {
            for (int i = 0; i < value - this.valueBak; ++i) {
                if ((i + value) % 2 != 0) continue;
                this.mout.print(">");
            }
            this.valueBak = value;
        }
    }

    @Override
    public void message(String message) {
        this.mout.print("\n" + message);
    }

    @Override
    public void left(long value) {
    }

    public int indexOf(byte[] data, byte[] pattern, int dataOffset) {
        if (data.length == 0) {
            return -1;
        }
        int[] failure = this.computeFailure(pattern);
        int j = 0;
        for (int i = dataOffset; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    public String findMatchString(byte[] content, String keyword, int offset) {
        byte[] keywordBytes = keyword.getBytes();
        int keywordLen = keyword.length();
        int contentLen = content.length;
        int position = this.indexOf(content, keywordBytes, offset);
        if (position >= 0) {
            int index;
            this.imageOffset = position;
            for (index = position + keywordLen; index < contentLen && content[index] != 13 && content[index] != 10; ++index) {
            }
            if (index - (position + keywordLen) > 0) {
                byte[] value = new byte[index - (position + keywordLen)];
                System.arraycopy(content, position + keywordLen, value, 0, value.length);
                return new String(value);
            }
            return null;
        }
        return null;
    }
}

