/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;
import java.util.ArrayList;

public class ADAddAddressCommand
extends RedfishTokenCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 2) {
            this.printUsage();
            return false;
        }
        try {
            int port = Integer.parseInt(this.parameters[1]);
            if (port < 1 || port > 65535) {
                MOut.G(this).println("Port number must be between 1 and 65535");
                return false;
            }
        }
        catch (NumberFormatException e) {
            MOut.G(this).println("Port number must be between 1 and 65535");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode ActiveDirectory = node.path("ActiveDirectory");
            JsonNode ServiceEnabled = ActiveDirectory.path("ServiceEnabled");
            JsonNode ServiceAddress = ActiveDirectory.path("ServiceAddresses");
            JsonNode RemoteRole = ActiveDirectory.path("RemoteRoleMapping");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                ArrayList<String> list = new ArrayList<String>();
                if (ServiceAddress.isArray()) {
                    if (ServiceAddress.size() == 3) {
                        MOut.G(this).println("Address list can only support up to 3 server addresses");
                        this.statusCode = 149;
                        return;
                    }
                    for (int i = 0; i < ServiceAddress.size(); ++i) {
                        list.add(ServiceAddress.get(i).asText());
                    }
                }
                String source = "ldap://" + this.parameters[0] + ":" + this.parameters[1];
                list.add(source);
                String body = "{\"ActiveDirectory\": {\"ServiceAddresses\":[";
                for (int i = 0; i < list.size(); ++i) {
                    body = body + "\"" + (String)list.get(i) + "\",";
                    if (i != list.size() - 1) continue;
                    body = body.substring(0, body.length() - 2);
                }
                result = this.sessionLoginClient.send_https_patch(url, body = body + "\"]}}");
                if (result < 200 || result > 210) {
                    MOut.G(this).println("Action failed. ErrorCode:" + result);
                    this.statusCode = 149;
                    return;
                }
            } else {
                MOut.G(this).println("Active Directory is disabled");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Fail to read Active Directory information. ErrorCode:" + result);
            this.statusCode = 149;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish accountService ad addAddress <IP> <Port>");
    }
}

