/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import java.util.regex.Pattern;

public abstract class AlertSetBaseCommand
extends RedfishCommand {
    public static final String AUTH_PROTOCOL_MD5 = "HMAC_MD5";
    public static final String AUTH_PROTOCOL_SHA96 = "HMAC_SHA96";
    public static final String PRIV_PROTOCOL_DES = "CBC_DES";
    public static final String PRIV_PROTOCOL_AES = "CFB128_AES128";

    public static boolean isSupported(IPMIInterfaceConfig config) {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDbyConfig(config);
        return !IPMIMessagingCommand.isBeforeX12(guid);
    }

    protected boolean isValidInteger(String integer) {
        try {
            Integer.valueOf(integer);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected boolean isValidNumber(String number) {
        int numberInt = 0;
        try {
            numberInt = Integer.valueOf(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return 0 < numberInt && numberInt <= 16;
    }

    protected boolean isValidKey(String key) {
        return key.length() >= 8 && key.length() <= 64 && key.chars().filter(c -> 48 <= c && c <= 57).findAny().isPresent() && key.chars().filter(c -> 65 <= c && c <= 90).findAny().isPresent() && key.chars().filter(c -> 97 <= c && c <= 122).findAny().isPresent();
    }

    protected boolean isValidIPv4(String ip) {
        String chunkIPv4 = "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
        Pattern IPV4_STD_REGEX = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$");
        return IPV4_STD_REGEX.matcher(ip).matches();
    }

    protected boolean isValidIP(String ip) {
        String chunkIPv6 = "[0-9a-fA-F]{1,4}";
        Pattern IPV6_STD_REGEX = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        Pattern IPV6_COMPRESS_REGEX = Pattern.compile("^((?:[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)::((?:([0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4})?)$");
        Pattern IPV6_COMPRESS_REGEX_BORDER = Pattern.compile("^(::(?:[0-9a-fA-F]{1,4})(?::[0-9a-fA-F]{1,4}){5})|((?:[0-9a-fA-F]{1,4})(?::[0-9a-fA-F]{1,4}){5}::)$");
        return this.isValidIPv4(ip) || IPV6_STD_REGEX.matcher(ip).matches() || IPV6_COMPRESS_REGEX.matcher(ip).matches() || IPV6_COMPRESS_REGEX_BORDER.matcher(ip).matches();
    }

    protected boolean isValidURL(String url) {
        String[] values = url.split(":");
        if (null == values || values.length < 3) {
            return false;
        }
        if (values.length > 0 && !this.isValidInteger(values[values.length - 1])) {
            return false;
        }
        return url.toLowerCase().startsWith("http") || url.toLowerCase().startsWith("https");
    }

    protected boolean isValidSeverity(String severity) {
        return severity.equals("0") || severity.equals("1") || severity.equals("2");
    }

    protected boolean isValidEMail(String addr) {
        return addr.contains("@");
    }

    protected String getSeverity(String severity) {
        if (severity.equals("0")) {
            return "Information";
        }
        if (severity.equals("1")) {
            return "Warning";
        }
        if (severity.equals("2")) {
            return "Critical";
        }
        return null;
    }

    protected String getAuthenticationProtocolString(String indexStr) {
        Integer index = null;
        try {
            index = Integer.valueOf(indexStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (index != null) {
            if (index == 0) {
                return AUTH_PROTOCOL_MD5;
            }
            if (index == 1) {
                return AUTH_PROTOCOL_SHA96;
            }
        }
        return null;
    }

    protected String getPrivacyProtocolString(String indexStr) {
        Integer index = null;
        try {
            index = Integer.valueOf(indexStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (index != null) {
            if (index == 0) {
                return PRIV_PROTOCOL_DES;
            }
            if (index == 1) {
                return PRIV_PROTOCOL_AES;
            }
        }
        return null;
    }

    protected void runPatchCommand(String uri, String body) throws Exception {
        BasicAuthClient client = new BasicAuthClient(this.config);
        int responseResult = client.send_https_patch(uri, body);
        if (responseResult == 200) {
            this.statusCode = 0;
            MOut.G(this).println("Done");
        } else if (responseResult == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
        } else {
            this.statusCode = 149;
            this.printFailMessage(responseResult, client.getResponseString());
        }
    }
}

