/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.AlertSetBaseCommand;
import com.supermicro.redfish.text.SNMPBaseCommand;

public class AlertSetSNMPv3Command
extends AlertSetBaseCommand {
    public static final String URI_SUFFIX = "EventService/Subscriptions/";
    public static final String JSON_TEMPLATE = "{\"Oem\":{\"Supermicro\":{\"EnableSubscription\":true,\"UserName\":\"%s\",\"Severity\":\"%s\"}},\"Protocol\":\"SNMPv3\",\"Destination\":\"%s\",\"SNMP\":{\"AuthenticationProtocol\":\"%s\",\"EncryptionProtocol\":\"%s\",\"AuthenticationKey\":\"%s\",\"EncryptionKey\":\"%s\"},\"EventTypes\":[\"Alert\"]}";

    @Override
    public boolean preValidate() {
        Integer encryptionIndex;
        block13: {
            Integer authIndex;
            block12: {
                if (null == this.parameters || this.parameters.length != 8) {
                    this.usage();
                    this.statusCode = 147;
                    return false;
                }
                if (!this.isValidNumber(this.parameters[0])) {
                    this.statusCode = 147;
                    MOut.G(this).println("Number should be a integer in 1-16 range.");
                    this.usage();
                    return false;
                }
                if (!this.isValidSeverity(this.parameters[1])) {
                    this.statusCode = 147;
                    MOut.G(this).println("It is an invalid severity value.");
                    this.usage();
                    return false;
                }
                if (!this.isValidIP(this.parameters[2])) {
                    this.statusCode = 147;
                    MOut.G(this).println("It is an invalid IP format.");
                    this.usage();
                    return false;
                }
                authIndex = null;
                try {
                    authIndex = Integer.valueOf(this.parameters[4]);
                }
                catch (NumberFormatException ex) {
                    if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL == 0) break block12;
                    MOut.G(this).println(ex.getMessage());
                }
            }
            if (authIndex == null || authIndex < 0 || 1 < authIndex) {
                this.statusCode = 147;
                MOut.G(this).println("It is an invalid authentication protocol.");
                this.usage();
                return false;
            }
            if (!this.isValidKey(this.parameters[5])) {
                this.statusCode = 147;
                MOut.G(this).println("It is an invalid authentication key.");
                this.usage();
                return false;
            }
            encryptionIndex = null;
            try {
                encryptionIndex = Integer.valueOf(this.parameters[6]);
            }
            catch (NumberFormatException ex) {
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL == 0) break block13;
                MOut.G(this).println(ex.getMessage());
            }
        }
        if (encryptionIndex == null || encryptionIndex < 0 || 1 < encryptionIndex) {
            this.statusCode = 147;
            MOut.G(this).println("It is an invalid encryption protocol.");
            this.usage();
            return false;
        }
        if (!this.isValidKey(this.parameters[7])) {
            this.statusCode = 147;
            MOut.G(this).println("It is an invalid encryption key.");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!AlertSetBaseCommand.isSupported(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String jsonBody = String.format(JSON_TEMPLATE, this.parameters[3], this.getSeverity(this.parameters[1]), this.parameters[2], this.getAuthenticationProtocolString(this.parameters[4]), this.getPrivacyProtocolString(this.parameters[6]), this.parameters[5], this.parameters[7]);
        String redfishURI = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/" + URI_SUFFIX + Integer.valueOf(this.parameters[0]);
        this.runPatchCommand(redfishURI, jsonBody);
    }

    private void usage() {
        MOut.G(this).println("Usage: redfish eventService alert setSNMPv3 <number> <severity> <destination> <username> ");
        MOut.G(this).println("       <authenticationProtocol> <authenticationKey> <encryptionProtocol> <encryptionKey>");
        MOut.G(this).println("Severity: ");
        MOut.G(this).println(" Information : 0");
        MOut.G(this).println(" Warning     : 1");
        MOut.G(this).println(" Critical    : 2");
        MOut.G(this).println("Destination: ");
        MOut.G(this).println(" IPv4/IPv6 format");
        MOut.G(this).println("AuthenticationProtocol: ");
        MOut.G(this).println(" " + SNMPBaseCommand.SNMP_AUTH_PROTOCOL_ABBR_MD5 + "   : 0");
        MOut.G(this).println(" " + SNMPBaseCommand.SNMP_AUTH_PROTOCOL_ABBR_SHA + " : 1");
        MOut.G(this).println("EncryptionKeyProtocol: ");
        MOut.G(this).println(" " + SNMPBaseCommand.SNMP_PRIV_PROTOCOL_ABBR_DES + "    : 0");
        MOut.G(this).println(" " + SNMPBaseCommand.SNMP_PRIV_PROTOCOL_ABBR_AES + " : 1");
        MOut.G(this).println("AuthenticationKey/EncryptionKey: ");
        MOut.G(this).println(" Need lowercase, uppercase and numbers. Should be in the range of 8-64 characters.");
    }
}

