/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BIOSAttributeSchema {
    public static final int VALUE_TYPE_ENUM = 0;
    public static final int VALUE_TYPE_BOOL = 1;
    public static final int VALUE_TYPE_STRING = 2;
    public static final int VALUE_TYPE_INTEGER = 3;
    public static final int VALUE_TYPE_PASSWORD = 4;
    public static final int VALUE_TYPE_TEXT = 5;
    public static final int VALUE_TYPE_SUBTITLE = 6;
    public static final int VALUE_TYPE_GOTO = 7;
    public static final int VALUE_TYPE_UNDEFINE = 8;
    private int valueType;
    private boolean isReadOnly;
    private boolean isGrayOut;
    private boolean isHidden;
    private boolean isProtected;
    private String path;
    private String attributeName;
    private String displayName;
    private String commandName;
    private String description;
    private ValueRules valueRules = new ValueRules();

    public boolean isValidAttribute(String value) {
        return this.valueRules.isValid(this.valueType, value);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isGrayOut() {
        return this.isGrayOut;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public int getValueType() {
        return this.valueType;
    }

    public String getPath() {
        return this.path;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getConvertedEnumString(String value) {
        return this.valueRules.getEnumString(value);
    }

    public String getConvertedBoolString(String value) {
        return this.valueRules.getBoolString(value);
    }

    public String getValueRulesDescription() {
        return this.valueRules.getValueRulesDesc(this.valueType);
    }

    public void setValueType(String valueType) {
        this.valueType = this.getValueTypeEnum(valueType);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setGrayOuty(boolean isGrayOut) {
        this.isGrayOut = isGrayOut;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAttributeName(String name) {
        this.attributeName = name;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public void setCommandName(String name) {
        this.commandName = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setValueRules(BigDecimal lowerBound, BigDecimal upperBound, Integer scalarIncrement) {
        this.valueRules.setIntegerRange(lowerBound, upperBound, scalarIncrement);
    }

    public void setValueRules(Integer minLength, Integer maxLength) {
        this.valueRules.setStringLength(minLength, maxLength);
    }

    public void setValueRules(String enumeration) {
        this.valueRules.setEnum(enumeration);
    }

    private int getValueTypeEnum(String type) {
        if (type.equalsIgnoreCase("Enumeration")) {
            return 0;
        }
        if (type.equalsIgnoreCase("Boolean")) {
            return 1;
        }
        if (type.equalsIgnoreCase("Integer")) {
            return 3;
        }
        if (type.equalsIgnoreCase("String")) {
            return 2;
        }
        if (type.equalsIgnoreCase("Password")) {
            return 4;
        }
        return 8;
    }

    private class ValueRules {
        private int enumItemMaxLength;
        private Map<Integer, String> enumMap;
        private BigDecimal integerLowerBound;
        private BigDecimal integerUpperBound;
        private Integer integerScalarIncrement;
        private Integer stringMinLength;
        private Integer stringMaxLength;

        private String getStringEnum() {
            StringBuffer buffer = new StringBuffer();
            String formatTemplate = " %-" + this.enumItemMaxLength + "s : %2d";
            ArrayList<Map.Entry<Integer, String>> list = new ArrayList<Map.Entry<Integer, String>>(this.enumMap.entrySet());
            list.sort(Map.Entry.comparingByKey());
            for (int index = 0; index < list.size(); ++index) {
                buffer.append(String.format(formatTemplate, ((Map.Entry)list.get(index)).getValue(), ((Map.Entry)list.get(index)).getKey()));
                if (index == list.size() - 1) continue;
                buffer.append("\n");
            }
            return buffer.toString();
        }

        private String getStringLengthLimitation() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Minimum Length: ").append(this.stringMinLength).append("\n");
            buffer.append("Maximum Length: ").append(this.stringMaxLength);
            return buffer.toString();
        }

        private String getIntegerBoundary() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("LowerBound:      ").append(this.integerLowerBound.longValue()).append("\n");
            buffer.append("UpperBound:      ").append(this.integerUpperBound.longValue()).append("\n");
            buffer.append("ScalarIncrement: ").append(this.integerScalarIncrement);
            return buffer.toString();
        }

        private String getBooleanEnum() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("False: 0").append("\n");
            buffer.append("True:  1");
            return buffer.toString();
        }

        private Integer getIntegerObject(String obj) {
            Integer result = null;
            if (obj == null) {
                return result;
            }
            try {
                result = Integer.valueOf(obj.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }

        public String getValueRulesDesc(int valueType) {
            if (valueType == 0) {
                return this.getStringEnum();
            }
            if (valueType == 2) {
                return this.getStringLengthLimitation();
            }
            if (valueType == 3) {
                return this.getIntegerBoundary();
            }
            if (valueType == 1) {
                return this.getBooleanEnum();
            }
            return "";
        }

        public String getEnumString(String parameter) {
            try {
                Integer index = Integer.valueOf(parameter);
                if (0 <= index && index < this.enumMap.size()) {
                    return this.enumMap.get(index);
                }
                return parameter;
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                for (Integer index : this.enumMap.keySet()) {
                    if (!this.enumMap.get(index).equals(parameter)) continue;
                    return String.valueOf(index);
                }
                return null;
            }
        }

        public String getBoolString(String parameter) {
            try {
                int index = Integer.valueOf(parameter);
                if (index == 0) {
                    return "false";
                }
                if (index == 1) {
                    return "true";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return parameter.toLowerCase();
        }

        public void setIntegerRange(BigDecimal lowerBound, BigDecimal upperBound, Integer scalarIncrement) {
            this.integerLowerBound = lowerBound;
            this.integerUpperBound = upperBound;
            this.integerScalarIncrement = scalarIncrement;
        }

        public void setStringLength(Integer minLength, Integer maxLength) {
            this.stringMinLength = minLength;
            this.stringMaxLength = maxLength;
        }

        public void setEnum(String enumeration) {
            if (this.enumMap == null) {
                this.enumMap = new HashMap<Integer, String>();
            }
            if (enumeration.contains("`")) {
                if (enumeration.contains("~")) {
                    String[] enums;
                    for (String str : enums = enumeration.split("~")) {
                        String[] token = str.split("`");
                        Integer index = null;
                        String value = null;
                        index = this.getIntegerObject(token[0]);
                        if (index != null) {
                            value = token[1];
                        } else {
                            index = this.getIntegerObject(token[1]);
                            value = token[0];
                        }
                        if (value != null) {
                            this.enumItemMaxLength = Math.max(value.length(), this.enumItemMaxLength);
                        }
                        if (index != null) {
                            this.enumMap.put(index, value);
                            continue;
                        }
                        this.enumMap.put(this.enumMap.size(), value != null ? value : "N/A");
                    }
                } else {
                    String[] enums;
                    int index = 0;
                    for (String str : enums = enumeration.split("`")) {
                        this.enumMap.put(index++, str);
                        this.enumItemMaxLength = Math.max(str.length(), this.enumItemMaxLength);
                    }
                }
            } else {
                String[] enums = enumeration.split("~");
                for (int idx = 0; idx < enums.length; ++idx) {
                    this.enumMap.put(idx, enums[idx]);
                    this.enumItemMaxLength = Math.max(enums[idx].length(), this.enumItemMaxLength);
                }
            }
        }

        public boolean isValid(int valueType, Object valueObject) {
            boolean result;
            block18: {
                result = true;
                if (valueType == 0) {
                    result = false;
                    for (Integer index : this.enumMap.keySet()) {
                        block17: {
                            try {
                                if (!((Object)index).equals(Integer.valueOf(String.valueOf(valueObject)))) break block17;
                                result = true;
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!this.enumMap.get(index).equals(valueObject)) continue;
                        result = true;
                        break;
                    }
                } else if (valueType == 3) {
                    result = false;
                    try {
                        BigDecimal val = new BigDecimal(String.valueOf(valueObject));
                        BigDecimal rem = new BigDecimal(this.integerScalarIncrement);
                        if (this.integerLowerBound.compareTo(val) <= 0 && this.integerUpperBound.compareTo(val) >= 0 && (rem.intValue() == 0 || val.subtract(this.integerLowerBound).remainder(rem).intValue() == 0)) {
                            result = true;
                        }
                    }
                    catch (NumberFormatException val) {}
                } else if (valueType == 2) {
                    String value = String.valueOf(valueObject);
                    result = value != null && value.length() >= this.stringMinLength && this.stringMaxLength >= value.length();
                } else if (valueType == 1) {
                    String value = String.valueOf(valueObject);
                    if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                        result = true;
                    } else {
                        block19: {
                            try {
                                int index = Integer.valueOf(value);
                                if (0 != index && index != 1) break block19;
                                result = true;
                                break block18;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        result = false;
                    }
                }
            }
            return result;
        }
    }
}

