/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.text.BIOSAttributeSchema;
import com.supermicro.redfish.text.BIOSConfigurationBaseCommand;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BIOSConfigurationPendingListCommand
extends BIOSConfigurationBaseCommand {
    public static final String FIELD_NAME = "Total attributes";
    public static final String FIELD2_NAME = "Command name";
    public static final String FIELD3_NAME = "Current value";
    public static final String FIELD4_NAME = "Pending value";

    @Override
    public void runCommand() throws Exception {
        if (!super.isCommandAvailable()) {
            return;
        }
        if (this.outputList()) {
            this.statusCode = 0;
        } else {
            this.statusCode = 149;
            MOut.G(this).println("Failed");
        }
    }

    private boolean outputList() {
        HashMap<String, String> sdHashmap = null;
        Map<String, String> attributeHashMap = null;
        Map<String, BIOSAttributeSchema> schemaHashmap = null;
        try {
            sdHashmap = super.getHelper().getAttributeSDCollection();
            if (sdHashmap == null) {
                return false;
            }
            schemaHashmap = super.getHelper().getSchemaHashMap();
            if (schemaHashmap == null) {
                return false;
            }
            attributeHashMap = super.getHelper().getAttributeMap();
            if (attributeHashMap == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(sdHashmap);
        Set<String> sdKeySet = treeMap.keySet();
        int count = 0;
        if (!sdKeySet.isEmpty()) {
            int i;
            Iterator<String> ite = sdKeySet.iterator();
            StringBuffer buffer = new StringBuffer();
            int commandMaxLength = 0;
            int valueMaxLength = 0;
            while (ite.hasNext()) {
                String key = ite.next().toString();
                String keyConverted = super.getHelper().convertNonAsciiSymbol(key);
                String commandName = schemaHashmap.get(keyConverted).getCommandName();
                commandMaxLength = Math.max(commandMaxLength, commandName.length());
                valueMaxLength = Math.max(valueMaxLength, ((String)sdHashmap.get(key)).length());
                valueMaxLength = Math.max(valueMaxLength, attributeHashMap.get(key).length());
            }
            if (commandMaxLength < FIELD_NAME.length()) {
                commandMaxLength = FIELD_NAME.length();
            }
            if (valueMaxLength < FIELD4_NAME.length()) {
                valueMaxLength = FIELD4_NAME.length();
            }
            if (valueMaxLength > 40) {
                valueMaxLength = 40;
            }
            ite = sdKeySet.iterator();
            String firstBar = "";
            String secondBar = "";
            String formatTemplate = null;
            for (i = 0; i < commandMaxLength; ++i) {
                firstBar = firstBar + "-";
            }
            for (i = 0; i < valueMaxLength; ++i) {
                secondBar = secondBar + "-";
            }
            formatTemplate = " %-" + commandMaxLength + "s | %-" + valueMaxLength + "s | %-" + valueMaxLength + "s \n";
            buffer.append(String.format(formatTemplate, firstBar, secondBar, secondBar));
            buffer.append(String.format(formatTemplate, FIELD2_NAME, FIELD3_NAME, FIELD4_NAME));
            buffer.append(String.format(formatTemplate, firstBar, secondBar, secondBar));
            while (ite.hasNext()) {
                String key = ite.next().toString();
                String keyConverted = super.getHelper().convertNonAsciiSymbol(key);
                String attributeValue = super.getHelper().getShortenValue(attributeHashMap.get(key));
                String sdValue = super.getHelper().getShortenValue((String)sdHashmap.get(key));
                BIOSAttributeSchema schema = schemaHashmap.get(keyConverted);
                buffer.append(String.format(formatTemplate, super.getHelper().convertNonAsciiSymbol(schema.getCommandName()), attributeValue, sdValue));
                ++count;
            }
            buffer.append(String.format(formatTemplate, firstBar, secondBar, secondBar));
            buffer.append(String.format(formatTemplate, FIELD_NAME, "", String.valueOf(count)));
            System.out.print(buffer.toString());
        } else {
            System.out.println("Pending setting list is empty");
        }
        return true;
    }
}

