/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.HashMap;

public abstract class SNMPBaseCommand
extends RedfishCommand {
    public static final String REDFISH_MANAGERS_NETWORK_PROTOCOL_URL = "/redfish/v1/Managers/1/NetworkProtocol";
    public static final String REDFISH_SNMP_COMMUNITY_TEMPLATE = "{\"SNMP\": {\"CommunityStrings\": [%s]}}";
    public static final String REDFISH_SNMP_PROTOCOL_ROOT = "SNMP";
    public static final String REDFISH_SNMP_PROTOCOL_ENABLED = "SNMP/ProtocolEnabled";
    public static final String REDFISH_SNMP_PROTOCOL_ENABLED_V2 = "SNMP/EnableSNMPv2c";
    public static final String REDFISH_SNMP_PROTOCOL_ENABLED_V3 = "SNMP/EnableSNMPv3";
    public static final String REDFISH_SNMP_PROTOCOL_AUTH = "SNMP/AuthenticationProtocol";
    public static final String REDFISH_SNMP_PROTOCOL_PRIV = "SNMP/EncryptionProtocol";
    public static final String REDFISH_SNMP_PROTOCOL_HIDE_COMMUNITY = "SNMP/HideCommunityStrings";
    public static final String REDFISH_SNMP_PROTOCOL_NAME = "Name";
    public static final String REDFISH_SNMP_PROTOCOL_COMM = "CommunityString";
    public static final String REDFISH_SNMP_PROTOCOL_ACCESS_MODE = "AccessMode";
    public static final String REDFISH_SNMP_PROTOCOL_ACCESS_FULL = "Full";
    public static final String REDFISH_SNMP_PROTOCOL_ACCESS_LIMIT = "Limited";
    public static final String REDFISH_SNMP_PROTOCOL_READ_ONLY = "ReadOnly";
    public static final String REDFISH_SNMP_PROTOCOL_READ_WRITE = "ReadWrite";
    public static final String SNMP_AUTH_PROTOCOL_MD5 = "HMAC_MD5";
    public static final String SNMP_AUTH_PROTOCOL_SHA = "HMAC_SHA96";
    public static final String SNMP_PRIV_PROTOCOL_DES = "CBC_DES";
    public static final String SNMP_PRIV_PROTOCOL_AES = "CFB128_AES128";
    public static final String SNMP_PRIV_PROTOCOL_NONE = "None";
    public static String SNMP_AUTH_PROTOCOL_ABBR_MD5 = "MD5";
    public static String SNMP_AUTH_PROTOCOL_ABBR_SHA = "SHA";
    public static String SNMP_PRIV_PROTOCOL_ABBR_DES = "DES";
    public static String SNMP_PRIV_PROTOCOL_ABBR_AES = "AES";
    public static String SNMP_COMMONE_PROTOCOL_ACCOUNT = "Account";
    public static final int SNMP_STATUS_DISABLE = 0;
    public static final int SNMP_STATUS_ENABLE = 1;
    public static final int SNMP_AUTH_ENUM_MD5 = 0;
    public static final int SNMP_AUTH_ENUM_SHA = 1;
    public static final int SNMP_PRIV_ENUM_DES = 0;
    public static final int SNMP_PRIV_ENUM_AES = 1;

    public SNMPBaseCommand() {
        if (GlobalDefine.THALES_PROJECT) {
            SNMP_AUTH_PROTOCOL_ABBR_SHA = "SHA96";
            SNMP_PRIV_PROTOCOL_ABBR_AES = "AES128";
        }
    }

    public static String getAuthProtocol(int index, boolean isAbbr) {
        if (index == 0) {
            return isAbbr ? SNMP_AUTH_PROTOCOL_ABBR_MD5 : SNMP_AUTH_PROTOCOL_MD5;
        }
        if (index == 1) {
            return isAbbr ? SNMP_AUTH_PROTOCOL_ABBR_SHA : SNMP_AUTH_PROTOCOL_SHA;
        }
        return null;
    }

    public static String getPrivProtocol(int index, boolean isAbbr) {
        if (index == 0) {
            return isAbbr ? SNMP_PRIV_PROTOCOL_ABBR_DES : SNMP_PRIV_PROTOCOL_DES;
        }
        if (index == 1) {
            return isAbbr ? SNMP_PRIV_PROTOCOL_ABBR_AES : SNMP_PRIV_PROTOCOL_AES;
        }
        return null;
    }

    protected String getProtocolAbbr(String protocol) {
        if (protocol == null) {
            return "";
        }
        if (protocol.equals(SNMP_AUTH_PROTOCOL_MD5)) {
            return SNMP_AUTH_PROTOCOL_ABBR_MD5;
        }
        if (protocol.equals(SNMP_AUTH_PROTOCOL_SHA)) {
            return SNMP_AUTH_PROTOCOL_ABBR_SHA;
        }
        if (protocol.equals(SNMP_PRIV_PROTOCOL_DES)) {
            return SNMP_PRIV_PROTOCOL_ABBR_DES;
        }
        if (protocol.equals(SNMP_PRIV_PROTOCOL_AES)) {
            return SNMP_PRIV_PROTOCOL_ABBR_AES;
        }
        return protocol;
    }

    protected String getSettingBody(String name, String community, String mode) {
        return "{\"AccessMode\": \"" + mode + "\", \"" + REDFISH_SNMP_PROTOCOL_COMM + "\": \"" + community + "\", \"" + REDFISH_SNMP_PROTOCOL_NAME + "\": \"" + name + "\"}";
    }

    protected boolean isProtocolSupported() {
        return this.isProtocolSupported(true);
    }

    protected boolean isProtocolSupported(boolean printErrorMessage) {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(super.getConfig().getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid)) {
            if (printErrorMessage) {
                MOut.G(this).println("This device is not supported");
            }
            this.statusCode = 153;
            return false;
        }
        return true;
    }

    protected boolean isProtocolEnabled(RedfishHttpUtils utils, String nodePath) {
        String url = "https://" + RedfishHttpUtils.getUrlIP(super.getConfig().getIp()) + REDFISH_MANAGERS_NETWORK_PROTOCOL_URL;
        try {
            HashMap<String, String> map;
            String value;
            int result = utils.sendRedfishGet(super.getConfig(), url);
            if (200 <= result && result <= 210 && (value = (map = utils.getEntry()).get(nodePath)) != null) {
                if (value.equals("true")) {
                    return true;
                }
                if (nodePath.equals(REDFISH_SNMP_PROTOCOL_ENABLED)) {
                    MOut.G(this).println("SNMP is disabled");
                } else if (nodePath.equals(REDFISH_SNMP_PROTOCOL_ENABLED_V2)) {
                    MOut.G(this).println("SNMPv2 is disabled");
                } else if (nodePath.equals(REDFISH_SNMP_PROTOCOL_ENABLED_V3)) {
                    MOut.G(this).println("SNMPv3 is disabled");
                }
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MOut.G(this).println("Failed to get SNMP status");
        this.statusCode = 149;
        return false;
    }
}

