/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SNMPBaseCommand;
import java.util.HashMap;
import java.util.List;

public class SNMPListCommand
extends SNMPBaseCommand {
    @Override
    public void runCommand() throws Exception {
        RedfishHttpUtils utils = new RedfishHttpUtils();
        RedfishCommand.HTTP_CALLBACK callback = () -> {
            HashMap<String, String> map = utils.getEntry();
            List<HashMap<String, String>> settingMapList = utils.getEntryListInNode("SNMP");
            StringBuffer output = new StringBuffer();
            String formatTemplate1 = "| %-20s | %-42s|%n";
            String formatTemplate2 = "  |%2s | %-14s | %-23s | %-16s|%n";
            String formatTemplate3 = "  | %-18s | %-42s|%n";
            String STATUS_ON = "on";
            String STATUS_OFF = "off";
            String STATUS_HIDE = "HIDE";
            String STATUS_SHOW = "SHOW";
            String FIELD_SNMP = "SNMP";
            String FIELD_SNMPv2 = "SNMPv2";
            String FIELD_SNMPv3 = "SNMPv3";
            String FIELD_ID = "ID";
            String FIELD_NAME = "Name";
            String FIELD_COMM = "Community String";
            String FIELD_ACCESS_MODE = "Access Mode";
            String FIELD_AUTH_PROTOCOL = "Auth Protocol";
            String FIELD_PRIV_PROTOCOL = "Private Protocol";
            String snmpStatusValue = map.get("SNMP/ProtocolEnabled");
            String snmpStatus = snmpStatusValue != null ? (snmpStatusValue.equals("true") ? "on" : "off") : "";
            String snmpv2StatusValue = map.get("SNMP/EnableSNMPv2c");
            String snmpv2Status = snmpv2StatusValue != null ? (snmpv2StatusValue.equals("true") ? "on" : "off") : "";
            String snmpv3StatusValue = map.get("SNMP/EnableSNMPv3");
            String snmpv3Status = snmpv3StatusValue != null ? (snmpv3StatusValue.equals("true") ? "on" : "off") : "";
            String snmpv2CommModeValue = map.get("SNMP/HideCommunityStrings");
            String snmpv2CommMode = snmpv2CommModeValue != null ? (snmpv2CommModeValue.equals("true") ? "HIDE" : "SHOW") : "";
            String auth = this.getProtocolAbbr(map.get("SNMP/AuthenticationProtocol"));
            String priv = this.getProtocolAbbr(map.get("SNMP/EncryptionProtocol"));
            output.append("+------------------------------------------------------------------+\n");
            output.append(String.format("| %-20s | %-42s|%n", "SNMP", snmpStatus));
            output.append("+------------------------------------------------------------------+\n");
            if (this.isProtocolSupported(false)) {
                output.append("\n");
                output.append("+------------------------------------------------------------------+\n");
                output.append(String.format("| %-20s | %-42s|%n", "SNMPv2", snmpv2Status));
                if (settingMapList != null && !settingMapList.isEmpty()) {
                    output.append("+------------------------------------------------------------------+\n");
                    output.append(String.format("  |%2s | %-14s | %-23s | %-16s|%n", "ID", "Name", "Community String [" + snmpv2CommMode + "]", "Access Mode"));
                    output.append("  +================================================================+\n");
                    for (int index = 0; index < settingMapList.size(); ++index) {
                        String commString;
                        HashMap<String, String> e = settingMapList.get(index);
                        String modeString = null;
                        String modeValue = e.get("AccessMode");
                        String string = commString = snmpv2CommModeValue != null && snmpv2CommModeValue.equalsIgnoreCase("true") ? "" : e.get("CommunityString");
                        modeString = modeValue != null ? (modeValue.equals("Full") ? "ReadWrite" : "ReadOnly") : "";
                        output.append(String.format("  |%2s | %-14s | %-23s | %-16s|%n", String.valueOf(index), e.get("Name"), commString, modeString));
                    }
                    output.append("  +----------------------------------------------------------------+\n");
                } else {
                    output.append("+------------------------------------------------------------------+\n");
                }
                output.append("\n");
                output.append("+------------------------------------------------------------------+\n");
                output.append(String.format("| %-20s | %-42s|%n", "SNMPv3", snmpv3Status));
                output.append("+------------------------------------------------------------------+\n");
                output.append(String.format("  | %-18s | %-42s|%n", "Auth Protocol", auth));
                output.append(String.format("  | %-18s | %-42s|%n", "Private Protocol", priv));
                output.append("  +----------------------------------------------------------------+\n");
            }
            MOut.G(this).println(output.toString());
        };
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/NetworkProtocol";
        int result = utils.sendRedfishGet(this.config, url);
        this.statusCode = this.statusCodeHandler(callback, result, utils.getRedfishResponse());
    }
}

