/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SNMPBaseCommand;
import java.util.HashMap;
import java.util.List;

public class SNMPv2AddCommand
extends SNMPBaseCommand {
    @Override
    public boolean preValidate() {
        if (super.getParameters() != null && super.getParameters().length >= 3) {
            try {
                int mode = Integer.valueOf(super.getParameters()[2]);
                if (0 <= mode && mode <= 1) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MOut.G(this).println("Invalid parameters");
        } else {
            MOut.G(this).println("Not enough actual parameters");
        }
        this.usage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isProtocolSupported()) {
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/NetworkProtocol";
        if (!this.isProtocolEnabled(utils, "SNMP/ProtocolEnabled") || !this.isProtocolEnabled(utils, "SNMP/EnableSNMPv2c")) {
            return;
        }
        String body = this.getRequestBody(utils);
        if (body != null) {
            RedfishCommand.HTTP_CALLBACK patchActionCallback = () -> MOut.G(this).println("Done");
            int result = utils.sendRedfishPatch(this.config, url, body);
            this.statusCode = this.statusCodeHandler(patchActionCallback, result, utils.getRedfishResponse());
        } else {
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }

    private String getRequestBody(RedfishHttpUtils utils) throws Exception {
        String name = super.getParameters()[0];
        String community = super.getParameters()[1];
        String mode = super.getParameters()[2].equals("1") ? "Full" : "Limited";
        String template = "{\"SNMP\": {\"CommunityStrings\": [%s]}}";
        StringBuffer payload = new StringBuffer();
        List<HashMap<String, String>> settingMapList = utils.getEntryListInNode("SNMP");
        if (settingMapList == null) {
            return null;
        }
        settingMapList.forEach(e -> payload.append("{},"));
        payload.append(this.getSettingBody(name, community, mode));
        return String.format("{\"SNMP\": {\"CommunityStrings\": [%s]}}", payload.toString());
    }

    private void usage() {
        String usage = "Usage: redfish eventService snmp snmpv2 add <name> <community string> <mode>\nmode:\n ReadOnly : 0\n ReadWrite: 1";
        MOut.G(this).println("Usage: redfish eventService snmp snmpv2 add <name> <community string> <mode>\nmode:\n ReadOnly : 0\n ReadWrite: 1");
    }
}

