/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SNMPBaseCommand;
import java.util.HashMap;
import java.util.List;

public class SNMPv2EditCommand
extends SNMPBaseCommand {
    @Override
    public boolean preValidate() {
        if (super.getParameters() != null && super.getParameters().length >= 4) {
            try {
                int index = Integer.valueOf(super.getParameters()[0]);
                int mode = Integer.valueOf(super.getParameters()[3]);
                if (0 <= mode && mode <= 1 && 0 <= index && index <= 127) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MOut.G(this).println("Invalid parameters");
        } else {
            MOut.G(this).println("Not enough actual parameters");
        }
        MOut.G(this).println("Usage: redfish eventService snmp snmpv2 edit <id> <name> <community string> <mode>\nmode:\n ReadOnly : 0\n ReadWrite: 1");
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isProtocolSupported()) {
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/NetworkProtocol";
        if (!this.isProtocolEnabled(utils, "SNMP/ProtocolEnabled") || !this.isProtocolEnabled(utils, "SNMP/EnableSNMPv2c")) {
            return;
        }
        String body = this.getRequestBody(utils);
        if (body != null) {
            RedfishCommand.HTTP_CALLBACK patchActionCallback = () -> MOut.G(this).println("Done");
            int result = utils.sendRedfishPatch(this.config, url, body);
            this.statusCode = this.statusCodeHandler(patchActionCallback, result, utils.getRedfishResponse());
        } else {
            this.statusCode = 149;
        }
    }

    private String getRequestBody(RedfishHttpUtils utils) throws Exception {
        int target = Integer.valueOf(super.getParameters()[0]);
        String name = super.getParameters()[1];
        String community = super.getParameters()[2];
        String mode = super.getParameters()[3].equals("1") ? "Full" : "Limited";
        String template = "{\"SNMP\": {\"CommunityStrings\": [%s]}}";
        StringBuffer payload = new StringBuffer();
        List<HashMap<String, String>> settingMapList = utils.getEntryListInNode("SNMP");
        if (settingMapList != null) {
            if (target >= settingMapList.size()) {
                MOut.G(this).println("ID is out of range");
                return null;
            }
            for (int idx = 0; idx < settingMapList.size(); ++idx) {
                if (idx != 0) {
                    payload.append(",");
                }
                if (idx == target) {
                    payload.append(this.getSettingBody(name, community, mode));
                    continue;
                }
                payload.append("{}");
            }
            return String.format("{\"SNMP\": {\"CommunityStrings\": [%s]}}", payload.toString());
        }
        MOut.G(this).println("Failed");
        return null;
    }
}

