/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SCCCheckingProcessorsCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Systems/1/" + "Processors";
        int result = this.sessionLoginClient.send_https_get(url);
        int cpuCount = 0;
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode member = node.path("Members");
            String formatTemplate = " %-25s | %-45s |\n";
            if (member.isArray()) {
                MOut.G(this).println("\n  Processors");
                MOut.G(this).println("---------------------------------------------------------------------------");
                if (member.size() == 0) {
                    MOut.G(this).println(" None");
                }
                for (JsonNode l : member) {
                    JsonNode pnode;
                    JsonNode processorType;
                    url = "https://" + ip + l.path("@odata.id").asText();
                    int result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210 || !(processorType = (pnode = mapper.readTree(this.sessionLoginClient.getResponseString())).path("ProcessorType")).asText().equalsIgnoreCase("CPU")) continue;
                    JsonNode status = pnode.path("Status");
                    JsonNode state = status.path("State");
                    JsonNode health = status.path("Health");
                    JsonNode socket = pnode.path("Socket");
                    JsonNode type = pnode.path("ProcessorType");
                    JsonNode architecture = pnode.path("ProcessorArchitecture");
                    JsonNode manufacturer = pnode.path("Manufacturer");
                    JsonNode model = pnode.path("Model");
                    JsonNode speed = pnode.path("OperatingSpeedMHz");
                    JsonNode instructionSet = pnode.path("InstructionSet");
                    JsonNode cores = pnode.findPath("TotalCores");
                    JsonNode threads = pnode.findPath("TotalThreads");
                    StringBuffer fStr = new StringBuffer();
                    fStr.append(String.format(formatTemplate, "ProcessorType", type.asText()));
                    fStr.append(String.format(formatTemplate, "State", state.asText()));
                    fStr.append(String.format(formatTemplate, "Health", health.asText()));
                    fStr.append(String.format(formatTemplate, "Socket", socket.asText()));
                    fStr.append(String.format(formatTemplate, "ProcessorArchitecture", architecture.asText()));
                    fStr.append(String.format(formatTemplate, "Manufacturer", manufacturer.asText()));
                    fStr.append(String.format(formatTemplate, "Model", model.asText()));
                    fStr.append(String.format(formatTemplate, "Speed", speed.asText() + " MHz"));
                    fStr.append(String.format(formatTemplate, "InstructionSet", instructionSet.asText()));
                    fStr.append(String.format(formatTemplate, "TotalCores", cores.asText()));
                    fStr.append(String.format(formatTemplate, "TotalThreads", threads.asText()));
                    MOut.G(this).print(fStr.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    ++cpuCount;
                }
            }
        } else {
            MOut.G(this).println("redfish/v1/Systems/1/Processors connection failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Total CPU count: " + cpuCount);
        this.statusCode = 0;
    }
}

