/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SCCCheckingSystemCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Systems/1/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode status = node.path("Status");
            JsonNode state = status.path("State");
            JsonNode health = status.path("Health");
            JsonNode systemType = node.path("SystemType");
            JsonNode boot = node.path("Boot");
            JsonNode bootEnabled = boot.path("BootSourceOverrideEnabled");
            JsonNode bootTarget = boot.path("BootSourceOverrideTarget");
            JsonNode bootMode = boot.path("BootSourceOverrideMode");
            JsonNode biosver = node.path("BiosVersion");
            JsonNode manufacturer = node.path("Manufacturer");
            JsonNode model = node.path("Model");
            JsonNode serialNumber = node.path("SerialNumber");
            JsonNode partNumber = node.path("PartNumber");
            JsonNode sku = node.path("SKU");
            JsonNode uid = node.path("IndicatorLED");
            JsonNode UUID = node.path("UUID");
            MOut.G(this).println("---------------------------------------------------------------------------");
            String formatTemplate = " %-25s | %-45s |\n";
            StringBuffer fStr = new StringBuffer();
            fStr.append(String.format(formatTemplate, "State", state.asText()));
            fStr.append(String.format(formatTemplate, "Health", health.asText()));
            fStr.append(String.format(formatTemplate, "SystemType", systemType.asText()));
            fStr.append(String.format(formatTemplate, "BootSourceOverrideEnabled", bootEnabled.asText()));
            fStr.append(String.format(formatTemplate, "BootSourceOverrideTarget", bootTarget.asText()));
            fStr.append(String.format(formatTemplate, "BootSourceOverrideMode", bootMode.asText()));
            fStr.append(String.format(formatTemplate, "BiosVersion", biosver.asText()));
            fStr.append(String.format(formatTemplate, "Manufacturer", manufacturer.asText()));
            fStr.append(String.format(formatTemplate, "Model", model.asText()));
            fStr.append(String.format(formatTemplate, "SerialNumber", serialNumber.asText()));
            fStr.append(String.format(formatTemplate, "PartNumber", partNumber.asText()));
            fStr.append(String.format(formatTemplate, "SKU", sku.asText()));
            fStr.append(String.format(formatTemplate, "IndicatorLED", uid.asText()));
            fStr.append(String.format(formatTemplate, "UUID", UUID.asText()));
            MOut.G(this).print(fStr.toString());
            MOut.G(this).println("---------------------------------------------------------------------------");
            if (UUID.isNull() || UUID.asText().length() == 0) {
                MOut.G(this).println("Fail. System UUID missing in redfish/v1/Systems/1");
                this.statusCode = 149;
            } else {
                this.statusCode = 0;
            }
        } else {
            MOut.G(this).println("redfish/v1/Systems/1 connection failed");
            this.statusCode = 149;
            return;
        }
    }
}

