/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.HashMap;

public class SCCCheckingVersionCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        StringBuilder builder;
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Systems/1/";
        RedfishHttpUtils utils = new RedfishHttpUtils();
        utils.sendRedfishGet(this.config, url);
        HashMap<String, String> entryMap = utils.getEntry();
        String biosVer = entryMap.get("BiosVersion");
        MOut.G(this).println("---------------------------------------------------------------------------");
        String formatTemplate = " %-25s | %-45s |\n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(formatTemplate, "BiosVersion", biosVer));
        url = "https://" + ip + "/redfish/v1/Managers/1/";
        utils.sendRedfishGet(this.config, url);
        entryMap = utils.getEntry();
        String bmcVer = entryMap.get("FirmwareVersion");
        fStr.append(String.format(formatTemplate, "FW Version from Redfish", bmcVer));
        if (deviceInfo != null) {
            builder = new StringBuilder();
            builder.append(String.format("%02d", deviceInfo.firmwareRevision1));
            builder.append(".");
            builder.append(ByteUtility.byteToHex(deviceInfo.firmwareRevision2));
            builder.append(".");
            builder.append(ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]));
            if (deviceInfo.deviceRevision == 2) {
                builder.append(".");
                builder.append(ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[3]));
            }
        } else {
            MOut.G(this).println("Get DeviceID command failed");
            this.statusCode = 149;
            return;
        }
        fStr.append(String.format(formatTemplate, "FW Version from IPMI", builder.toString()));
        MOut.G(this).print(fStr.toString());
        MOut.G(this).println("---------------------------------------------------------------------------");
        this.statusCode = 0;
    }
}

