/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;

public class vCDMonitorThread
extends Thread {
    private CDROMRedir cdromRedir = null;
    private String[] cdromList = null;
    private String cdromSource = null;
    private boolean cdromThreadStatus = false;
    private boolean isMediaMatched = false;
    private int cddevice_no = 0;

    public vCDMonitorThread(int cddevice_no) {
        this.cddevice_no = cddevice_no;
    }

    public void startCDROMMonitor() {
        this.cdromThreadStatus = true;
        this.start();
    }

    public void stopCDROMMonitor() {
        this.cdromThreadStatus = false;
    }

    @Override
    public void run() {
        this.cdromRedir = new CDROMRedir(true);
        this.cdromSource = JViewerApp.getInstance().getM_IUSBSession().getCDROMSource(this.cddevice_no);
        this.cdromThreadStatus = true;
        while (this.cdromThreadStatus) {
            try {
                if (!JViewerApp.getInstance().IsCDROMRedirRunning(this.cddevice_no)) break;
                this.cdromList = this.cdromRedir.getCDROMList();
                if (this.cdromList == null) {
                    if (JViewerApp.getInstance().m_mediaDlg != null) {
                        JViewerApp.getInstance().m_mediaDlg.setVisible(false);
                    }
                    JViewerApp.getInstance().getM_IUSBSession().StopCDROMRedir(this.cddevice_no);
                } else {
                    for (int i = 0; i < this.cdromList.length; ++i) {
                        if (!this.cdromSource.equals(this.cdromList[i])) continue;
                        this.isMediaMatched = true;
                        break;
                    }
                    if (!this.isMediaMatched) {
                        Debug.out.println("REDIRECTED CDROM MEDIUM REMOVAL HAS BEEN DETECTED, STOPPING REDIRECTION TO PREVENT FURTHER DAMAGE");
                        if (JViewerApp.getInstance().m_mediaDlg != null) {
                            JViewerApp.getInstance().m_mediaDlg.setVisible(false);
                        }
                        JViewerApp.getInstance().getM_IUSBSession().StopCDROMRedir(this.cddevice_no);
                    } else {
                        this.isMediaMatched = false;
                    }
                }
                vCDMonitorThread.sleep(1000L);
            }
            catch (RedirectionException e) {
                if (JViewerApp.getInstance().m_mediaDlg != null) {
                    JViewerApp.getInstance().m_mediaDlg.setVisible(false);
                }
                JViewerApp.getInstance().getM_IUSBSession().stopCDROMAbnormal(this.cddevice_no);
                Debug.out.println(e);
            }
            catch (InterruptedException e) {
                if (JViewerApp.getInstance().m_mediaDlg != null) {
                    JViewerApp.getInstance().m_mediaDlg.setVisible(false);
                }
                JViewerApp.getInstance().getM_IUSBSession().stopCDROMAbnormal(this.cddevice_no);
                Debug.out.println(e);
            }
        }
    }
}

