/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.swing.JApplet;

public class WebPreviewer
extends JApplet
implements Runnable,
ActionListener {
    private byte[] m_frameBuf;
    private ByteBuffer m_frameByteBuf;
    public static final int MAX_SCREEN_WIDTH = 1600;
    public static final int MAX_SCREEN_HEIGHT = 1200;
    public static final byte REFRESH_BUTTON_WEIGHT = 60;
    public static final byte REFRESH_BUTTON_HEIGHT = 20;
    public static final byte RETRY_COUNT = 10;
    private static JViewerView m_view;
    private static byte retryCount;
    private int CatchSize = 0;
    private byte m_capStatus;
    private Thread paintTh;
    byte[] ip;
    Button Capture1 = new Button("Refresh");
    String serverip;
    int kvmport = 0;
    int kvmsecure = 0;
    int webport = 0;
    boolean useSSL = false;

    @Override
    public void init() {
        this.setLayout(null);
        this.setBackground(Color.black);
        JViewer.setWebPreviewer(true);
        this.Capture1.setBounds(5, 5, 60, 20);
        this.Capture1.addActionListener(this);
        this.add(this.Capture1);
        this.Capture1.setEnabled(false);
        m_view = JViewerApp.getInstance().getM_view();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        try {
            Dimension appletSize = this.getSize();
            g.setColor(Color.yellow);
            g.clearRect(0, 0, appletSize.width, appletSize.height);
            if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_FAILURE) {
                g.drawString("Capture Failed", 70, 20);
            } else if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_IN_PROGRESS) {
                g.drawString("Capturing....", 70, 20);
            } else if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CONNECT_FAILURE) {
                g.drawString("Not able to connect " + this.serverip, 70, 20);
            } else if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_INVALID_SERVERIP) {
                g.drawString("INVALID SERVER IP" + this.serverip, 70, 20);
            } else {
                g.drawString(m_view.viewWidth() + " x " + m_view.viewHeight(), 70, 20);
            }
            BufferedImage m_image = JViewerApp.getInstance().getPrepare_buf().getM_image();
            if (m_view.viewWidth() == 1024) {
                BufferedImage pImage = WebPreviewer.scaleJ2D(m_image, appletSize.width, appletSize.height - 30, null);
                Rectangle full_view = new Rectangle(0, 0, appletSize.width, appletSize.height - 31);
                Rectangle r = full_view.intersection(g.getClipBounds());
                BufferedImage rgn = pImage.getSubimage(r.x, r.y, r.width, r.height);
                g.drawImage(rgn, r.x + 5, r.y + 30, null);
            } else {
                BufferedImage pImage = WebPreviewer.scaleJ2D(m_image, appletSize.width, appletSize.height - 30, null);
                Rectangle full_view = new Rectangle(0, 0, appletSize.width, appletSize.height - 31);
                Rectangle r = full_view.intersection(g.getClipBounds());
                BufferedImage rgn = pImage.getSubimage(r.x, r.y, r.width, r.height);
                g.drawImage(rgn, r.x + 5, r.y + 30, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BufferedImage scaleJ2D(BufferedImage srcImage, double xscale, double yscale, RenderingHints hints) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(xscale, yscale);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, hints);
        int width = (int)((double)srcImage.getWidth() * xscale);
        int height = (int)((double)srcImage.getHeight() * yscale);
        BufferedImage dstImage = new BufferedImage(width, height, srcImage.getType());
        return affineTransformOp.filter(srcImage, dstImage);
    }

    public static BufferedImage reduce(BufferedImage srcImage, double xscale, double yscale) {
        int w = (int)((double)srcImage.getWidth() * xscale);
        int h = (int)((double)srcImage.getHeight() * yscale);
        Image rescaled = srcImage.getScaledInstance(w, h, 16);
        BufferedImage result = new BufferedImage(w, h, 1);
        Graphics2D g = result.createGraphics();
        g.drawImage(rescaled, 0, 0, null);
        g.dispose();
        return result;
    }

    public static BufferedImage scaleJ2D(BufferedImage srcImage, int dstWidth, int dstHeight, RenderingHints hints) {
        float xscale = (float)dstWidth / (float)srcImage.getWidth();
        float yscale = (float)dstHeight / (float)srcImage.getHeight();
        return WebPreviewer.reduce(srcImage, xscale, yscale);
    }

    @Override
    public void start() {
        if (this.paintTh == null) {
            this.paintTh = new Thread((Runnable)this, "paint");
            this.paintTh.start();
        }
    }

    @Override
    public void stop() {
        if (this.paintTh != null) {
            this.paintTh.stop();
            this.paintTh = null;
        }
    }

    @Override
    public void run() {
        while (true) {
            this.startCapture();
            this.Capture1.setEnabled(true);
            this.mywait();
        }
    }

    public synchronized void mywait() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void mynotifyAll() {
        this.notifyAll();
    }

    public void startCapture() {
        this.serverip = this.getParameter("serverip");
        this.serverip = this.serverip.trim();
        this.kvmport = Integer.parseInt(this.getParameter("kvmport").trim());
        this.kvmsecure = Integer.parseInt(this.getParameter("kvmsecure").trim());
        this.webport = Integer.parseInt(this.getParameter("webport").trim());
        if (this.webport == 0) {
            this.webport = 80;
        }
        this.ip = JViewer.getServerIP(this.serverip);
        if (this.serverip.compareTo("") == 0) {
            this.m_capStatus = JViewerApp.WEB_PREVIEWER_INVALID_SERVERIP;
        } else {
            if (this.kvmsecure == 1) {
                this.useSSL = true;
            }
            JViewerApp.getInstance().OnConnectToServer(this.ip, this.kvmport, "asdfa", this.useSSL, "asdfas");
            JViewerApp.getInstance().getKVMClient().setM_redirection(true);
            while (true) {
                this.m_capStatus = JViewerApp.getInstance().getWebPreviewerCaptureStatus();
                if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_SUCCESS || retryCount == 10 || this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_FAILURE) {
                    JViewerApp.getInstance().OnVideoStopRedirection();
                    break;
                }
                if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CONNECT_FAILURE) break;
                try {
                    retryCount = (byte)(retryCount + 1);
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.m_capStatus == JViewerApp.WEB_PREVIEWER_CAPTURE_FAILURE || this.m_capStatus == JViewerApp.WEB_PREVIEWER_CONNECT_FAILURE || this.m_capStatus == JViewerApp.WEB_PREVIEWER_INVALID_SERVERIP) {
            retryCount = 0;
            this.Capture1.setEnabled(true);
            this.repaint();
            return;
        }
        try {
            URL srcUrl = new URL(this.getCodeBase().getProtocol() + "://" + this.getCodeBase().getHost() + ":" + this.webport + "/capture/webPreview.cap");
            HttpURLConnection connection = (HttpURLConnection)srcUrl.openConnection();
            connection.setUseCaches(false);
            DataInputStream in = new DataInputStream(connection.getInputStream());
            this.m_frameBuf = new byte[3840000];
            this.m_frameByteBuf = ByteBuffer.wrap(this.m_frameBuf);
            retryCount = 0;
            byte[] buffer = new byte[4096];
            int count = 0;
            this.CatchSize = 0;
            this.m_frameByteBuf.position(0);
            count = 0;
            while ((count = in.read(buffer)) > 0) {
                for (int i = 0; i < count; ++i) {
                    this.m_frameBuf[this.CatchSize + i] = buffer[i];
                }
                this.CatchSize += count;
            }
            in.close();
            this.m_frameByteBuf.limit(this.CatchSize);
            this.m_frameByteBuf.position(this.CatchSize);
            JViewerApp.getInstance().getKVMClient().onNewFrame(this.m_frameByteBuf);
            this.repaint();
        }
        catch (Exception e) {
            this.m_capStatus = JViewerApp.WEB_PREVIEWER_CONNECT_FAILURE;
            e.printStackTrace();
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.Capture1) {
            this.Capture1.setEnabled(false);
            JViewerApp.getInstance().setWebPreviewerCaptureStatus(JViewerApp.WEB_PREVIEWER_CAPTURE_IN_PROGRESS);
            this.m_capStatus = JViewerApp.WEB_PREVIEWER_CAPTURE_IN_PROGRESS;
            this.repaint();
            this.mynotifyAll();
        }
    }

    static {
        retryCount = 0;
    }
}

