/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.avistream;

import com.ami.kvm.jviewer.avistream.DataChunkOutputStream;
import com.ami.kvm.jviewer.avistream.FilterImageOutputStream;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class AVIOutputStream {
    private ImageOutputStream out;
    private VideoFormat videoFormat;
    private float quality = 0.9f;
    private Date creationTime;
    private int imgWidth = -1;
    private int imgHeight = -1;
    private long timeScale = 1L;
    private long frameRate = 30L;
    private States state = States.FINISHED;
    public boolean streamClosed = false;
    public boolean singleVideo = false;
    private LinkedList<Sample> videoFrames;
    private CompositeChunk aviChunk;
    private CompositeChunk moviChunk;
    FixedSizeDataChunk avihChunk;
    FixedSizeDataChunk strhChunk;
    FixedSizeDataChunk strfChunk;

    public AVIOutputStream(File file, VideoFormat format, boolean singleVideo) throws IOException {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.videoFormat = format;
        this.videoFrames = new LinkedList();
        this.singleVideo = singleVideo;
    }

    public AVIOutputStream(ImageOutputStream out, VideoFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        this.out = out;
        this.videoFormat = format;
        this.videoFrames = new LinkedList();
    }

    public void setTimeScale(long newValue) {
        if (newValue <= 0L) {
            newValue = 1L;
        }
        this.timeScale = newValue;
    }

    public long getTimeScale() {
        return this.timeScale;
    }

    public void setFrameRate(long newValue) {
        if (newValue <= 0L) {
            newValue = 1L;
        }
        if (this.state == States.STARTED) {
            throw new IllegalStateException("frameDuration must be set before the first frame is written");
        }
        this.frameRate = newValue;
    }

    public long getFrameRate() {
        return this.frameRate;
    }

    public void setVideoCompressionQuality(float newValue) {
        this.quality = newValue;
    }

    public float getVideoCompressionQuality() {
        return this.quality;
    }

    public void setVideoDimension(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width and height must be greater zero.");
        }
        this.imgWidth = width;
        this.imgHeight = height;
    }

    public Dimension getVideoDimension() {
        if (this.imgWidth < 1 || this.imgHeight < 1) {
            return null;
        }
        return new Dimension(this.imgWidth, this.imgHeight);
    }

    private void ensureStarted() throws IOException {
        if (this.state != States.STARTED) {
            this.creationTime = new Date();
            this.writeProlog();
            this.state = States.STARTED;
        }
    }

    public boolean writeFrame(BufferedImage image) throws IOException {
        this.ensureOpen();
        this.ensureStarted();
        if (this.imgWidth == -1) {
            this.imgWidth = image.getWidth();
            this.imgHeight = image.getHeight();
        } else if (!(this.singleVideo || this.imgWidth == image.getWidth() && this.imgHeight == image.getHeight())) {
            this.close();
            this.imgHeight = -1;
            this.imgWidth = -1;
            this.streamClosed = true;
            return false;
        }
        DataChunk videoFrameChunk = new DataChunk(this.videoFormat == VideoFormat.RAW ? "00db" : "00dc");
        this.moviChunk.add(videoFrameChunk);
        long offset = this.out.getStreamPosition();
        ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
        ImageWriteParam iwParam = iw.getDefaultWriteParam();
        iwParam.setCompressionMode(2);
        iwParam.setCompressionQuality(this.quality);
        MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(videoFrameChunk.getOutputStream());
        iw.setOutput(imgOut);
        IIOImage img = new IIOImage(image, null, null);
        iw.write(null, img, iwParam);
        iw.dispose();
        long length = this.out.getStreamPosition() - offset;
        videoFrameChunk.finish();
        this.videoFrames.add(new Sample(this.frameRate, offset, length));
        if (this.out.getStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
        return true;
    }

    public void writeFrame(File file) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            this.writeFrame(in);
        }
    }

    public void writeFrame(InputStream in) throws IOException {
        int len;
        this.ensureOpen();
        this.ensureStarted();
        DataChunk videoFrameChunk = new DataChunk("00dc");
        this.moviChunk.add(videoFrameChunk);
        DataChunkOutputStream mdatOut = videoFrameChunk.getOutputStream();
        long offset = this.out.getStreamPosition();
        byte[] buf = new byte[512];
        while ((len = in.read(buf)) != -1) {
            ((OutputStream)mdatOut).write(buf, 0, len);
        }
        long length = this.out.getStreamPosition() - offset;
        videoFrameChunk.finish();
        this.videoFrames.add(new Sample(this.frameRate, offset, length));
        if (this.out.getStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    public void close() throws IOException {
        if (this.state == States.STARTED) {
            this.finish();
        }
        if (this.state != States.CLOSED) {
            this.out.close();
            this.state = States.CLOSED;
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            if (this.imgWidth == -1 || this.imgHeight == -1) {
                throw new IllegalStateException("image width and height must be specified");
            }
            this.moviChunk.finish();
            this.writeEpilog();
            this.state = States.FINISHED;
            this.imgHeight = -1;
            this.imgWidth = -1;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private void writeProlog() throws IOException {
        this.aviChunk = new CompositeChunk("RIFF", "AVI ");
        CompositeChunk hdrlChunk = new CompositeChunk("LIST", "hdrl");
        this.aviChunk.add(hdrlChunk);
        this.avihChunk = new FixedSizeDataChunk("avih", 56L);
        this.avihChunk.seekToEndOfChunk();
        hdrlChunk.add(this.avihChunk);
        CompositeChunk strlChunk = new CompositeChunk("LIST", "strl");
        hdrlChunk.add(strlChunk);
        this.strhChunk = new FixedSizeDataChunk("strh", 56L);
        this.strhChunk.seekToEndOfChunk();
        strlChunk.add(this.strhChunk);
        this.strfChunk = new FixedSizeDataChunk("strf", 40L);
        this.strfChunk.seekToEndOfChunk();
        strlChunk.add(this.strfChunk);
        this.moviChunk = new CompositeChunk("LIST", "movi");
        this.aviChunk.add(this.moviChunk);
    }

    private void writeEpilog() throws IOException {
        int duration = 0;
        for (Sample s : this.videoFrames) {
            duration = (int)((long)duration + s.duration);
        }
        long bufferSize = 0L;
        for (Sample s : this.videoFrames) {
            if (s.length <= bufferSize) continue;
            bufferSize = s.length;
        }
        DataChunk idx1Chunk = new DataChunk("idx1");
        this.aviChunk.add(idx1Chunk);
        DataChunkOutputStream d = idx1Chunk.getOutputStream();
        for (Sample f : this.videoFrames) {
            d.writeType("00dc");
            d.writeUInt(16L);
            d.writeUInt(f.offset - this.moviChunk.offset - 16L);
            d.writeUInt(f.length);
        }
        idx1Chunk.finish();
        this.avihChunk.seekToStartOfData();
        d = this.avihChunk.getOutputStream();
        d.writeUInt(10000000L * this.timeScale / this.frameRate);
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(16L);
        d.writeUInt(this.videoFrames.size());
        d.writeUInt(0L);
        d.writeUInt(1L);
        d.writeUInt(bufferSize);
        d.writeUInt(this.imgWidth);
        d.writeUInt(this.imgHeight);
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(0L);
        this.strhChunk.seekToStartOfData();
        d = this.strhChunk.getOutputStream();
        d.writeType("vids");
        switch (this.videoFormat) {
            case RAW: {
                d.writeType("DIB ");
                break;
            }
            case JPG: {
                d.writeType("MJPG");
                break;
            }
            default: {
                d.writeType("png ");
            }
        }
        d.writeUInt(0L);
        d.writeUShort(0);
        d.writeUShort(0);
        d.writeUInt(0L);
        d.writeUInt(this.timeScale);
        d.writeUInt(this.frameRate);
        d.writeUInt(0L);
        d.writeUInt(this.videoFrames.size());
        d.writeUInt(bufferSize);
        d.writeInt(-1);
        d.writeUInt(0L);
        d.writeUShort(0);
        d.writeUShort(0);
        d.writeUShort(this.imgWidth);
        d.writeUShort(this.imgHeight);
        this.strfChunk.seekToStartOfData();
        d = this.strfChunk.getOutputStream();
        d.writeUInt(40L);
        d.writeInt(this.imgWidth);
        d.writeInt(this.imgHeight);
        d.writeShort(1);
        d.writeShort(24);
        switch (this.videoFormat) {
            case RAW: {
                d.writeInt(0);
                break;
            }
            case JPG: {
                d.writeType("MJPG");
                break;
            }
            default: {
                d.writeType("png ");
            }
        }
        d.writeInt(this.imgWidth * this.imgHeight * 3);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        this.aviChunk.finish();
    }

    private class FixedSizeDataChunk
    extends Chunk {
        private DataChunkOutputStream data;
        private boolean finished;
        private long fixedSize;

        public FixedSizeDataChunk(String chunkType, long fixedSize) throws IOException {
            super(chunkType);
            this.fixedSize = fixedSize;
            this.data = new DataChunkOutputStream(new FilterImageOutputStream(AVIOutputStream.this.out));
            this.data.writeType(chunkType);
            this.data.writeUInt(fixedSize);
            this.data.clearCount();
            byte[] buf = new byte[(int)Math.min(512L, fixedSize)];
            for (long written = 0L; written < fixedSize; written += Math.min((long)buf.length, fixedSize - written)) {
                this.data.write(buf, 0, (int)Math.min((long)buf.length, fixedSize - written));
            }
            if (fixedSize % 2L == 1L) {
                AVIOutputStream.this.out.writeByte(0);
            }
            this.seekToStartOfData();
        }

        public DataChunkOutputStream getOutputStream() {
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        public void seekToStartOfData() throws IOException {
            AVIOutputStream.this.out.seek(this.offset + 8L);
            this.data.clearCount();
        }

        public void seekToEndOfChunk() throws IOException {
            AVIOutputStream.this.out.seek(this.offset + 8L + this.fixedSize + this.fixedSize % 2L);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 8L + this.fixedSize;
        }
    }

    private class DataChunk
    extends Chunk {
        private DataChunkOutputStream data;
        private boolean finished;

        public DataChunk(String name) throws IOException {
            super(name);
            AVIOutputStream.this.out.writeLong(0L);
            this.data = new DataChunkOutputStream(new FilterImageOutputStream(AVIOutputStream.this.out));
        }

        public DataChunkOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataChunk is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long sizeBefore = this.size();
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("DataChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long pointer = AVIOutputStream.this.out.getStreamPosition();
                AVIOutputStream.this.out.seek(this.offset);
                DataChunkOutputStream headerData = new DataChunkOutputStream(new FilterImageOutputStream(AVIOutputStream.this.out));
                headerData.writeType(this.chunkType);
                headerData.writeUInt(this.size() - 8L);
                AVIOutputStream.this.out.seek(pointer);
                if (this.size() % 2L == 1L) {
                    AVIOutputStream.this.out.writeByte(0);
                }
                this.finished = true;
                long sizeAfter = this.size();
                if (sizeBefore != sizeAfter) {
                    System.err.println("size mismatch " + sizeBefore + ".." + sizeAfter);
                }
            }
        }

        @Override
        public long size() {
            return 8L + this.data.size();
        }
    }

    private class CompositeChunk
    extends Chunk {
        protected String compositeType;
        private LinkedList<Chunk> children;
        private boolean finished;

        public CompositeChunk(String compositeType, String chunkType) throws IOException {
            super(chunkType);
            this.compositeType = compositeType;
            AVIOutputStream.this.out.writeLong(0L);
            AVIOutputStream.this.out.writeInt(0);
            this.children = new LinkedList();
        }

        public void add(Chunk child) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(child);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long pointer = AVIOutputStream.this.out.getStreamPosition();
                AVIOutputStream.this.out.seek(this.offset);
                DataChunkOutputStream headerData = new DataChunkOutputStream(new FilterImageOutputStream(AVIOutputStream.this.out));
                headerData.writeType(this.compositeType);
                headerData.writeUInt(this.size() - 8L);
                headerData.writeType(this.chunkType);
                for (Chunk child : this.children) {
                    child.finish();
                }
                AVIOutputStream.this.out.seek(pointer);
                if (this.size() % 2L == 1L) {
                    AVIOutputStream.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long length = 12L;
            for (Chunk child : this.children) {
                length += child.size() + child.size() % 2L;
            }
            return length;
        }
    }

    private abstract class Chunk {
        protected String chunkType;
        protected long offset;

        public Chunk(String chunkType) throws IOException {
            this.chunkType = chunkType;
            this.offset = AVIOutputStream.this.out.getStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    private static class Sample {
        long offset;
        long length;
        long duration;

        public Sample(long duration, long offset, long length) {
            this.duration = duration;
            this.offset = offset;
            this.length = length;
        }
    }

    private static enum States {
        STARTED,
        FINISHED,
        CLOSED;

    }

    public static enum VideoFormat {
        RAW,
        JPG,
        PNG;

    }
}

