/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.KVMSharing;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class Client {
    protected Socket m_sock = null;
    protected Socket m_sock_nonssl = null;
    protected SSLSocket m_sock_ssl = null;
    protected byte[] m_ipAddr;
    protected int m_port;

    public Client(byte[] ipAddr, int port) {
        this.m_ipAddr = ipAddr;
        this.m_port = port;
    }

    public void SetSocket(Socket Sock) {
        this.m_sock = Sock;
    }

    public Socket getSocket() {
        return this.m_sock;
    }

    protected int connectVideo(boolean useSSL) {
        block7: {
            if (useSSL) {
                try {
                    if (-1 == this.connectVideoSSL()) {
                        return -1;
                    }
                    break block7;
                }
                catch (IOException e) {
                    Debug.out.println("Failed to establish connection" + e);
                    return -1;
                }
            }
            try {
                if (-1 == this.connectVideoNonSSL()) {
                    return -1;
                }
            }
            catch (IOException e) {
                Debug.out.println("Failed to establish connection" + e);
                return -1;
            }
        }
        return 0;
    }

    public int connectVideoNonSSL() throws IOException {
        this.m_sock_nonssl = new Socket();
        try {
            this.m_sock_nonssl.connect(new InetSocketAddress(InetAddress.getByAddress(this.m_ipAddr), this.m_port));
        }
        catch (Exception e) {
            return -1;
        }
        this.SetSocket(this.m_sock_nonssl);
        String Kvm_own_ip = this.m_sock.getLocalAddress().toString();
        String[] split = Kvm_own_ip.split("/");
        KVMSharing.KVM_CLIENT_OWN_IP = split[1];
        Debug.out.println("m_sock.socket().getLocalAddress()" + Kvm_own_ip.toString());
        Debug.out.println("m_sock.socket().getLocalAddress()" + KVMSharing.KVM_CLIENT_OWN_IP);
        return 0;
    }

    public int connectVideoSSL() throws IOException {
        SSLContext context = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            sslCtx.init(null, trustAllCerts, new SecureRandom());
            context = sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            Debug.out.println(e);
            return -1;
        }
        catch (KeyManagementException e) {
            Debug.out.println(e);
            return -1;
        }
        SSLSocketFactory sf = context.getSocketFactory();
        try {
            this.m_sock_ssl = (SSLSocket)sf.createSocket(InetAddress.getByAddress(this.m_ipAddr), this.m_port);
            this.m_sock_ssl.startHandshake();
            this.SetSocket(this.m_sock_ssl);
            String Kvm_own_ip = this.m_sock_ssl.getLocalAddress().toString();
            String[] split = Kvm_own_ip.split("/");
            KVMSharing.KVM_CLIENT_OWN_IP = split[1];
            if (KVMSharing.KVM_CLIENT_OWN_IP.compareToIgnoreCase("0.0.0.0") == 0) {
                KVMSharing.KVM_CLIENT_OWN_IP = this.getipv6IP();
            }
            Debug.out.println("m_sock.socket().getLocalAddress()" + Kvm_own_ip.toString());
            Debug.out.println("m_sock.socket().getLocalAddress()" + KVMSharing.KVM_CLIENT_OWN_IP);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int sendMessage(byte[] msg, int len) {
        if (!JViewer.isplayerapp() && !JViewer.isdownloadapp()) {
            try {
                this.getSocket().getOutputStream().write(msg);
            }
            catch (IOException e) {
                Debug.out.println("Send message failed");
                return 0;
            }
        }
        return len;
    }

    public void VideoSocketclose() {
        try {
            if (this.m_sock_nonssl != null) {
                this.m_sock_nonssl.close();
            }
            if (this.m_sock_ssl != null) {
                this.m_sock_ssl.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getipv6IP() {
        Enumeration<NetworkInterface> enumInterfaces = null;
        try {
            enumInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        while (enumInterfaces.hasMoreElements()) {
            NetworkInterface net = enumInterfaces.nextElement();
            System.out.println("NetworkInterface name: " + net.getDisplayName());
            Enumeration<InetAddress> enumIP = net.getInetAddresses();
            while (enumIP.hasMoreElements()) {
                InetAddress ip = enumIP.nextElement();
                InetAddress sample5 = null;
                try {
                    sample5 = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                String string6 = sample5.getHostAddress();
                String sample = ip.toString();
                String[] sample2 = sample.split("/");
                if (string6.compareTo(sample2[1]) == 0) {
                    System.out.println("CONTINUING LOOP");
                    continue;
                }
                System.out.println("" + Client.isProperIPv6Address(sample2[1]));
                if (!Client.isProperIPv6Address(sample2[1])) continue;
                System.out.println("VALID IPV6IP::" + sample2[1]);
                return sample2[1];
            }
        }
        return null;
    }

    public static boolean isProperIPv6Address(String address) {
        String[] sample = new String[]{"fc80", "fec0", "ff"};
        String[] ipv = address.split(":");
        try {
            InetAddress IP = Inet6Address.getByName(address);
            if (IP.isLinkLocalAddress() || IP.isLoopbackAddress()) {
                System.out.println("Returning false because LOOPBACK");
                return false;
            }
            for (int i = 0; i < sample.length; ++i) {
                if (ipv[0].compareToIgnoreCase(sample[i]) != 0) continue;
                System.out.println("Returning false because RESERVED IP");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public abstract void onReadEvent();
}

