/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.iusb.FloppyRedir;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.hid.KeyProcessor;
import com.ami.kvm.jviewer.hid.USBKeyProcessorEnglish;
import com.ami.kvm.jviewer.hid.USBKeyProcessorFrench;
import com.ami.kvm.jviewer.hid.USBKeyProcessorGerman;
import com.ami.kvm.jviewer.hid.USBKeyProcessorJapanese;
import com.ami.kvm.jviewer.hid.USBKeyProcessorSpanish;
import com.ami.kvm.jviewer.hid.USBKeyboardRep;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import java.awt.event.KeyEvent;
import java.util.HashMap;

public class AutoKeyboardLayout {
    public static final int KBD_TYPE_FRENCH = 1036;
    public static final int KBD_TYPE_SPANISH = 1034;
    public static final int KBD_TYPE_GERMAN = 1031;
    public static final int KBD_TYPE_ENGLISH = 1024;
    public static final int KBD_TYPE_JAPANESE = 1041;
    private int keyboardlayout;
    public static boolean DEAD_FLAG = false;
    public static boolean SHIFT_FLAG = false;
    public static int SHIFT_KEY_POSITION = 0;
    public static boolean ALT_GR_FLAG = false;
    public static boolean PLUS_FLAG = false;
    public static boolean JAPANESE_FLAG = false;
    public HashMap<Integer, Integer> French_linuxMap;
    public HashMap<Integer, Integer> French_WinMap;
    public HashMap<Integer, Integer> French_Alt_gr_linuxMap;
    public HashMap<Integer, Integer> Spanish_Map;
    public HashMap<Integer, Integer> Spanish_Alt_gr_linuxMap;
    public HashMap<Integer, Integer> German_Map;
    public HashMap<Integer, Integer> German_Map_Alt_gr_linuxMap;
    private byte[] bdata;

    public AutoKeyboardLayout() {
        this.get_keybd_type();
        this.ongetKeyprocessor();
        JViewerApp.getInstance().getM_USBKeyRep().setM_USBKeyProcessor(this.ongetKeyprocessor());
        this.French_linuxMap = new HashMap();
        this.French_Alt_gr_linuxMap = new HashMap();
        this.French_WinMap = new HashMap();
        this.Spanish_Map = new HashMap();
        this.Spanish_Alt_gr_linuxMap = new HashMap();
        this.German_Map = new HashMap();
        this.German_Map_Alt_gr_linuxMap = new HashMap();
        this.French_WinMap.put(178, 192);
        this.French_WinMap.put(249, 222);
        this.French_WinMap.put(37, 222);
        this.French_linuxMap.put(178, 192);
        this.French_linuxMap.put(233, 50);
        this.French_linuxMap.put(50, 50);
        this.French_linuxMap.put(34, 51);
        this.French_linuxMap.put(51, 51);
        this.French_linuxMap.put(232, 55);
        this.French_linuxMap.put(55, 55);
        this.French_linuxMap.put(231, 57);
        this.French_linuxMap.put(57, 57);
        this.French_linuxMap.put(224, 48);
        this.French_linuxMap.put(48, 48);
        this.French_linuxMap.put(249, 52);
        this.French_linuxMap.put(37, 52);
        this.French_Alt_gr_linuxMap.put(38, 49);
        this.French_Alt_gr_linuxMap.put(126, 50);
        this.French_Alt_gr_linuxMap.put(35, 51);
        this.French_Alt_gr_linuxMap.put(123, 222);
        this.French_Alt_gr_linuxMap.put(91, 53);
        this.French_Alt_gr_linuxMap.put(124, 54);
        this.French_Alt_gr_linuxMap.put(96, 55);
        this.French_Alt_gr_linuxMap.put(92, 56);
        this.French_Alt_gr_linuxMap.put(94, 57);
        this.French_Alt_gr_linuxMap.put(64, 48);
        this.French_Alt_gr_linuxMap.put(93, 522);
        this.French_Alt_gr_linuxMap.put(125, 61);
        this.French_Alt_gr_linuxMap.put(164, 515);
        this.French_Alt_gr_linuxMap.put(8364, 69);
        this.Spanish_Map.put(170, 192);
        this.Spanish_Map.put(186, 192);
        this.Spanish_Map.put(92, 192);
        this.Spanish_Map.put(231, 92);
        this.Spanish_Map.put(199, 92);
        this.Spanish_Map.put(125, 92);
        this.Spanish_Map.put(241, 59);
        this.Spanish_Map.put(209, 59);
        this.Spanish_Alt_gr_linuxMap.put(92, 192);
        this.Spanish_Alt_gr_linuxMap.put(124, 49);
        this.Spanish_Alt_gr_linuxMap.put(64, 50);
        this.Spanish_Alt_gr_linuxMap.put(35, 51);
        this.Spanish_Alt_gr_linuxMap.put(126, 52);
        this.Spanish_Alt_gr_linuxMap.put(189, 53);
        this.Spanish_Alt_gr_linuxMap.put(172, 54);
        this.Spanish_Alt_gr_linuxMap.put(93, 93);
        this.Spanish_Alt_gr_linuxMap.put(123, 129);
        this.Spanish_Alt_gr_linuxMap.put(91, 91);
        this.Spanish_Alt_gr_linuxMap.put(8364, 53);
        this.German_Map.put(223, 45);
        this.German_Map.put(63, 45);
        this.German_Map.put(92, 47);
        this.German_Map.put(252, 91);
        this.German_Map.put(220, 91);
        this.German_Map.put(246, 59);
        this.German_Map.put(214, 59);
        this.German_Map.put(228, 222);
        this.German_Map.put(196, 222);
        this.German_Map.put(130, 192);
        this.German_Map_Alt_gr_linuxMap.put(178, 50);
        this.German_Map_Alt_gr_linuxMap.put(179, 51);
        this.German_Map_Alt_gr_linuxMap.put(123, 55);
        this.German_Map_Alt_gr_linuxMap.put(91, 56);
        this.German_Map_Alt_gr_linuxMap.put(93, 57);
        this.German_Map_Alt_gr_linuxMap.put(125, 48);
        this.German_Map_Alt_gr_linuxMap.put(126, 521);
        this.German_Map_Alt_gr_linuxMap.put(181, 77);
        this.German_Map_Alt_gr_linuxMap.put(64, 81);
        this.German_Map_Alt_gr_linuxMap.put(8364, 69);
        this.German_Map_Alt_gr_linuxMap.put(92, 47);
        this.German_Map_Alt_gr_linuxMap.put(124, 153);
    }

    private void get_keybd_type() {
        FloppyRedir floppyredir = new FloppyRedir(true);
        String Keybdtype = floppyredir.ReadKeybdType();
        Debug.out.println("Keybdtype" + Keybdtype);
        String OS_name = System.getProperty("os.name");
        Debug.out.println("Os_name" + OS_name);
        if (OS_name.equalsIgnoreCase("Linux")) {
            if (Keybdtype.equalsIgnoreCase("us")) {
                this.keyboardlayout = 1024;
            }
            if (Keybdtype.equalsIgnoreCase("fr")) {
                this.keyboardlayout = 1036;
            }
            if (Keybdtype.equalsIgnoreCase("de")) {
                this.keyboardlayout = 1031;
            }
            if (Keybdtype.equalsIgnoreCase("es")) {
                this.keyboardlayout = 1034;
            }
            if (Keybdtype.equalsIgnoreCase("jp")) {
                this.keyboardlayout = 1041;
            }
        } else {
            try {
                Keybdtype = Keybdtype.substring(Keybdtype.length() - 3, Keybdtype.length());
                this.keyboardlayout = Integer.parseInt(Keybdtype, 16);
                Debug.out.println("JViewerView.KBD_TYPE" + this.keyboardlayout);
            }
            catch (Exception e) {
                Debug.out.println("Unknown Language");
            }
        }
    }

    public int getKeyboardlayout() {
        return this.keyboardlayout;
    }

    public void setKeyboardlayout(int keyboardlayout) {
        this.keyboardlayout = keyboardlayout;
    }

    public boolean OnkeyTyped(KeyEvent e) {
        int keycode = 0;
        char ascii_value = e.getKeyChar();
        switch (this.keyboardlayout) {
            case 1034: {
                if (e.getKeyLocation() != 4) {
                    keycode = this.getKeyboardKeycode(this.Spanish_Map, ascii_value, 1034);
                }
                if (e.getModifiersEx() == 8192) {
                    keycode = this.getKeyboardKeycode(this.Spanish_Alt_gr_linuxMap, ascii_value, 1034);
                    this.OnSendALTGR_Keyevent(keycode);
                    break;
                }
                this.OnSend_Keyevent(keycode);
                return true;
            }
            case 1036: {
                if (System.getProperty("os.name").equals("Linux") && e.getKeyLocation() != 4) {
                    keycode = this.getKeyboardKeycode(this.French_linuxMap, ascii_value, 1036);
                }
                if (e.getKeyLocation() != 4) {
                    keycode = this.getKeyboardKeycode(this.French_WinMap, ascii_value, 1036);
                }
                if (e.getModifiersEx() == 8192) {
                    keycode = this.getKeyboardKeycode(this.French_Alt_gr_linuxMap, ascii_value, 1036);
                    this.OnSendALTGR_Keyevent(keycode);
                    break;
                }
                this.OnSend_Keyevent(keycode);
                return true;
            }
            case 1031: {
                if (ascii_value == '\u00df' || ascii_value == '?') {
                    this.OnSend_Keyevent(47);
                    return true;
                }
                if (e.getKeyLocation() != 4) {
                    keycode = this.getKeyboardKeycode(this.German_Map, ascii_value, 1031);
                }
                if (e.getModifiersEx() == 8192) {
                    keycode = this.getKeyboardKeycode(this.German_Map_Alt_gr_linuxMap, ascii_value, 1031);
                    this.OnSendALTGR_Keyevent(keycode);
                    break;
                }
                this.OnSend_Keyevent(keycode);
                return true;
            }
        }
        return false;
    }

    private void OnSendALTGR_Keyevent(int keycode) {
        KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep m_USBKeyRep = JViewerApp.getInstance().getM_view().getM_USBKeyRep();
        m_USBKeyRep.set(17, 2, false);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(18, 3, false);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(18, 3, true);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(keycode, 1, true);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(keycode, 1, false);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(18, 3, false);
        kvmClnt.sendKMMessage(m_USBKeyRep);
    }

    private void OnSend_Keyevent(int keycode) {
        KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep m_USBKeyRep = JViewerApp.getInstance().getM_view().getM_USBKeyRep();
        m_USBKeyRep.set(keycode, 1, true);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(keycode, 1, false);
        kvmClnt.sendKMMessage(m_USBKeyRep);
    }

    private void OnSendShiftGrave_Keyevent(int keycode, int keylocation) {
        KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep m_USBKeyRep = JViewerApp.getInstance().getM_view().getM_USBKeyRep();
        m_USBKeyRep.set(16, keylocation, true);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(keycode, 1, true);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(16, keylocation, false);
        kvmClnt.sendKMMessage(m_USBKeyRep);
        m_USBKeyRep.set(keycode, 1, false);
        kvmClnt.sendKMMessage(m_USBKeyRep);
    }

    public boolean OnkeyPressed(KeyEvent e) {
        KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep m_USBKeyRep = JViewerApp.getInstance().getM_view().getM_USBKeyRep();
        switch (this.keyboardlayout) {
            case 1031: 
            case 1034: 
            case 1036: {
                int keyModifiers = e.getModifiersEx();
                if (keyModifiers == 8192) {
                    return true;
                }
                if (keyModifiers == 640) {
                    return true;
                }
                if (this.keyboardlayout != 1031) break;
                if (e.getKeyChar() == '~') {
                    this.OnSend_Keyevent(61);
                    return true;
                }
                if (e.getKeyCode() != 521) break;
                PLUS_FLAG = true;
                break;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public boolean OnkeyReleased(KeyEvent e) {
        KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
        USBKeyboardRep m_USBKeyRep = JViewerApp.getInstance().getM_view().getM_USBKeyRep();
        if ((e.getModifiersEx() & 0x200) == 512 && this.keyboardlayout == 1024) {
            return true;
        }
        int keyCode = e.getKeyCode();
        switch (this.keyboardlayout) {
            case 1031: {
                if (!System.getProperty("os.name").equals("Linux")) break;
                if (keyCode == 130 && !SHIFT_FLAG) {
                    this.OnSend_Keyevent(192);
                    DEAD_FLAG = true;
                    return true;
                }
                if (keyCode == 521 && !PLUS_FLAG) {
                    this.OnSendALTGR_Keyevent(521);
                    PLUS_FLAG = false;
                    return true;
                }
                if (keyCode == 129 && !SHIFT_FLAG) {
                    this.OnSend_Keyevent(61);
                    DEAD_FLAG = true;
                    return true;
                }
                if (keyCode == 129 && SHIFT_FLAG) {
                    this.OnSendShiftGrave_Keyevent(61, SHIFT_KEY_POSITION);
                    DEAD_FLAG = true;
                    return true;
                }
                if (DEAD_FLAG) {
                    this.OnSend_Keyevent(keyCode);
                    DEAD_FLAG = false;
                    SHIFT_FLAG = false;
                    return true;
                }
                if (keyCode == 16) {
                    SHIFT_FLAG = true;
                    SHIFT_KEY_POSITION = e.getKeyLocation();
                    DEAD_FLAG = false;
                } else {
                    SHIFT_FLAG = false;
                    DEAD_FLAG = false;
                    SHIFT_KEY_POSITION = 0;
                }
                PLUS_FLAG = false;
                break;
            }
            case 1036: {
                if (!System.getProperty("os.name").equals("Linux")) break;
                if (keyCode == 130 && !SHIFT_FLAG) {
                    this.OnSend_Keyevent(91);
                    DEAD_FLAG = true;
                    return true;
                }
                if (keyCode == 130 && SHIFT_FLAG) {
                    this.OnSendShiftGrave_Keyevent(91, SHIFT_KEY_POSITION);
                    DEAD_FLAG = true;
                    return true;
                }
                if (DEAD_FLAG) {
                    this.OnSend_Keyevent(keyCode);
                    DEAD_FLAG = false;
                    SHIFT_FLAG = false;
                    SHIFT_KEY_POSITION = 0;
                    return true;
                }
                if (keyCode == 16) {
                    SHIFT_FLAG = true;
                    SHIFT_KEY_POSITION = e.getKeyLocation();
                    DEAD_FLAG = false;
                    break;
                }
                SHIFT_FLAG = false;
                SHIFT_KEY_POSITION = 0;
                DEAD_FLAG = false;
                break;
            }
            case 1034: {
                if (!System.getProperty("os.name").equals("Linux")) break;
                if (keyCode == 129 && !SHIFT_FLAG && !ALT_GR_FLAG) {
                    this.OnSend_Keyevent(129);
                    DEAD_FLAG = !DEAD_FLAG;
                    return true;
                }
                if (keyCode == 128 && !SHIFT_FLAG && !ALT_GR_FLAG) {
                    this.OnSend_Keyevent(128);
                    DEAD_FLAG = !DEAD_FLAG;
                    return true;
                }
                if (keyCode == 129 && SHIFT_FLAG && !ALT_GR_FLAG) {
                    this.OnSendShiftGrave_Keyevent(129, SHIFT_KEY_POSITION);
                    DEAD_FLAG = !DEAD_FLAG;
                    return true;
                }
                if (keyCode == 128 && SHIFT_FLAG && !ALT_GR_FLAG) {
                    this.OnSendShiftGrave_Keyevent(128, SHIFT_KEY_POSITION);
                    DEAD_FLAG = !DEAD_FLAG;
                    return true;
                }
                if (DEAD_FLAG && !ALT_GR_FLAG) {
                    this.OnSend_Keyevent(keyCode);
                    DEAD_FLAG = false;
                    SHIFT_FLAG = false;
                    SHIFT_KEY_POSITION = 0;
                    return true;
                }
                if (keyCode == 16) {
                    SHIFT_FLAG = true;
                    SHIFT_KEY_POSITION = e.getKeyLocation();
                    DEAD_FLAG = false;
                    ALT_GR_FLAG = false;
                    break;
                }
                SHIFT_FLAG = false;
                SHIFT_KEY_POSITION = 0;
                DEAD_FLAG = false;
                ALT_GR_FLAG = false;
            }
        }
        return false;
    }

    public KeyProcessor ongetKeyprocessor() {
        KeyProcessor m_keyprocessor = null;
        switch (this.keyboardlayout) {
            case 1041: {
                m_keyprocessor = new USBKeyProcessorJapanese();
                break;
            }
            case 1031: {
                m_keyprocessor = new USBKeyProcessorGerman();
                break;
            }
            case 1036: {
                m_keyprocessor = new USBKeyProcessorFrench();
                break;
            }
            case 1034: {
                m_keyprocessor = new USBKeyProcessorSpanish();
                break;
            }
            default: {
                m_keyprocessor = new USBKeyProcessorEnglish();
            }
        }
        return m_keyprocessor;
    }

    private int getKeyboardKeycode(HashMap<Integer, Integer> Key_Map, int ascii_value, int KeyBoardType) {
        try {
            return Key_Map.get(ascii_value);
        }
        catch (Exception e) {
            switch (KeyBoardType) {
                case 1036: {
                    Debug.out.println("Exception in KBD_TYPE_FRENCH" + e);
                    break;
                }
                case 1034: {
                    Debug.out.println("Exception in KBD_TYPE_SPANISH" + e);
                    break;
                }
                case 1031: {
                    Debug.out.println("Exception in KBD_TYPE_GERMAN" + e);
                    break;
                }
                case 1024: {
                    Debug.out.println("Exception in KBD_TYPE_ENGLISH" + e);
                    break;
                }
                case 1041: {
                    Debug.out.println("Exception in KBD_TYPE_JAPANESE" + e);
                }
            }
            return -1;
        }
    }
}

