/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.gui.customizefilechooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class VideoRecordSettings
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public int Frame_Interval;
    public int Frame_No;
    public String StoreLocation;
    public String videoType = ".avi";
    private JPanel jContentPane = null;
    private JLabel jFrameInterval = null;
    private JTextField Text_Vid_Length = null;
    private JLabel path = null;
    private JTextField Text_Path = null;
    private JButton Browse = null;
    private JFileChooser fc;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JCheckBox recordMode = null;
    private JLabel recordModeLabel = null;
    private final int MAX_VIDEO_LENGTH = 3600;

    public VideoRecordSettings(JFrame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(490, 280);
        this.setLocation(new Point(200, 150));
        this.setTitle("Video Record");
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        this.Text_Path.setEditable(false);
    }

    private void close() {
        this.setVisible(false);
    }

    public JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getFrameIntervel(), null);
            this.jContentPane.add((Component)this.getFrameIntervelSecs(), null);
            this.jContentPane.add((Component)this.getStorageLocation(), null);
            this.jContentPane.add((Component)this.getText_MaxSeconds(), null);
            this.jContentPane.add((Component)this.getText_Path(), null);
            this.jContentPane.add((Component)this.getBrowse(), null);
            this.jContentPane.add((Component)this.getRecordMode(), null);
            this.jContentPane.add((Component)this.getRecordModeLabel(), null);
            this.jContentPane.add((Component)this.getOkButton(), null);
            this.jContentPane.add((Component)this.getCancelButton(), null);
        }
        return this.jContentPane;
    }

    private JLabel getFrameIntervel() {
        this.jFrameInterval = new JLabel();
        this.jFrameInterval.setHorizontalTextPosition(2);
        this.jFrameInterval.setHorizontalAlignment(2);
        this.jFrameInterval.setLocation(new Point(20, 22));
        this.jFrameInterval.setSize(new Dimension(115, 25));
        this.jFrameInterval.setText("Video Length ");
        return this.jFrameInterval;
    }

    private JTextField getText_MaxSeconds() {
        if (this.Text_Vid_Length == null) {
            this.Text_Vid_Length = new JTextField();
            this.Text_Vid_Length.setLocation(new Point(110, 25));
            this.Text_Vid_Length.setSize(new Dimension(75, 25));
            this.Text_Vid_Length.setText("20");
            this.Text_Vid_Length.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent ke) {
                    String input = VideoRecordSettings.this.Text_Vid_Length.getText();
                    if (input.length() >= 4) {
                        VideoRecordSettings.this.showMessage("Enter a Valid Time for Video Record Length.(Less than 3600)");
                        input = input.substring(0, input.length() - 1);
                        VideoRecordSettings.this.Text_Vid_Length.setText(input);
                    }
                }
            });
        }
        return this.Text_Vid_Length;
    }

    private JLabel getFrameIntervelSecs() {
        this.jFrameInterval = new JLabel();
        this.jFrameInterval.setHorizontalAlignment(2);
        this.jFrameInterval.setLocation(new Point(195, 22));
        this.jFrameInterval.setSize(new Dimension(50, 25));
        this.jFrameInterval.setText("Seconds");
        return this.jFrameInterval;
    }

    private JLabel getStorageLocation() {
        this.path = new JLabel();
        this.path.setHorizontalAlignment(2);
        this.path.setLocation(new Point(20, 74));
        this.path.setSize(new Dimension(115, 25));
        this.path.setText("Video to be Saved");
        return this.path;
    }

    JTextField getText_Path() {
        if (this.Text_Path == null) {
            this.Text_Path = new JTextField();
            this.Text_Path.setLocation(new Point(21, 110));
            this.Text_Path.setSize(new Dimension(336, 25));
            this.Text_Path.addActionListener(this);
        }
        return this.Text_Path;
    }

    private JButton getBrowse() {
        if (this.Browse == null) {
            this.Browse = new JButton();
            this.Browse.setText("Browse");
            this.Browse.setSize(new Dimension(83, 25));
            this.Browse.setLocation(new Point(377, 110));
            this.Browse.addActionListener(this);
        }
        return this.Browse;
    }

    private JCheckBox getRecordMode() {
        this.recordMode = new JCheckBox("Normalized video resolution to 1024 X 768.");
        this.recordMode.setLocation(new Point(20, 200));
        this.recordMode.setSize(new Dimension(300, 20));
        this.recordMode.setBorder(null);
        this.recordMode.setSelected(true);
        this.recordMode.addActionListener(this);
        return this.recordMode;
    }

    private JLabel getRecordModeLabel() {
        this.recordModeLabel = new JLabel();
        this.recordModeLabel.setHorizontalTextPosition(2);
        this.recordModeLabel.setHorizontalAlignment(2);
        this.recordModeLabel.setLocation(new Point(35, 215));
        this.recordModeLabel.setSize(new Dimension(325, 25));
        this.recordModeLabel.setText("This might reduce the video quality!");
        return this.recordModeLabel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.setSize(new Dimension(83, 25));
            this.okButton.setLocation(new Point(378, 164));
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setSize(new Dimension(84, 25));
            this.cancelButton.setPreferredSize(new Dimension(70, 25));
            this.cancelButton.setLocation(new Point(377, 200));
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    public void showMessage(String str) {
        JOptionPane.showMessageDialog(this.jContentPane, str, "Video Recording", 0);
    }

    private boolean isValidNumber(String str) {
        int num = Integer.parseInt(str);
        return num >= 1 && num <= 3600;
    }

    private boolean directoryCheck(String str) {
        File file = new File(str);
        return file.isDirectory();
    }

    private boolean isParsableToInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.Browse) {
            this.fc = new JFileChooser();
            this.fc.setFileSelectionMode(1);
            customizefilechooser customfilechooser = new customizefilechooser();
            customfilechooser.customizeFileChooser(this.fc);
            int returnVal = this.fc.showDialog(this, "Choose Directory");
            if (returnVal == 0) {
                this.StoreLocation = this.fc.getSelectedFile().toString();
            }
            this.Text_Path.setText(this.StoreLocation);
        }
        if (e.getSource() == this.okButton) {
            if (this.Text_Path.getText().length() == 0) {
                this.showMessage("Enter a Valid Directory Path. Use Browse Button to Choose an Appropriate Directory");
            } else if (!this.directoryCheck(this.StoreLocation)) {
                this.showMessage("Enter a Valid Directory Path. Use Browse Button to Choose an Appropriate Directory");
            } else if (this.Text_Vid_Length.getText().length() == 0) {
                this.showMessage("Enter the Length of Video to be Recorded");
            } else if (!this.isParsableToInt(this.Text_Vid_Length.getText()) || !this.isValidNumber(this.Text_Vid_Length.getText())) {
                this.showMessage("Enter a Valid Time for Video Record Length.(Less than 3600)");
                this.Text_Vid_Length.requestFocus();
                this.Text_Vid_Length.selectAll();
            } else {
                this.close();
                JViewerApp.getInstance().getM_videorecord().StoreLocation = this.StoreLocation;
                VideoRecord.RecordStopTimer = Integer.parseInt(this.Text_Vid_Length.getText());
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordStart", true);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordStop", false);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordSettings", true);
            }
        }
        if (e.getSource() == this.cancelButton) {
            this.close();
        }
        if (e.getSource() == this.recordMode && !this.recordMode.isSelected()) {
            if (JOptionPane.showConfirmDialog(this.jContentPane, "Separate video files will be created for each resolution change in the host screen.", "Video Recording", 2, 1) == 0) {
                JViewerApp.getInstance().getM_videorecord().singleVideo = false;
            } else {
                JViewerApp.getInstance().getM_videorecord().singleVideo = true;
                this.recordMode.setSelected(true);
            }
        }
    }
}

