/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.jvvideo;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.common.ISOCJVVideo;
import com.ami.kvm.jviewer.gui.FrameRateTask;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.PowerStatusMonitor;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;

public class JVVideo {
    public static final int MIN_X_RESOLUTION = 300;
    public static final int MIN_Y_RESOLUTION = 200;
    public static final int MAX_X_RESOLUTION = 1920;
    public static final int MAX_Y_RESOLUTION = 1200;
    private Timer m_frTmr;
    private int m_frameRate;
    private JViewerView m_view = JViewerApp.getInstance().getRCView();
    private ISOCFrameHdr m_frameHdr;
    private boolean newFrame = false;
    private PowerStatusMonitor psMonitor = null;
    private Timer psMonitorTimer = null;
    ISOCJVVideo VideoSOC;

    public JVVideo() {
        this.m_view.setRCView(1920, 1200, 0);
        this.m_frameHdr = JViewerApp.getSoc_manager().getSOCFramehdr();
        this.VideoSOC = JViewerApp.getSoc_manager().getSOCJVVideo();
        this.VideoSOC.setframehdr(this.m_frameHdr);
        this.VideoSOC.VideoBuffer_Initialize();
        if (!JViewer.isWebPreviewer()) {
            this.m_frameRate = 0;
            this.m_frTmr = new Timer();
            this.m_frTmr.schedule((TimerTask)new FrameRateTask(), 0L, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onNewFrame(ByteBuffer frameByteBuf) {
        Object object;
        ++this.m_frameRate;
        this.m_frameHdr.setHeader(frameByteBuf);
        JViewerApp.getInstance().setSocframeHdr(this.m_frameHdr);
        this.VideoSOC.Newframevalidate();
        this.setNewFrame(true);
        if (!(this.m_view.viewWidth() == this.m_frameHdr.getresX() && this.m_view.viewHeight() == this.m_frameHdr.getresY() || this.onResolutionChange())) {
            return 0;
        }
        ByteBuffer CompBuffer = this.VideoSOC.decompressframe(this.m_frameHdr, frameByteBuf);
        this.VideoSOC.SOC_Specific(CompBuffer);
        if (VideoRecord.Recording_Started) {
            object = JViewerApp.getInstance().getM_videorecord().obj;
            synchronized (object) {
                JViewerApp.getInstance().getM_videorecord().obj.notify();
            }
        }
        if (this.psMonitor != null && this.psMonitor.isMonitorRunning()) {
            object = this.psMonitor.getSyncObj();
            synchronized (object) {
                this.psMonitor.getSyncObj().notify();
            }
        }
        this.m_view.repaint();
        return 0;
    }

    public boolean isNewFrame() {
        return this.newFrame;
    }

    public void setNewFrame(boolean newFrame) {
        this.newFrame = newFrame;
    }

    public boolean onResolutionChange() {
        Debug.out.println("Resolution change " + this.m_frameHdr.getresX() + ":" + this.m_frameHdr.getresY());
        if (this.m_frameHdr.getresX() < 300 || this.m_frameHdr.getresX() > 1920 || this.m_frameHdr.getresY() < 200 || this.m_frameHdr.getresY() > 1200) {
            Debug.out.println("Invalid resolution");
            return false;
        }
        if (!(JViewer.isplayerapp() || JViewer.isdownloadapp() || JViewer.isWebPreviewer())) {
            this.setFullScreenMode();
            this.m_view.setRCView(this.m_frameHdr.getresX(), this.m_frameHdr.getresY(), this.m_frameHdr.getFrameType());
            Mousecaliberation.resetCursor();
            if (this.m_view.getMouseRedirStatus()) {
                this.m_view.USBsyncCursor(false);
                this.m_view.USBsyncCursor(true);
            }
            if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                if (JViewerApp.getInstance().getJVMenu().getMenuItem("MouseShowCursor").isSelected()) {
                    JViewerApp.getInstance().OnShowCursor(false);
                    JViewerApp.getInstance().OnShowCursor(true);
                } else {
                    JViewerApp.getInstance().OnShowCursor(false);
                }
            }
        }
        System.gc();
        return true;
    }

    public void onCompressionChange() {
        this.VideoSOC.soccompressionchange();
    }

    public void onBlankScreen() {
        this.VideoSOC.SOCBlankscreen();
        try {
            JViewerApp.getInstance().getPrepare_buf().clearImage();
        }
        catch (Exception e) {
            JViewerApp.getInstance().getKVMClient().m_isBlank = false;
        }
        URL imageURL = JViewer.class.getResource("res/nosignal.jpg");
        BufferedImage img = null;
        try {
            img = ImageIO.read(imageURL);
        }
        catch (IOException e) {
            Debug.out.println(e);
        }
        JViewerApp.getInstance().getPrepare_buf().SetImage(img);
        this.m_view.repaint();
        this.setNewFrame(false);
        if (JViewer.isjviewerapp()) {
            if (this.psMonitor != null) {
                return;
            }
            this.psMonitor = new PowerStatusMonitor();
            if (!this.psMonitor.isMonitorRunning()) {
                this.psMonitorTimer = new Timer(true);
                try {
                    this.psMonitorTimer.schedule((TimerTask)this.psMonitor, 0L, 30000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void reset() {
        this.m_view.repaint();
        this.m_frTmr.cancel();
        this.VideoSOC.SOCreset();
        JViewerApp.getInstance().setAppWndLabel("0 fps");
    }

    public void refresh() {
        this.m_frTmr = new Timer();
        this.m_frTmr.schedule((TimerTask)new FrameRateTask(), 0L, 1000L);
    }

    public ISOCFrameHdr getM_frameHdr() {
        return this.m_frameHdr;
    }

    public ISOCJVVideo getVideoSOC() {
        return this.VideoSOC;
    }

    public void setVideoSOC(ISOCJVVideo videoSOC) {
        this.VideoSOC = videoSOC;
    }

    public int getM_frameRate() {
        return this.m_frameRate;
    }

    public void setM_frameRate(int rate) {
        this.m_frameRate = rate;
    }

    public void setFullScreenMode() {
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        if (sd.height == this.m_frameHdr.getresY() && sd.width == this.m_frameHdr.getresX()) {
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoFullScreen", true);
            JViewerApp.getInstance().getM_wndFrame().toolbar.fullScreenBtn.setToolTipText("Shows FullScreen");
        } else {
            if (JViewerApp.getInstance().getJVMenu().getMenuItem("VideoFullScreen").isSelected()) {
                JViewerApp.getInstance().OnVideoFullScreen(false);
            }
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoFullScreen", false);
            JViewerApp.getInstance().getM_wndFrame().toolbar.fullScreenBtn.setToolTipText("Full Screen option is disabled");
        }
    }

    public PowerStatusMonitor getPsMonitor() {
        return this.psMonitor;
    }

    public void setPsMonitor(PowerStatusMonitor psMonitor) {
        this.psMonitor = psMonitor;
    }

    public Timer getPsMonitorTimer() {
        return this.psMonitorTimer;
    }

    public void setPsMonitorTimer(Timer psMonitorTimer) {
        this.psMonitorTimer = psMonitorTimer;
    }
}

