/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.HeaderReader;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import java.net.Socket;
import java.nio.ByteBuffer;

public class FragReader
implements KVMReader {
    private KVMClient m_client;
    private byte[] m_frameBuf;
    private ByteBuffer m_frameByteBuf;
    private int m_fragIx;
    private int m_frameIx;

    public FragReader(KVMClient client) {
        this.m_client = client;
        this.m_frameBuf = new byte[9216000];
        this.m_frameIx = 0;
        this.m_frameByteBuf = ByteBuffer.wrap(this.m_frameBuf);
    }

    @Override
    public void initialize() {
        if ((this.m_client.m_fragNum & Short.MAX_VALUE) == 0) {
            this.m_frameIx = 0;
        }
        this.m_frameByteBuf.position(this.m_frameIx);
        this.m_frameByteBuf.limit(this.m_frameIx + this.m_client.m_pktHdr.pktSize - 2);
        this.m_fragIx = 0;
    }

    @Override
    public int read(Socket sockCh) {
        try {
            byte[] read_frameByteBuf = new byte[this.m_frameByteBuf.remaining()];
            this.m_fragIx = this.m_client.read_data(sockCh, read_frameByteBuf);
            this.m_frameByteBuf.put(read_frameByteBuf);
        }
        catch (Exception e) {
            Debug.out.println("FRAG_RDR " + e);
            return -1;
        }
        if (this.m_fragIx == this.m_client.m_pktHdr.pktSize - 2) {
            this.m_frameIx += this.m_fragIx;
            if (0 != (this.m_client.m_fragNum & 0x8000)) {
                this.m_frameByteBuf.limit(this.m_frameIx);
                this.m_client.onNewFrame(this.m_frameByteBuf);
                this.m_frameIx = 0;
            }
            HeaderReader reader = this.m_client.getHdrReader();
            reader.initialize();
            this.m_client.setState(reader);
        }
        return 0;
    }
}

