/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc;

import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SOCFrameHdr
implements ISOCFrameHdr {
    public static final int HDR_SIZE = 13;
    public static final int FRAME_TYPE_UNKNOWN = -1;
    public byte flags;
    public int frameSize;
    public static short resX;
    public short resY;
    public short actresX;
    public short actresY;
    public byte cellX;
    public byte cellY;
    public byte tLow;
    public byte tHigh;
    public byte tScr;
    public byte tStatic;

    public int frameSize() {
        return this.frameSize;
    }

    @Override
    public int getFrameType() {
        return -1;
    }

    @Override
    public short getheight() {
        return this.resY;
    }

    @Override
    public short getresX() {
        return resX;
    }

    @Override
    public short getresY() {
        return this.resY;
    }

    @Override
    public short getwidth() {
        return resX;
    }

    @Override
    public short getcurwidth() {
        return resX;
    }

    @Override
    public short getcurheight() {
        return this.resY;
    }

    public short getactresX() {
        return this.actresX;
    }

    public short getactresY() {
        return this.actresY;
    }

    @Override
    public int getFrameHeadersize() {
        return 13;
    }

    @Override
    public int getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    @Override
    public void setHeader(ByteBuffer frameByteBuf) {
        frameByteBuf.order(ByteOrder.LITTLE_ENDIAN);
        frameByteBuf.flip();
        this.flags = frameByteBuf.get();
        this.frameSize = frameByteBuf.getInt();
        resX = frameByteBuf.getShort();
        this.resY = frameByteBuf.getShort();
        this.actresX = frameByteBuf.getShort();
        this.actresY = frameByteBuf.getShort();
        this.readCaptureParams(frameByteBuf);
    }

    private void readCaptureParams(ByteBuffer buf) {
        this.cellX = 1;
        this.cellY = 1;
        this.tLow = 1;
        this.tHigh = 1;
        this.tScr = 1;
        this.tStatic = 1;
    }
}

