/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.videorecord;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.RecorderToolBar;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.gui.customizefilechooser;
import com.ami.kvm.jviewer.videorecord.DisplayVideoDataTask;
import com.ami.kvm.jviewer.videorecord.URLProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VideoRecordApp {
    public String Videostorepath;
    public String Videotmpstorepath;
    public String VideFilename;
    public byte[] writedata;
    public Timer displayTaskTimer;
    public DisplayVideoDataTask displayTask;
    private long duration;
    private JDialog infoDialog;
    private JPanel infoMessagePanel;
    JLabel infoMessageLabel;

    public int startVideorecordRedirection(String ip, String webPort, int secureConnect, String sessionCookies, String videofilename) {
        int retval = 0;
        this.showInformationDialog("Connecting and Downlaoding in progress...");
        retval = this.OnconnectHTTPDownloadFile(ip, webPort, secureConnect, sessionCookies, videofilename);
        this.disposeInformationDialog();
        if (retval < 0) {
            return -1;
        }
        if (JViewer.isdownloadapp()) {
            this.Videostorepath = this.OngetFoldername();
            if (this.Videostorepath == null) {
                return -1;
            }
        }
        this.OnVideorecordStartRedirection();
        return 0;
    }

    public void Ondeletetmpfile() {
        try {
            File tempvideofile = new File(this.Videotmpstorepath);
            tempvideofile.delete();
        }
        catch (Exception e) {
            return;
        }
    }

    private int OnconnectHTTPDownloadFile(String ip, String webPort, int secureConnect, String sessionCookies, String videofilename) {
        int ret = -1;
        this.VideFilename = videofilename;
        String urlPath = null;
        URLProcessor downloadurl = new URLProcessor(sessionCookies, secureConnect);
        if (secureConnect == 0) {
            urlPath = "http://" + ip + ":" + webPort + "/rpc/downloadvideo.asp?FILE_NAME=" + videofilename + "&FILE_ACCESS=1";
        } else if (secureConnect == 1) {
            urlPath = "https://" + ip + ":" + webPort + "/rpc/downloadvideo.asp?FILE_NAME=" + videofilename + "&FILE_ACCESS=1";
        }
        ret = downloadurl.connect_url_lock(urlPath);
        if (ret < 0) {
            return -1;
        }
        if (secureConnect == 0) {
            urlPath = "http://" + ip + ":" + webPort + "/video/" + videofilename;
        } else if (secureConnect == 1) {
            urlPath = "https://" + ip + ":" + webPort + "/video/" + videofilename;
        }
        try {
            ret = downloadurl.download(urlPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ret < 0) {
            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), "Error in Downlaoding the file", "Error", 3);
            return -1;
        }
        if (secureConnect == 0) {
            urlPath = "http://" + ip + ":" + webPort + "/rpc/downloadvideo.asp?FILE_NAME=" + videofilename + "&FILE_ACCESS=0";
        } else if (secureConnect == 1) {
            urlPath = "https://" + ip + ":" + webPort + "/rpc/downloadvideo.asp?FILE_NAME=" + videofilename + "&FILE_ACCESS=0";
        }
        ret = downloadurl.connect_url_lock(urlPath);
        if (ret < 0) {
            return -1;
        }
        String path = System.getProperty("java.io.tmpdir");
        this.Videotmpstorepath = path + "video" + System.currentTimeMillis();
        ret = this.writedatatofile(this.Videotmpstorepath);
        if (ret < 0) {
            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), "Error in Craeting the Temporary file", "Error", 3);
            return -1;
        }
        return 0;
    }

    public String OngetFoldername() {
        JVFrame frame = JViewerApp.getInstance().getMainWindow();
        String storepath = null;
        int returnVal = 1;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        customizefilechooser customfilechooser = new customizefilechooser();
        customfilechooser.customizeFileChooser(fc);
        while ((returnVal = fc.showDialog(frame, "Choose Directory")) != 0) {
            int ret = JOptionPane.showConfirmDialog(frame, "The application will close unless a valid storage path is selected for the downloaded file.\nDo you want to close the application?", "Confirm Application Close", 0, 3);
            if (ret != 0) continue;
            storepath = null;
            JViewerApp.getInstance().getM_wndFrame().windowClosed();
        }
        storepath = fc.getSelectedFile().toString();
        return storepath;
    }

    public void OnVideorecordStartRedirection() {
        if (JViewer.isdownloadapp()) {
            VideoRecord record = JViewerApp.getInstance().getM_videorecord();
            record.StoreLocation = JViewerApp.getInstance().getVideorecordapp().Videostorepath;
            record.OnVideoRecordStart();
        } else {
            RecorderToolBar toolBar = (RecorderToolBar)JViewerApp.getInstance().getM_wndFrame().toolbar;
            toolBar.disableButton(toolBar.replayButton);
        }
        this.displayTask = new DisplayVideoDataTask(JViewerApp.getInstance().getVideorecordapp().getWritedata());
        this.displayTaskTimer = new Timer();
        this.displayTaskTimer.schedule((TimerTask)this.displayTask, 0L);
    }

    public int writedatatofile(String path) {
        try {
            File file = new File(path);
            FileOutputStream fos = new FileOutputStream(file);
            if (this.writedata != null) {
                try {
                    fos.write(this.writedata);
                }
                catch (IOException e) {
                    return -1;
                }
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                return -1;
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("FileNotFoundException : " + ex);
            return -1;
        }
        catch (IOException ioe) {
            System.out.println("IOException : " + ioe);
            return -1;
        }
        return 0;
    }

    public void showInformationDialog(String Msg) {
        JFrame frame = JViewer.getMainFrame();
        this.infoDialog = new JDialog(frame, "", false);
        this.infoMessagePanel = new JPanel();
        this.infoMessageLabel = new JLabel(Msg);
        this.infoMessageLabel.setHorizontalAlignment(0);
        this.infoMessageLabel.setFont(new Font("Arial", 1, 18));
        this.infoMessagePanel.setLayout(new BorderLayout());
        this.infoMessagePanel.add((Component)this.infoMessageLabel, "Center");
        this.infoDialog.setSize(700, 50);
        this.infoDialog.setLocationRelativeTo(frame);
        this.infoDialog.add(this.infoMessagePanel);
        this.infoDialog.setUndecorated(true);
        this.infoDialog.setResizable(false);
        this.infoDialog.setVisible(true);
        this.infoDialog.requestFocus();
        this.infoMessageLabel.setText(Msg);
    }

    public byte[] getWritedata() {
        return this.writedata;
    }

    public void setWritedata(byte[] writedata) {
        this.writedata = writedata;
    }

    public void disposeInformationDialog() {
        this.infoDialog.dispose();
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getVideotmpstorepath() {
        return this.Videotmpstorepath;
    }

    public void setVideotmpstorepath(String videotmpstorepath) {
        this.Videotmpstorepath = videotmpstorepath;
    }
}

