/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.stunnel.StunnelUtility;

public class IPMIChassisCommand
extends IPMICommand {
    public IPMIChassisCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getChassisStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)0, (byte)1, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemRestartCauseCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)0, (byte)7, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemBootOptionsCommand(byte selector, byte setSelector, byte blockSelector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{selector, setSelector, blockSelector};
        ipmiMessage.setCommandAndData((byte)0, (byte)9, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSystemBootOptionsCommand(byte validAndSelector, byte[] pData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + pData.length];
        data[0] = validAndSelector;
        System.arraycopy(pData, 0, data, 1, pData.length);
        ipmiMessage.setCommandAndData((byte)0, (byte)8, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPowerCycleIntervalCommand(byte interval) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{interval};
        ipmiMessage.setCommandAndData((byte)0, (byte)11, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage chassisControlCommand(byte parameter) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{parameter};
        ipmiMessage.setCommandAndData((byte)0, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setChassisIdentifyCommand(byte times, byte infinite) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{times, infinite};
        ipmiMessage.setCommandAndData((byte)0, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public boolean powerDown() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean powerUp() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean powerCycle() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)2);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean reset() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)3);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean softShutdown() {
        byte command = 5;
        IPMIMessage resMessage = this.chassisControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute soft shut down");
        return false;
    }

    public boolean setPowerCycleInterval(byte interval) {
        IPMIMessage resMessage = this.setPowerCycleIntervalCommand(interval);
        if (resMessage != null && resMessage.completionCode == 0) {
            return true;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't set power cycle interval");
        return false;
    }

    public boolean keepBootFlagValidBit() {
        byte[] data = new byte[]{1, 1};
        IPMIMessage resMessage = this.setSystemBootOptionsCommand((byte)4, data);
        if (resMessage != null && resMessage.completionCode == 0 && (resMessage = this.setSystemBootOptionsCommand((byte)3, data = new byte[]{31})) != null && resMessage.completionCode == 0) {
            return true;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't keep boot flag valid bit");
        return false;
    }

    public boolean setChassisIdentify(boolean isOn) {
        IPMIMessage resMessage = isOn ? this.setChassisIdentifyCommand((byte)0, (byte)1) : this.setChassisIdentifyCommand((byte)0, (byte)0);
        if (resMessage != null && resMessage.completionCode == 0) {
            return true;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't set chassis identify");
        return false;
    }

    public boolean setBootDeviceOption(GlobalDefine.BootDevice device) {
        return this.setBootDeviceOption(device, false);
    }

    public boolean setBootDeviceOption(GlobalDefine.BootDevice device, boolean isBeforeX12) {
        return this.setBootDeviceOption(device, isBeforeX12, false);
    }

    public boolean setBootDeviceOption(GlobalDefine.BootDevice device, boolean isBeforeX12, boolean isPersistent) {
        try {
            byte[] data = new byte[]{1, 1};
            IPMIMessage resMessage = this.setSystemBootOptionsCommand((byte)4, data);
            if (resMessage != null && resMessage.completionCode == 0) {
                data = new byte[5];
                data[0] = -128;
                data[2] = 0;
                data[3] = 0;
                data[4] = 0;
                switch (device) {
                    case PXE: {
                        data[1] = 4;
                        break;
                    }
                    case HD_DEFAULT: {
                        data[1] = 8;
                        break;
                    }
                    case CD_DVD: {
                        data[1] = 20;
                        break;
                    }
                    case BIOS: {
                        data[1] = 24;
                        break;
                    }
                    case FLOPPY_REMOVABLE_MEDIA: {
                        data[1] = 60;
                        break;
                    }
                    case USB_KEY: {
                        data[1] = 36;
                        break;
                    }
                    case USB_HDD: {
                        data[1] = 44;
                        break;
                    }
                    case USB_FLOPPY: {
                        data[1] = 28;
                        break;
                    }
                    case USB_CD_DVD: {
                        data[1] = 32;
                        break;
                    }
                    case UEFI_USB_KEY: {
                        data[1] = isBeforeX12 ? 8 : 36;
                        data[0] = -96;
                        break;
                    }
                    case UEFI_CD_DVD: {
                        data[1] = 20;
                        data[0] = -96;
                        break;
                    }
                    case UEFI_HD: {
                        data[1] = isBeforeX12 ? 36 : 8;
                        data[0] = -96;
                        break;
                    }
                    case UEFI_USB_HDD: {
                        data[1] = 44;
                        data[0] = -96;
                        break;
                    }
                    case UEFI_USB_CDDVD: {
                        data[1] = 32;
                        data[0] = -96;
                        break;
                    }
                    case UEFI_PXE: {
                        data[1] = 4;
                        data[0] = -96;
                        break;
                    }
                    default: {
                        data[0] = 0;
                        data[1] = 0;
                    }
                }
                if (isPersistent) {
                    data[0] = (byte)(data[0] | 0x40);
                }
                if ((resMessage = this.setSystemBootOptionsCommand((byte)5, data)) != null && resMessage.completionCode == 0) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            MessageCenter.getInstance().put(this, (Object)"Can't execute set boot device option");
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set boot device option");
        return false;
    }

    public GlobalDefine.BootDevice getBootDeviceOption(boolean isBeforeX12) throws Exception {
        IPMIMessage resMessage = this.getSystemBootOptionsCommand((byte)5, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return this.getBootDeviceOption(resMessage.data, isBeforeX12);
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new Exception("Can't execute get boot device option");
    }

    public GlobalDefine.BootDevice getBootDeviceOption(byte[] bootOptionParam, boolean isLegacyDevice) {
        GlobalDefine.BootDevice device = GlobalDefine.BootDevice.NONE;
        if (bootOptionParam == null || bootOptionParam.length < 4) {
            return null;
        }
        if ((bootOptionParam[2] & 0x20) == 32) {
            switch (bootOptionParam[3]) {
                case 4: {
                    device = GlobalDefine.BootDevice.UEFI_PXE;
                    break;
                }
                case 8: {
                    if (isLegacyDevice) {
                        device = GlobalDefine.BootDevice.UEFI_USB_KEY;
                        break;
                    }
                    device = GlobalDefine.BootDevice.UEFI_HD;
                    break;
                }
                case 20: {
                    device = GlobalDefine.BootDevice.UEFI_CD_DVD;
                    break;
                }
                case 32: {
                    device = GlobalDefine.BootDevice.UEFI_USB_CDDVD;
                    break;
                }
                case 36: {
                    if (isLegacyDevice) {
                        device = GlobalDefine.BootDevice.UEFI_HD;
                        break;
                    }
                    device = GlobalDefine.BootDevice.UEFI_USB_KEY;
                    break;
                }
                case 44: {
                    device = GlobalDefine.BootDevice.UEFI_USB_HDD;
                }
            }
        } else {
            switch (bootOptionParam[3]) {
                case 4: {
                    device = GlobalDefine.BootDevice.PXE;
                    break;
                }
                case 8: {
                    device = GlobalDefine.BootDevice.HD_DEFAULT;
                    break;
                }
                case 20: {
                    device = GlobalDefine.BootDevice.CD_DVD;
                    break;
                }
                case 24: {
                    device = GlobalDefine.BootDevice.BIOS;
                    break;
                }
                case 28: {
                    device = GlobalDefine.BootDevice.USB_FLOPPY;
                    break;
                }
                case 32: {
                    device = GlobalDefine.BootDevice.USB_CD_DVD;
                    break;
                }
                case 36: {
                    device = GlobalDefine.BootDevice.USB_KEY;
                    break;
                }
                case 44: {
                    device = GlobalDefine.BootDevice.USB_HDD;
                    break;
                }
                case 60: {
                    device = GlobalDefine.BootDevice.FLOPPY_REMOVABLE_MEDIA;
                }
            }
        }
        return device;
    }

    public byte[] getBootOptionsParameter() throws Exception {
        IPMIMessage message = this.getSystemBootOptionsCommand((byte)5, (byte)0, (byte)0);
        if (message != null) {
            if (message.completionCode == 0) {
                return message.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(message.completionCode));
        }
        throw new Exception("Can't execute get boot device option");
    }

    public boolean isBootDeviceOptionFlagValid(byte[] bootOptionParam) {
        if (bootOptionParam != null && bootOptionParam.length >= 3) {
            return (bootOptionParam[2] & 0x80) != 0;
        }
        return false;
    }

    public boolean isBootDeviceOptionPersistent(byte[] bootOptionParam) {
        if (bootOptionParam != null && bootOptionParam.length >= 3) {
            return (bootOptionParam[2] & 0x40) != 0;
        }
        return false;
    }

    public boolean injectNMI() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)4);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean isPowerOn() throws IPMIException {
        IPMIMessage resMessage = this.getChassisStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (resMessage.data[0] & 1) == 1;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getChassisStatusCommand failed");
    }

    public static void main(String[] args) {
        boolean result;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.168.10.92");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiChassisCommand.setIPMIInterface(rmcp);
        IPMIMessage resMessage = ipmiChassisCommand.getChassisStatusCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            MessageCenter.getInstance().put(ByteUtility.bytesToHex(resMessage.data));
        }
        if ((resMessage = ipmiChassisCommand.getSystemRestartCauseCommand()) != null && resMessage.completionCode == 0) {
            MessageCenter.getInstance().put(ByteUtility.bytesToHex(resMessage.data));
        }
        if (result = ipmiChassisCommand.softShutdown()) {
            MessageCenter.getInstance().put("ok");
        } else {
            MessageCenter.getInstance().put("failed");
        }
        sessionController.closeSession();
    }
}

