/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.FRU;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.stunnel.StunnelUtility;

public class IPMIFRUCommand
extends IPMICommand {
    public IPMIFRUCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getFRUInventoryAreaInfoCommand(byte fruDeviceID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{fruDeviceID};
        ipmiMessage.setCommandAndData((byte)40, (byte)16, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage readFRUDataCommand(byte fruDeviceID, byte[] offset, byte countToRead) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        data[0] = fruDeviceID;
        System.arraycopy(offset, 0, data, 1, 2);
        data[3] = countToRead;
        ipmiMessage.setCommandAndData((byte)40, (byte)17, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage writeFRUDataCommand(byte fruDeviceID, byte[] offset, byte[] buffer) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + buffer.length];
        data[0] = fruDeviceID;
        System.arraycopy(offset, 0, data, 1, 2);
        System.arraycopy(buffer, 0, data, 3, buffer.length);
        ipmiMessage.setCommandAndData((byte)40, (byte)18, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage lockFRUCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)6, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage unlockFRUCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)6, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public int getFRUSize() {
        IPMIMessage resMessage = this.getFRUInventoryAreaInfoCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                int size = 0;
                size = (resMessage.data[0] & 0xFF) + ((resMessage.data[1] & 0xFF) << 8);
                if (resMessage.data[2] == 1) {
                    size *= 2;
                }
                return size;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute GET FRU Inventory Area Info");
        return 0;
    }

    public int getFRUSize(byte fruDeviceID) {
        IPMIMessage resMessage = this.getFRUInventoryAreaInfoCommand(fruDeviceID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                int size = 0;
                size = (resMessage.data[0] & 0xFF) + ((resMessage.data[1] & 0xFF) << 8);
                if (resMessage.data[2] == 1) {
                    size *= 2;
                }
                return size;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute GET FRU Inventory Area Info");
        return 0;
    }

    public FRUInfo getFRUData() {
        int size = this.getFRUSize();
        int countToRead = 16;
        if (size <= 0) {
            return null;
        }
        byte[] data = new byte[size];
        boolean count = false;
        for (int i = 0; i <= size - countToRead; i += countToRead) {
            MessageCenter.getInstance().put(this, (Object)("Read FRU segment (" + i + ")"));
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            IPMIMessage resMessage = this.readFRUDataCommand((byte)0, offset, (byte)countToRead);
            if (resMessage == null) continue;
            if (resMessage.completionCode == 0) {
                byte[] dataSegment = new byte[resMessage.data[0]];
                System.arraycopy(resMessage.data, 1, dataSegment, 0, dataSegment.length);
                System.arraycopy(dataSegment, 0, data, i, dataSegment.length);
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        return FRUInfo.fromRaw(data);
    }

    public FRUInfo getFRUData(byte fruDeviceID) {
        int size = this.getFRUSize(fruDeviceID);
        int countToRead = 16;
        if (size <= 0) {
            return null;
        }
        byte[] data = new byte[size];
        for (int i = 0; i <= size - countToRead; i += countToRead) {
            MessageCenter.getInstance().put(this, (Object)("Read FRU segment (" + i + ")"));
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            IPMIMessage resMessage = this.readFRUDataCommand(fruDeviceID, offset, (byte)countToRead);
            if (resMessage == null) continue;
            if (resMessage.completionCode == 0) {
                byte[] dataSegment = new byte[resMessage.data[0]];
                System.arraycopy(resMessage.data, 1, dataSegment, 0, dataSegment.length);
                System.arraycopy(dataSegment, 0, data, i, dataSegment.length);
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        return FRUInfo.fromFRU1Raw(data);
    }

    public FRUInfo getFRUNData(byte fruDeviceID) {
        int size = this.getFRUSize(fruDeviceID);
        int countToRead = 16;
        if (size <= 0) {
            return null;
        }
        byte[] data = new byte[size];
        for (int i = 0; i <= size - countToRead; i += countToRead) {
            MessageCenter.getInstance().put(this, (Object)("Read FRU segment (" + i + ")"));
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            IPMIMessage resMessage = this.readFRUDataCommand(fruDeviceID, offset, (byte)countToRead);
            if (resMessage == null) continue;
            if (resMessage.completionCode == 0) {
                byte[] dataSegment = new byte[resMessage.data[0]];
                System.arraycopy(resMessage.data, 1, dataSegment, 0, dataSegment.length);
                System.arraycopy(dataSegment, 0, data, i, dataSegment.length);
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        return FRUInfo.fromRaw(data);
    }

    public byte[] getFRURawData() {
        int size = this.getFRUSize();
        int countToRead = 16;
        if (size <= 0) {
            return null;
        }
        byte[] data = new byte[size];
        boolean count = false;
        for (int i = 0; i <= size - countToRead; i += countToRead) {
            MessageCenter.getInstance().put(this, (Object)("Read FRU segment (" + i + ")"));
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            IPMIMessage resMessage = this.readFRUDataCommand((byte)0, offset, (byte)countToRead);
            if (resMessage == null) continue;
            if (resMessage.completionCode == 0) {
                byte[] dataSegment = new byte[resMessage.data[0]];
                System.arraycopy(resMessage.data, 1, dataSegment, 0, dataSegment.length);
                System.arraycopy(dataSegment, 0, data, i, dataSegment.length);
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        return data;
    }

    public byte[] getFRU1RawData() {
        int size = this.getFRUSize((byte)1);
        int countToRead = 16;
        if (size <= 0) {
            return null;
        }
        byte[] data = new byte[size];
        boolean count = false;
        for (int i = 0; i <= size - countToRead; i += countToRead) {
            MessageCenter.getInstance().put(this, (Object)("Read FRU segment (" + i + ")"));
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            IPMIMessage resMessage = this.readFRUDataCommand((byte)1, offset, (byte)countToRead);
            if (resMessage == null) continue;
            if (resMessage.completionCode == 0) {
                byte[] dataSegment = new byte[resMessage.data[0]];
                System.arraycopy(resMessage.data, 1, dataSegment, 0, dataSegment.length);
                System.arraycopy(dataSegment, 0, data, i, dataSegment.length);
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        return data;
    }

    public byte[] getFRUNRawData(byte number) {
        int size = this.getFRUSize(number);
        int countToRead = 16;
        if (size <= 0) {
            return null;
        }
        byte[] data = new byte[size];
        boolean count = false;
        for (int i = 0; i <= size - countToRead; i += countToRead) {
            MessageCenter.getInstance().put(this, (Object)("Read FRU segment (" + i + ")"));
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            IPMIMessage resMessage = this.readFRUDataCommand(number, offset, (byte)countToRead);
            if (resMessage == null) continue;
            if (resMessage.completionCode == 0) {
                byte[] dataSegment = new byte[resMessage.data[0]];
                System.arraycopy(resMessage.data, 1, dataSegment, 0, dataSegment.length);
                System.arraycopy(dataSegment, 0, data, i, dataSegment.length);
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        return data;
    }

    public boolean writeFRU(FRU fru) {
        byte[] raw;
        byte[] fruData = fru.toRaw();
        if (fruData.length > (raw = new byte[this.getFRUSize()]).length) {
            System.out.println("Data exeed the maximum acceptable length.");
            return false;
        }
        System.arraycopy(fruData, 0, raw, 0, fruData.length);
        if (!this.unlockFRU()) {
            MessageCenter.getInstance().put(this, (Object)"Could not unlock FRU data");
            return false;
        }
        byte[] buffer = new byte[8];
        for (int i = 0; i < raw.length; i += 8) {
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            if (i + 8 <= raw.length) {
                System.arraycopy(raw, i, buffer, 0, 8);
            } else {
                System.arraycopy(raw, i, buffer, 0, raw.length - i);
            }
            IPMIMessage resMessage = this.writeFRUDataCommand((byte)0, offset, buffer);
            int i_offset = offset[1];
            int i_offset_ls = offset[0] & 0xFF;
            i_offset <<= 8;
            i_offset &= 0xFF00;
            MessageCenter.getInstance().put(this, (Object)("Writing FRU data Offset : " + (i_offset += i_offset_ls)));
            if (resMessage.completionCode == 0) continue;
            MessageCenter.getInstance().put(this, (Object)"Failed to Write FRU data");
            return false;
        }
        if (!this.lockFRU()) {
            MessageCenter.getInstance().put(this, (Object)"Could not lock FRU data");
            return false;
        }
        return true;
    }

    public boolean writeFRU1(FRU fru) {
        byte[] fruData = fru.toRaw();
        byte[] raw = new byte[this.getFRUSize((byte)1)];
        System.arraycopy(fruData, 0, raw, 0, fruData.length);
        if (!this.unlockFRU()) {
            MessageCenter.getInstance().put(this, (Object)"Could not unlock FRU data");
            return false;
        }
        byte[] buffer = new byte[8];
        for (int i = 0; i < raw.length; i += 8) {
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            System.arraycopy(raw, i, buffer, 0, 8);
            IPMIMessage resMessage = this.writeFRUDataCommand((byte)1, offset, buffer);
            int i_offset = offset[1];
            int i_offset_ls = offset[0] & 0xFF;
            i_offset <<= 8;
            i_offset &= 0xFF00;
            MessageCenter.getInstance().put(this, (Object)("Writing FRU data Offset : " + (i_offset += i_offset_ls)));
            if (resMessage.completionCode == 0) continue;
            MessageCenter.getInstance().put(this, (Object)"Failed to Write FRU data");
            return false;
        }
        if (!this.lockFRU()) {
            MessageCenter.getInstance().put(this, (Object)"Could not lock FRU data");
            return false;
        }
        return true;
    }

    public boolean writeFRUN(FRU fru, int number) {
        byte[] raw = fru.toRaw();
        if (!this.unlockFRU()) {
            MessageCenter.getInstance().put(this, (Object)"Could not unlock FRU data");
            return false;
        }
        byte[] buffer = new byte[8];
        for (int i = 0; i < raw.length; i += 8) {
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            System.arraycopy(raw, i, buffer, 0, 8);
            IPMIMessage resMessage = this.writeFRUDataCommand((byte)number, offset, buffer);
            int i_offset = offset[1];
            int i_offset_ls = offset[0] & 0xFF;
            i_offset <<= 8;
            i_offset &= 0xFF00;
            MessageCenter.getInstance().put(this, (Object)("Writing FRU data Offset : " + (i_offset += i_offset_ls)));
            if (resMessage.completionCode == 0) continue;
            MessageCenter.getInstance().put(this, (Object)"Failed to Write FRU data");
            return false;
        }
        if (!this.lockFRU()) {
            MessageCenter.getInstance().put(this, (Object)"Could not lock FRU data");
            return false;
        }
        return true;
    }

    public boolean lockFRU() {
        IPMIMessage resMessage = this.lockFRUCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute lock FRU Command");
        return false;
    }

    public boolean unlockFRU() {
        IPMIMessage resMessage = this.unlockFRUCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute unlock FRU Command");
        return false;
    }

    public boolean fruWrite(String field, byte[] value) {
        FRUInfo fruInfo = this.getFRUData();
        if (field.equals("CT")) {
            fruInfo.fru.chassis.chassisType = value[0];
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("CP")) {
            fruInfo.fru.chassis.partNumber = value;
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("CS")) {
            fruInfo.fru.chassis.serialNumber = value;
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("BDT")) {
            fruInfo.fru.board.mfgDateTime = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BM")) {
            fruInfo.fru.board.boardManufacturer = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BPN")) {
            fruInfo.fru.board.boardProductName = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BS")) {
            fruInfo.fru.board.boardSerialNumber = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BP")) {
            fruInfo.fru.board.boardPartNumber = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("PM")) {
            fruInfo.fru.product.productManufacturerName = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PN")) {
            fruInfo.fru.product.productName = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PPM")) {
            fruInfo.fru.product.productPartModelNumber = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PV")) {
            fruInfo.fru.product.productVersion = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PS")) {
            fruInfo.fru.product.productSerialNumber = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PAT")) {
            fruInfo.fru.product.assetTag = value;
            fruInfo.fru.isProductExist = true;
        }
        this.unlockFRU();
        this.writeFRU(fruInfo.fru);
        this.lockFRU();
        return true;
    }

    public boolean fru1Write(String field, byte[] value) {
        FRUInfo fruInfo = this.getFRUData((byte)1);
        if (field.equals("CT")) {
            fruInfo.fru.chassis.chassisType = value[0];
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("CP")) {
            fruInfo.fru.chassis.partNumber = value;
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("CS")) {
            fruInfo.fru.chassis.serialNumber = value;
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("BDT")) {
            fruInfo.fru.board.mfgDateTime = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BM")) {
            fruInfo.fru.board.boardManufacturer = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BPN")) {
            fruInfo.fru.board.boardProductName = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BS")) {
            fruInfo.fru.board.boardSerialNumber = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BP")) {
            fruInfo.fru.board.boardPartNumber = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("BV")) {
            fruInfo.fru.board.customBoardInfo = value;
            fruInfo.fru.isBoardExist = true;
        } else if (field.equals("PM")) {
            fruInfo.fru.product.productManufacturerName = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PN")) {
            fruInfo.fru.product.productName = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PPM")) {
            fruInfo.fru.product.productPartModelNumber = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PV")) {
            fruInfo.fru.product.productVersion = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PS")) {
            fruInfo.fru.product.productSerialNumber = value;
            fruInfo.fru.isProductExist = true;
        } else if (field.equals("PAT")) {
            fruInfo.fru.product.assetTag = value;
            fruInfo.fru.isProductExist = true;
        }
        this.unlockFRU();
        this.writeFRU1(fruInfo.fru);
        this.lockFRU();
        return true;
    }

    public boolean frunWrite(int number, String field, byte[] value) {
        FRUInfo fruInfo = this.getFRUNData((byte)number);
        if (field.equals("CT")) {
            fruInfo.fru.chassis.chassisType = value[0];
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("CP")) {
            fruInfo.fru.chassis.partNumber = value;
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("CS")) {
            fruInfo.fru.chassis.serialNumber = value;
            fruInfo.fru.isChassisExist = true;
        } else if (field.equals("BDT")) {
            fruInfo.fru.board.mfgDateTime = value;
        } else if (field.equals("BM")) {
            fruInfo.fru.board.boardManufacturer = value;
        } else if (field.equals("BPN")) {
            fruInfo.fru.board.boardProductName = value;
        } else if (field.equals("BS")) {
            fruInfo.fru.board.boardSerialNumber = value;
        } else if (field.equals("BP")) {
            fruInfo.fru.board.boardPartNumber = value;
        } else if (field.equals("BV")) {
            byte[] version = new byte[value.length + 1];
            version[0] = (byte)(192 + value.length);
            System.arraycopy(value, 0, version, 1, value.length);
            fruInfo.fru.board.customBoardInfo = version;
        } else if (field.equals("PM")) {
            fruInfo.fru.product.productManufacturerName = value;
        } else if (field.equals("PN")) {
            fruInfo.fru.product.productName = value;
        } else if (field.equals("PPM")) {
            fruInfo.fru.product.productPartModelNumber = value;
        } else if (field.equals("PV")) {
            fruInfo.fru.product.productVersion = value;
        } else if (field.equals("PS")) {
            fruInfo.fru.product.productSerialNumber = value;
        } else if (field.equals("PAT")) {
            fruInfo.fru.product.assetTag = value;
        }
        this.unlockFRU();
        this.writeFRUN(fruInfo.fru, number);
        this.lockFRU();
        return true;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.2.2.2");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiFRUCommand.setIPMIInterface(rmcp);
        int size = ipmiFRUCommand.getFRUSize();
        FRUInfo fruInfo = ipmiFRUCommand.getFRUData();
        if (fruInfo != null) {
            System.out.println(fruInfo.toReadableString());
        }
        sessionController.closeSession();
    }
}

