/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.HealthCPU;
import com.supermicro.ipmi.HealthComponent;
import com.supermicro.ipmi.HealthDIMM;
import com.supermicro.ipmi.HealthFan;
import com.supermicro.ipmi.HealthPS;
import com.supermicro.ipmi.HealthPowerState;
import com.supermicro.ipmi.HealthServer;
import com.supermicro.ipmi.HealthState;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;

public class IPMIHealthCheckCommand
extends IPMICommand {
    private Progress progress;
    private static final Pattern CPU_PATTERN = Pattern.compile("CPU([0-9])? (Temp|Voltage|Vcore|VSA)");
    private static final Pattern VCPU_PATTERN = Pattern.compile("Vcpu((?s).*( Temp| Voltage| Vcore| VSA))*");
    private static final Pattern VCPUX_PATTERN = Pattern.compile("V(?s).*cpu[0-9]((?s).*( Temp| Voltage| Vcore| VSA)?)*");
    private static final Pattern MEM_PATTERN = Pattern.compile("(?s).*mem(?s).*( Temp| Voltage)?");
    private static final Pattern MEM_XXXX_PATTERN = Pattern.compile("(?s).*mem( )?[a-zA-Z][a-zA-Z][a-zA-Z]?[a-zA-Z]?(?s).*( Temp| Voltage)?");
    private static final Pattern CPUX_DIMM_PATTERN = Pattern.compile("CPU[0-9]( )?DIMM");
    private static final Pattern PXMX_DIMMXX_PATTERN = Pattern.compile("P[0-9]M[0-9] DIMM[a-zA-Z][a-zA-Z]( Tmp| Temp)?");
    private static final Pattern PXMXxx_X_PATTERN = Pattern.compile("P[0-9]M[0-9][a-zA-Z][a-zA-Z] (?s).*( Tmp| Temp)?");
    private static final Pattern X_PXMXxx_X_PATTERN = Pattern.compile("(?s).*P[0-9]M[0-9][a-zA-Z][a-zA-Z](?s).*");
    private static final Pattern PX_DIMMXX_PATTERN = Pattern.compile("P[0-9]-DIMM[a-zA-Z][a-zA-Z]( Temp| TEMP| Voltage)?");
    private static final Pattern PX_DIMMXx_PATTERN = Pattern.compile("P[0-9]-DIMM[a-zA-Z][0-9]( Temp| TEMP| Voltage)?");
    private static final Pattern PX_DIMMxX_PATTERN = Pattern.compile("P[0-9][-|_]DIMM[0-9][a-zA-Z]( Temp|_TEMP| Voltage)?");
    private static final Pattern DIMM_PATTERN = Pattern.compile("(?s).*DIMM( Temp| Voltage)?");
    private static final Pattern DIMMX_PATTERN = Pattern.compile("(?s).*DIMM([a-zA-Z][0-9]|[0-9][a-zA-Z])(?s).*( Temp| Voltage)?");
    private static final Pattern DIMM_XXXX_PATTERN = Pattern.compile("(?s).*DIMM( )?[a-zA-Z][a-zA-Z][a-zA-Z]?[a-zA-Z]?(?s).*( Temp| Voltage)?");
    private static final Pattern FAN_PATTERN = Pattern.compile("(FAN|Fan)( )?([0-9a-zA-Z]){0,2}");
    private static final Pattern PS_PATTERN = Pattern.compile("PS([0-9])? (?s).*|Power Supply");
    private HealthServer healthServer;
    private Date checkTime;
    private boolean checkPreInitTime;
    private SimpleDateFormat selDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public HealthServer getHealthServer() {
        return this.healthServer;
    }

    public IPMIHealthCheckCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.healthServer = new HealthServer();
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    private void setValue(int value) {
        if (this.progress != null) {
            this.progress.setValue(value);
        }
    }

    private void message(String message) {
        if (this.progress != null) {
            this.progress.message(message);
        }
    }

    private void setLeft(long value) {
        if (this.progress != null) {
            this.progress.left(value);
        }
    }

    public void healthCheck() {
        this.healthCheck(null, false);
    }

    public Date getCheckTime() {
        return this.checkTime;
    }

    public boolean isCheckPreInitTime() {
        return this.checkPreInitTime;
    }

    private int checkHealthState(String eventType) {
        if (eventType.startsWith("Assertion:")) {
            return 1;
        }
        return 0;
    }

    private int checkSensorValue(byte reading, SDRRecord item) {
        if (item.getSensorType() == -64) {
            if (reading == 0 || reading == 1 || reading == 2) {
                return 0;
            }
            if (reading == 4) {
                return 1;
            }
            return 2;
        }
        if (reading == 0) {
            return 2;
        }
        if (reading == -1) {
            return 2;
        }
        double value = item.getSensorType() == 1 ? item.calSensorReading(reading) : item.calSensorReading(reading & 0xFF);
        double hi = item.getHiLimit();
        double low = item.getLowLimit();
        if (hi == 0.0 && low == 0.0) {
            return 0;
        }
        if (value < hi && value > low) {
            return 0;
        }
        return 1;
    }

    private void checkComponentExist() {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.getIPMIInterface());
        byte[] guid = new IPMIMessagingCommand(this.getIPMIInterface()).getSystemGUID();
        boolean isAten = false;
        if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isAST2600NonRoTGUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH13ROTMAC12GUID(guid) || IPMIMessagingCommand.isH13ROTMAC34GUID(guid) || IPMIMessagingCommand.isNuvotonGUID(guid) || IPMIMessagingCommand.isX11RotGUID(guid) || IPMIMessagingCommand.isX12GUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTHW1GUID(guid) || IPMIMessagingCommand.isX12RoTHW2GUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isB12AST2600GUID(guid) || IPMIMessagingCommand.isB13AST2600RoTGUID(guid) || IPMIMessagingCommand.isB14AST2600RoT20GUID(guid) || IPMIMessagingCommand.isX12DGOGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isH13GUID(guid) || IPMIMessagingCommand.isX12AST2600NonRoT(guid) || IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isB3SD1GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid) || IPMIMessagingCommand.isB4SA1GUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid) || IPMIMessagingCommand.isX13ROTGUID(guid) || IPMIMessagingCommand.isX13ROTMAC1GUID(guid) || IPMIMessagingCommand.isX13ROTHW1GUID(guid) || IPMIMessagingCommand.isX13ROT8WAYSGUID(guid) || IPMIMessagingCommand.isX13AST2600NonRoTGUID(guid) || IPMIMessagingCommand.isX13AST2600NonRoTHW1GUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid) || IPMIMessagingCommand.isX12DGUGUID(guid) || IPMIMessagingCommand.isX13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextHW1GUID(guid) || IPMIMessagingCommand.isH13AST2600HW1Rot20GUID(guid) || IPMIMessagingCommand.isH13AST2600NonRoTGUID(guid) || IPMIMessagingCommand.isH14AST2600ROT20HW2GUID(guid) || IPMIMessagingCommand.isX13AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isX13AST2600RoTSBBGUID(guid) || IPMIMessagingCommand.isG1AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isJBOF2600GUID(guid) || IPMIMessagingCommand.isX14AST2600ROT20HW1GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20HW2GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20GD3GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20DCMHSGUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20MAC1GUID(guid)) {
            isAten = true;
        }
        boolean isPowerOn = false;
        for (HealthComponent healthComponent : this.healthServer.getHealthComponentList()) {
            if (!(healthComponent instanceof HealthPowerState) || healthComponent.getState() != 5) continue;
            isPowerOn = true;
            break;
        }
        for (HealthComponent healthComponent : this.healthServer.getHealthComponentList()) {
            if (healthComponent instanceof HealthPowerState) continue;
            boolean exist = false;
            boolean failNa = false;
            boolean fail = false;
            String na = "N/A";
            block21: for (SDRRecord sdrRecord : healthComponent.getSdrRecordList()) {
                String reading = "";
                String lowLimit = "";
                String highLimit = "";
                int status = 0;
                if (sdrRecord.getSensorType() == 1 || sdrRecord.getSensorType() == 2 || sdrRecord.getSensorType() == 4 || sdrRecord.getSensorType() == 9 || sdrRecord.getSensorType() == 11 || sdrRecord.getSensorType() == -64) {
                    int value = 0;
                    value = ipmiSDRCommand.getSensorReading(sdrRecord.getSensorNumber(), sdrRecord.getSensorType());
                    switch (sdrRecord.getSensorType()) {
                        case 1: {
                            reading = value == -128 ? na : sdrRecord.calSensorReading(value & 0xFF) + "";
                            highLimit = sdrRecord.getHiLimit() == 0.0 ? na : "" + sdrRecord.getHiLimit();
                            lowLimit = sdrRecord.getLowLimit() == 0.0 ? na : "" + sdrRecord.getLowLimit();
                            break;
                        }
                        case 2: {
                            reading = value == -1 || value == 0 ? na : sdrRecord.doubleToString(sdrRecord.calSensorReading(value & 0xFF));
                            highLimit = sdrRecord.doubleToString(sdrRecord.getHiLimit());
                            lowLimit = sdrRecord.doubleToString(sdrRecord.getLowLimit());
                            break;
                        }
                        case 4: {
                            reading = value == -1 || value == 0 ? na : sdrRecord.calSensorReading(value & 0xFF) + "";
                            highLimit = sdrRecord.getHiLimit() + " ";
                            lowLimit = sdrRecord.getLowLimit() + " ";
                            break;
                        }
                        case 9: 
                        case 11: {
                            reading = value == -1 ? na : (int)sdrRecord.calSensorReading(value & 0xFF) + " " + sdrRecord.getUnit();
                            highLimit = sdrRecord.getHiLimit() == 0.0 ? na : "" + sdrRecord.getHiLimit();
                            lowLimit = sdrRecord.getLowLimit() == 0.0 ? na : "" + sdrRecord.getLowLimit();
                            break;
                        }
                        case -64: {
                            byte[] values = ipmiSDRCommand.getFullSensorValue(sdrRecord.getSensorNumber());
                            reading = na;
                            if (values == null) continue block21;
                            if ((values[1] & 0x20) > 0) {
                                value = 7;
                            }
                            if (values != null) {
                                value = values[2];
                                switch (value) {
                                    case 0: {
                                        reading = "low";
                                        break;
                                    }
                                    case 1: {
                                        reading = "medium";
                                        break;
                                    }
                                    case 2: {
                                        reading = "high";
                                        break;
                                    }
                                    case 4: {
                                        reading = "overhead";
                                        break;
                                    }
                                    default: {
                                        reading = na;
                                    }
                                }
                            }
                            highLimit = sdrRecord.getHiLimit() == 0.0 ? na : "" + sdrRecord.getHiLimit();
                            lowLimit = sdrRecord.getLowLimit() == 0.0 ? na : "" + sdrRecord.getLowLimit();
                        }
                    }
                    status = this.checkSensorValue((byte)value, sdrRecord);
                } else if (sdrRecord.getSensorType() == 5 || sdrRecord.getSensorType() == 8 || sdrRecord.getSensorType() == 21 || sdrRecord.getSensorType() == 7) {
                    lowLimit = na;
                    highLimit = na;
                    byte[] value = ipmiSDRCommand.getFullSensorValue(sdrRecord.getSensorNumber());
                    if (value != null) {
                        reading = ByteUtility.bytesToHex(value);
                        status = 0;
                        status = value[2] == 0 ? 0 : 1;
                        if (sdrRecord.getSensorType() == 8 && value[2] == 1) {
                            status = 0;
                        }
                        if (sdrRecord.getSensorType() == 8 && guid != null && IPMIMessagingCommand.isOSAGUID(guid)) {
                            status = value[2] == 2 ? 0 : (value[2] == 0 ? 1 : 2);
                        }
                    } else {
                        status = 2;
                        reading = na;
                    }
                } else if (sdrRecord.getSensorType() == -16 || sdrRecord.getSensorType() == -15 || sdrRecord.getSensorType() == -14 || sdrRecord.getSensorType() == -13) {
                    byte value = 0;
                    value = ipmiSDRCommand.getSensorReading(sdrRecord.getSensorNumber());
                    status = 0;
                    switch (sdrRecord.getSensorType()) {
                        case -16: {
                            if (value == 0) {
                                reading = "OK";
                                status = 0;
                                break;
                            }
                            if (value == 1) {
                                reading = "Error";
                                status = 1;
                                break;
                            }
                            reading = ByteUtility.byteToHex(value);
                            status = 2;
                            break;
                        }
                        case -15: {
                            if (value == 0) {
                                reading = "Not Presence";
                                status = 2;
                                break;
                            }
                            if (value == 1) {
                                reading = "Presence";
                                status = 0;
                                break;
                            }
                            reading = ByteUtility.byteToHex(value);
                            status = 2;
                            break;
                        }
                        case -14: {
                            if (value == 0) {
                                reading = "OK";
                                status = 0;
                                break;
                            }
                            if (value == 1) {
                                reading = "Over Temp";
                                status = 1;
                                break;
                            }
                            reading = ByteUtility.byteToHex(value);
                            status = 2;
                            break;
                        }
                        case -13: {
                            if (value == 0) {
                                reading = "OK";
                                status = 0;
                                break;
                            }
                            if (value == 1) {
                                reading = "Warp around";
                                status = 2;
                                break;
                            }
                            reading = ByteUtility.byteToHex(value);
                            status = 2;
                            break;
                        }
                        default: {
                            reading = ByteUtility.byteToHex(value);
                            break;
                        }
                    }
                } else if (sdrRecord.getSensorType() == 13) {
                    byte[] value = ipmiSDRCommand.getFullSensorValue(sdrRecord.getSensorNumber());
                    status = 1;
                    reading = "";
                    if (value == null || value.length < 4) {
                        status = 2;
                        reading = "No reading";
                    } else if ((byte)(value[2] & 1) == 1) {
                        reading = "Drive Presence";
                        status = 1;
                    } else if ((byte)(value[2] & 2) == 2) {
                        reading = "Drive Fault";
                    } else if ((byte)(value[2] & 4) == 4) {
                        reading = "Predictive Failure";
                    } else if ((byte)(value[2] & 8) == 8) {
                        reading = "Hot Spare";
                    } else if ((byte)(value[2] & 0x10) == 16) {
                        reading = "Consistency Check/Parity Check in progress";
                        status = 1;
                    } else if ((byte)(value[2] & 0x20) == 32) {
                        reading = "In Critical Array";
                    } else if ((byte)(value[2] & 0x40) == 64) {
                        reading = "In Failed Array";
                    } else if ((byte)(value[2] & 0x80) == -128) {
                        reading = "Rebuild/Remap in progress";
                    } else if ((byte)(value[3] & 1) == 1) {
                        reading = "Rebuild/Remap Aborted (was not completed normally)";
                    } else if (value[2] == 0 && value[3] == 0) {
                        reading = "Not Present";
                        status = 2;
                    } else {
                        reading = "Unknown";
                    }
                }
                if (reading.equalsIgnoreCase(na)) {
                    exist = false;
                    if (!isAten || !isPowerOn || !sdrRecord.isIsValueAvailable() || highLimit.equalsIgnoreCase(na) && lowLimit.equalsIgnoreCase(na)) continue;
                    failNa = true;
                    continue;
                }
                exist = true;
                if (status != 1) break;
                fail = true;
                break;
            }
            if (!exist) {
                if (failNa) {
                    healthComponent.setState(4);
                } else {
                    healthComponent.setState(3);
                }
            }
            if (!fail) continue;
            healthComponent.setState(1);
        }
    }

    public void healthCheck(Date startTime, Date endTime, boolean checkPreInitTime) {
        ProgressThread progressThread = new ProgressThread();
        progressThread.setSpeed(3L);
        progressThread.setToProgress(100);
        this.setLeft(1000L);
        this.message("Check components state ...");
        progressThread.start();
        for (HealthComponent healthComponent : this.healthServer.getHealthComponentList()) {
            healthComponent.setState(0);
            if (!(healthComponent instanceof HealthPowerState)) continue;
            try {
                if (new IPMIChassisCommand(this.getIPMIInterface()).isPowerOn()) {
                    healthComponent.setState(5);
                    continue;
                }
                healthComponent.setState(6);
            }
            catch (IPMIException e) {
                healthComponent.setState(7);
            }
        }
        for (HealthComponent healthComponent : this.healthServer.getHealthComponentList()) {
            for (SELRecord selRecord : healthComponent.getSelRecordList()) {
                long timeStamp = ByteUtility.fourBytesToLongByLSBFirst(selRecord.getTimeStamp());
                if (timeStamp < 0x20000000L && !checkPreInitTime) continue;
                String eventType = GlobalDefine.getEventType((byte)(selRecord.getEventDir() | selRecord.getEventType()), selRecord.getSensorType(), selRecord.getEventData1(), selRecord.getEventData2(), selRecord.getEventData3());
                boolean checkHealthState = false;
                String selDate = ByteUtility.fourByteToDateFormat2(selRecord.getTimeStamp());
                if (timeStamp < 0x20000000L) {
                    checkHealthState = true;
                } else {
                    try {
                        Date eventTime = this.selDateFormat.parse(selDate);
                        if (eventTime.after(startTime) && eventTime.before(endTime)) {
                            checkHealthState = true;
                        }
                    }
                    catch (ParseException eventTime) {
                        // empty catch block
                    }
                }
                if (!checkHealthState) continue;
                int state = this.checkHealthState(eventType);
                healthComponent.setState(state);
                healthComponent.setMsg(eventType + " (" + selDate + ")");
            }
        }
        Calendar currentTime = Calendar.getInstance();
        currentTime.add(12, -1);
        if (endTime.after(currentTime.getTime())) {
            this.checkComponentExist();
        }
        while (!progressThread.isDone) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void healthCheck(Date checkTime, boolean checkPreInitTime) {
        HealthDIMM healthDIMM;
        int memIndex;
        Object name;
        Object sensorName;
        this.checkPreInitTime = checkPreInitTime;
        if (checkTime == null) {
            checkTime = new Date();
            checkTime.setTime(checkTime.getTime() - 18000000L);
        }
        this.checkTime = checkTime;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.getIPMIInterface());
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(this.getIPMIInterface());
        ArrayList sdrList = null;
        ProgressThread progressThread = new ProgressThread();
        progressThread.setSpeed(100L);
        progressThread.setToProgress(0);
        this.setLeft(5000L);
        this.message("Getting SDR records ...");
        progressThread.start();
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        if (sdrInfo == null) {
            progressThread.setSpeed(0L);
            progressThread.setToProgress(100);
            return;
        }
        try {
            Date start = new Date();
            ipmiSDRCommand.getSDRsEx(1);
            long spendTime = (new Date().getTime() - start.getTime()) * (long)sdrInfo.getRecordCount() / 50L;
            progressThread.setSpeed(spendTime);
            progressThread.setToProgress(50);
            sdrList = ipmiSDRCommand.getSDRsEx(sdrInfo.getRecordCount());
        }
        catch (Exception e) {
            progressThread.setSpeed(0L);
            progressThread.setToProgress(100);
            return;
        }
        progressThread.setSpeed(10L);
        progressThread.setToProgress(55);
        this.setLeft(2500L);
        this.message("Getting SEL records ...");
        SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
        if (selInfo == null) {
            progressThread.setSpeed(0L);
            progressThread.setToProgress(100);
            return;
        }
        Date start = new Date();
        ipmiSELCommand.getSELEntries(1);
        long spendTime = (new Date().getTime() - start.getTime()) * (long)selInfo.getLogEntries() / 25L;
        progressThread.setSpeed(spendTime);
        progressThread.setToProgress(80);
        ArrayList selList = ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
        progressThread.setSpeed(5L);
        progressThread.setToProgress(85);
        this.setLeft(1500L);
        this.message("Parsing SDR records ...");
        HashMap<Object, HealthComponent> nameToHealthComponent = new HashMap<Object, HealthComponent>();
        HealthPowerState healthPowerState = new HealthPowerState();
        for (SDRRecord sdrRecord : sdrList) {
            HealthPS healthPS;
            sensorName = sdrRecord.getSensorName();
            if (CPU_PATTERN.matcher((CharSequence)sensorName).matches()) {
                HealthCPU healthCPU;
                int length;
                int cpuIndex = ((String)sensorName).toUpperCase().indexOf("CPU");
                if (cpuIndex + (length = 4) >= ((String)sensorName).length()) {
                    length = 3;
                }
                if (nameToHealthComponent.get(name = ((String)sensorName).substring(cpuIndex, cpuIndex + length).toUpperCase().trim()) == null) {
                    healthCPU = new HealthCPU();
                    nameToHealthComponent.put(name, healthCPU);
                } else {
                    healthCPU = (HealthCPU)nameToHealthComponent.get(name);
                }
                healthCPU.setName((String)name);
                healthCPU.addSdrRecord(sdrRecord);
            }
            if (PXMX_DIMMXX_PATTERN.matcher((CharSequence)sensorName).matches() || PXMXxx_X_PATTERN.matcher((CharSequence)sensorName).matches()) {
                if (PXMX_DIMMXX_PATTERN.matcher((CharSequence)sensorName).matches()) {
                    int pIndex = ((String)sensorName).toUpperCase().indexOf("P");
                    memIndex = ((String)sensorName).toUpperCase().indexOf("DIMM") + 4;
                    name = ((String)sensorName).substring(pIndex, pIndex + 4) + ((String)sensorName).substring(memIndex, memIndex + 2);
                } else {
                    memIndex = ((String)sensorName).toUpperCase().indexOf("P");
                    name = ((String)sensorName).substring(memIndex, memIndex + 6).toUpperCase();
                }
                if (nameToHealthComponent.get(name) == null) {
                    healthDIMM = new HealthDIMM();
                    nameToHealthComponent.put(name, healthDIMM);
                } else {
                    healthDIMM = (HealthDIMM)nameToHealthComponent.get(name);
                }
                healthDIMM.setName((String)name);
                healthDIMM.addSdrRecord(sdrRecord);
            } else if (!X_PXMXxx_X_PATTERN.matcher((CharSequence)sensorName).matches()) {
                if (PX_DIMMXX_PATTERN.matcher((CharSequence)sensorName).matches() || PX_DIMMXx_PATTERN.matcher((CharSequence)sensorName).matches() || PX_DIMMxX_PATTERN.matcher((CharSequence)sensorName).matches()) {
                    memIndex = ((String)sensorName).toUpperCase().indexOf("DIMM") - 3;
                    name = ((String)sensorName).substring(memIndex, memIndex + 9).toUpperCase();
                    if (nameToHealthComponent.get(name) == null) {
                        healthDIMM = new HealthDIMM();
                        nameToHealthComponent.put(name, healthDIMM);
                    } else {
                        healthDIMM = (HealthDIMM)nameToHealthComponent.get(name);
                    }
                    healthDIMM.setName((String)name);
                    healthDIMM.addSdrRecord(sdrRecord);
                } else if (DIMMX_PATTERN.matcher((CharSequence)sensorName).matches()) {
                    memIndex = ((String)sensorName).toUpperCase().indexOf("DIMM");
                    name = ((String)sensorName).substring(memIndex, memIndex + 6).toUpperCase();
                    if (nameToHealthComponent.get(name) == null) {
                        healthDIMM = new HealthDIMM();
                        nameToHealthComponent.put(name, healthDIMM);
                    } else {
                        healthDIMM = (HealthDIMM)nameToHealthComponent.get(name);
                    }
                    healthDIMM.setName((String)name);
                    healthDIMM.addSdrRecord(sdrRecord);
                }
            }
            if (FAN_PATTERN.matcher((CharSequence)sensorName).matches()) {
                HealthFan healthFan;
                name = sensorName;
                if (nameToHealthComponent.get(name) == null) {
                    healthFan = new HealthFan();
                    nameToHealthComponent.put(name, healthFan);
                } else {
                    healthFan = (HealthFan)nameToHealthComponent.get(name);
                }
                healthFan.setName((String)name);
                healthFan.addSdrRecord(sdrRecord);
            }
            if (!PS_PATTERN.matcher((CharSequence)sensorName).matches()) continue;
            name = sensorName;
            if (nameToHealthComponent.get(name) == null) {
                healthPS = new HealthPS();
                nameToHealthComponent.put(name, healthPS);
            } else {
                healthPS = (HealthPS)nameToHealthComponent.get(name);
            }
            healthPS.setName((String)name);
            healthPS.addSdrRecord(sdrRecord);
        }
        nameToHealthComponent.put("Power Supply State", healthPowerState);
        healthPowerState.setName("Power Supply State");
        for (SDRRecord sdrRecord : sdrList) {
            sensorName = sdrRecord.getSensorName();
            boolean added = false;
            if (VCPUX_PATTERN.matcher((CharSequence)sensorName).matches() || VCPU_PATTERN.matcher((CharSequence)sensorName).matches()) {
                // empty if block
            }
            if (!PXMX_DIMMXX_PATTERN.matcher((CharSequence)sensorName).matches() && !X_PXMXxx_X_PATTERN.matcher((CharSequence)sensorName).matches()) {
                if (DIMM_PATTERN.matcher((CharSequence)sensorName).matches()) {
                    added = false;
                    name = "DIMM";
                    for (HealthComponent healthComponent : nameToHealthComponent.values()) {
                        if (!(healthComponent instanceof HealthDIMM)) continue;
                        if (CPUX_DIMM_PATTERN.matcher((CharSequence)sensorName).matches()) {
                            added = true;
                            continue;
                        }
                        if (PX_DIMMXx_PATTERN.matcher(healthComponent.getName()).matches() || PX_DIMMxX_PATTERN.matcher(healthComponent.getName()).matches()) {
                            // empty if block
                        }
                        if (!healthComponent.getName().contains((CharSequence)name)) continue;
                        added = true;
                    }
                    if (added) {
                        added = false;
                        continue;
                    }
                    if (nameToHealthComponent.get(sensorName) == null) {
                        healthDIMM = new HealthDIMM();
                        nameToHealthComponent.put(name, healthDIMM);
                    } else {
                        healthDIMM = (HealthDIMM)nameToHealthComponent.get(sensorName);
                    }
                    healthDIMM.setName((String)name);
                    healthDIMM.addSdrRecord(sdrRecord);
                } else if (DIMM_XXXX_PATTERN.matcher((CharSequence)sensorName).matches()) {
                    // empty if block
                }
            }
            if (!MEM_PATTERN.matcher((CharSequence)sensorName).matches()) continue;
            added = false;
            memIndex = ((String)sensorName).toUpperCase().indexOf("MEM");
            if (MEM_XXXX_PATTERN.matcher((CharSequence)sensorName).matches()) {
                int end = 5;
                if (memIndex + 3 + end + 1 > ((String)sensorName).length()) {
                    end = ((String)sensorName).length() - memIndex - 3;
                }
                for (int i = 0; i < end; ++i) {
                    String memLocation = ((String)sensorName).substring(memIndex + 3 + i, memIndex + 3 + i + 1);
                    if (memLocation.trim().isEmpty()) continue;
                    name = "DIMM" + memLocation;
                    for (HealthComponent healthComponent : nameToHealthComponent.values()) {
                        if (!(healthComponent instanceof HealthDIMM) || !healthComponent.getName().contains((CharSequence)name)) continue;
                        added = true;
                    }
                }
            }
            if (added) {
                added = false;
                continue;
            }
            if (nameToHealthComponent.get(sensorName) == null) {
                healthDIMM = new HealthDIMM();
                nameToHealthComponent.put(sensorName, healthDIMM);
            } else {
                healthDIMM = (HealthDIMM)nameToHealthComponent.get(sensorName);
            }
            healthDIMM.setName((String)sensorName);
            healthDIMM.addSdrRecord(sdrRecord);
        }
        progressThread.setSpeed(3L);
        progressThread.setToProgress(95);
        this.setLeft(750L);
        this.message("Parsing SEL records ...");
        for (SELRecord selRecord : selList) {
            sensorName = (String)SDRRecord.sensorNumberToSensorName.get("" + (selRecord.getSensorNumber() & 0xFF));
            String eventType = GlobalDefine.getEventType((byte)(selRecord.getEventDir() | selRecord.getEventType()), selRecord.getSensorType(), selRecord.getEventData1(), selRecord.getEventData2(), selRecord.getEventData3());
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("    (" + selRecord.getRecordID() + ")(" + (String)sensorName + ")(" + eventType + ")(" + ByteUtility.fourByteToDateFormat2(selRecord.getTimeStamp()) + ")");
            }
            String cpuLocation = "";
            String memLocation = "";
            if (eventType.startsWith("Assertion: Memory|")) {
                sensorName = "Memory";
                Object productID = new IPMIOEMCommand(this.getIPMIInterface()).getProductID();
                if (productID == null) {
                    productID = new byte[2];
                }
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                    System.out.println(GlobalDefine.memoryECCLocation(selRecord.getEventData2(), selRecord.getEventData3(), (byte[])productID));
                }
                switch (GlobalDefine.checkChipSetType((byte[])productID)) {
                    case 0: {
                        memLocation = String.format("%2X", selRecord.getEventData2());
                        cpuLocation = String.format("P%x", (selRecord.getEventData3() & 3) + 1);
                        break;
                    }
                    case 1: {
                        byte bank_high = (byte)((selRecord.getEventData2() >> 4) + 64 + (selRecord.getEventData3() & 3) * 4);
                        byte bank_low = (byte)((selRecord.getEventData2() & 0xF) + 39);
                        memLocation = String.format("%c%c", bank_high, bank_low);
                        cpuLocation = String.format("P%x", (selRecord.getEventData3() & 3) + 1);
                        break;
                    }
                    case 2: {
                        byte bank_high = (byte)((selRecord.getEventData2() >> 4) + 64 + (selRecord.getEventData3() & 3) * 3);
                        byte bank_low = (byte)((selRecord.getEventData2() & 0xF) + 39);
                        memLocation = String.format("%c%c", bank_high, bank_low);
                        cpuLocation = String.format("P%x", (selRecord.getEventData3() & 3) + 1);
                        break;
                    }
                    case 3: {
                        int cpu = (selRecord.getEventData3() & 0xF) + 1;
                        int module = (selRecord.getEventData2() & 0xFF) >> 4 > 4 ? 2 : 1;
                        int channel = (selRecord.getEventData2() & 0xF) - 9;
                        byte value = (byte)((selRecord.getEventData2() & 0xFF) >> 4);
                        byte number = value > 4 ? (byte)(60 + value) : (byte)(64 + value);
                        memLocation = String.format("%c%d", number, channel);
                        cpuLocation = String.format("P%dM%d", cpu, module);
                        break;
                    }
                    case 4: {
                        byte bank_high = (byte)((selRecord.getEventData2() >> 4) + 64);
                        byte bank_low = (byte)((selRecord.getEventData2() & 0xF) + 39);
                        memLocation = String.format("%c%c", bank_high, bank_low);
                        cpuLocation = String.format("P%x", (selRecord.getEventData3() & 3) + 1);
                    }
                }
            }
            if (sensorName == null) continue;
            for (HealthComponent healthComponent : nameToHealthComponent.values()) {
                for (SDRRecord sdrRecord : healthComponent.getSdrRecordList()) {
                    if (eventType.startsWith("Assertion: Memory|") && sdrRecord.getSensorName().contains("DIMM") && sdrRecord.getSensorName().contains(cpuLocation) && sdrRecord.getSensorName().contains(memLocation)) {
                        healthComponent.addSelRecord(selRecord);
                    }
                    if (!sdrRecord.getSensorName().equals(sensorName)) continue;
                    healthComponent.addSelRecord(selRecord);
                }
            }
        }
        for (HealthComponent healthComponent : nameToHealthComponent.values()) {
            healthComponent.setState(0);
            for (SELRecord selRecord : healthComponent.getSelRecordList()) {
                long timeStamp = ByteUtility.fourBytesToLongByLSBFirst(selRecord.getTimeStamp());
                if (timeStamp < 0x20000000L && !checkPreInitTime) continue;
                String eventType = GlobalDefine.getEventType((byte)(selRecord.getEventDir() | selRecord.getEventType()), selRecord.getSensorType(), selRecord.getEventData1(), selRecord.getEventData2(), selRecord.getEventData3());
                boolean checkHealthState = false;
                String selDate = ByteUtility.fourByteToDateFormat2(selRecord.getTimeStamp());
                if (timeStamp < 0x20000000L) {
                    checkHealthState = true;
                } else {
                    try {
                        if (this.selDateFormat.parse(selDate).after(checkTime)) {
                            checkHealthState = true;
                        }
                    }
                    catch (ParseException sdrRecord) {
                        // empty catch block
                    }
                }
                if (!checkHealthState) continue;
                int state = this.checkHealthState(eventType);
                healthComponent.setState(state);
                healthComponent.setMsg(eventType + " (" + selDate + ")");
            }
        }
        progressThread.setSpeed(3L);
        progressThread.setToProgress(100);
        this.setLeft(250L);
        this.message("Saving health components ...");
        this.healthServer.getHealthComponentList().clear();
        for (HealthComponent healthComponent : nameToHealthComponent.values()) {
            this.healthServer.addHealthComponent(healthComponent);
        }
        try {
            if (new IPMIChassisCommand(this.getIPMIInterface()).isPowerOn()) {
                healthPowerState.setState(5);
            } else {
                healthPowerState.setState(6);
            }
        }
        catch (IPMIException e) {
            healthPowerState.setState(7);
        }
        this.checkComponentExist();
        Collections.sort(this.healthServer.getHealthComponentList(), new Comparator<HealthComponent>(){

            @Override
            public int compare(HealthComponent o1, HealthComponent o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.setLeft(0L);
        this.message("Done");
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            byte[] guid = new IPMIMessagingCommand(this.getIPMIInterface()).getSystemGUID();
            if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isAST2600NonRoTGUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH13ROTMAC12GUID(guid) || IPMIMessagingCommand.isH13ROTMAC34GUID(guid) || IPMIMessagingCommand.isNuvotonGUID(guid) || IPMIMessagingCommand.isX11RotGUID(guid) || IPMIMessagingCommand.isX12GUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTHW1GUID(guid) || IPMIMessagingCommand.isX12RoTHW2GUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isJBOF2500GUID(guid) || IPMIMessagingCommand.isJBOF2600GUID(guid) || IPMIMessagingCommand.isJBOD2500GUID(guid) || IPMIMessagingCommand.isB12AST2600GUID(guid) || IPMIMessagingCommand.isX12DGOGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isB12AST2600MAC1GUID(guid) || IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid) || IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isH13GUID(guid) || IPMIMessagingCommand.isX12AST2600NonRoT(guid) || IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isB3SD1GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid) || IPMIMessagingCommand.isB4SA1GUID(guid) || IPMIMessagingCommand.isX12DGQGUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid) || IPMIMessagingCommand.isX13ROTGUID(guid) || IPMIMessagingCommand.isX13ROTHW1GUID(guid) || IPMIMessagingCommand.isX13ROTMAC1GUID(guid) || IPMIMessagingCommand.isX13ROT8WAYSGUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid) || IPMIMessagingCommand.isB13AST2600RoTGUID(guid) || IPMIMessagingCommand.isB14AST2600RoT20GUID(guid) || IPMIMessagingCommand.isX12DGUGUID(guid) || IPMIMessagingCommand.isX13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextHW1GUID(guid) || IPMIMessagingCommand.isH13AST2600HW1Rot20GUID(guid) || IPMIMessagingCommand.isH13AST2600NonRoTGUID(guid) || IPMIMessagingCommand.isH14AST2600ROT20HW2GUID(guid) || IPMIMessagingCommand.isX13AST2600NonRoTGUID(guid) || IPMIMessagingCommand.isX13AST2600NonRoTHW1GUID(guid) || IPMIMessagingCommand.isX13AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isX13AST2600RoTSBBGUID(guid) || IPMIMessagingCommand.isG1AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isX14AST2600ROT20HW1GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20HW2GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20GD3GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20DCMHSGUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20MAC1GUID(guid)) {
                System.out.println("This is Aten");
            } else {
                System.out.println("This is not Aten");
            }
            for (HealthComponent healthComponent : this.healthServer.getHealthComponentList()) {
                System.out.println(healthComponent.getName());
                System.out.println("  SDR:");
                for (SDRRecord sdrRecord : healthComponent.getSdrRecordList()) {
                    System.out.println("    " + sdrRecord.getSensorName() + " (valueAvailabe:" + sdrRecord.isIsValueAvailable() + ",reading:" + ipmiSDRCommand.getSensorReading(sdrRecord.getSensorNumber()) + ",highLimit:" + sdrRecord.getHiLimit() + ",lowLimit:" + sdrRecord.getLowLimit() + ")");
                }
                System.out.println("  SEL:");
                for (SELRecord selRecord : healthComponent.getSelRecordList()) {
                    System.out.println("    (" + selRecord.getRecordID() + ")(" + SDRRecord.sensorNumberToSensorName.get("" + (selRecord.getSensorNumber() & 0xFF)) + ")(" + GlobalDefine.getEventType((byte)(selRecord.getEventDir() | selRecord.getEventType()), selRecord.getSensorType(), selRecord.getEventData1(), selRecord.getEventData2(), selRecord.getEventData3()) + ")(" + ByteUtility.fourByteToDateFormat2(selRecord.getTimeStamp()) + ")");
                }
                System.out.println("  State:" + HealthState.getStateString(healthComponent.getState()));
            }
        }
        while (!progressThread.isDone) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface Progress {
        public void setValue(int var1);

        public void message(String var1);

        public void left(long var1);
    }

    public class ProgressThread
    extends Thread {
        private int toProgress;
        private long speed = 100L;
        private boolean isDone;

        public void setToProgress(int toProgress) {
            this.toProgress = toProgress;
        }

        public void setSpeed(long milliseconds) {
            this.speed = milliseconds;
        }

        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public void run() {
            int value = 0;
            while (this.toProgress <= 100 && value <= 100) {
                if (value <= this.toProgress) {
                    IPMIHealthCheckCommand.this.setValue(value++);
                }
                try {
                    Thread.sleep(this.speed);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.isDone = true;
        }
    }
}

