/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.CRC8;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.FRU_Internal;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.pmbusStatus.Status;
import com.supermicro.ipmi.text.pmbusStatus.StatusManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class IPMII2CPMBusCommand
extends IPMICommand {
    IPMIMessagingCommand ipmiMessageCommand;
    byte busID;
    public byte[] slaveAddrs = new byte[]{120, 122, 124, 126, -80, -78, -76, -74, -72, -70};
    byte[] availableSlaveAddrs;
    byte slaveAddr;
    HashMap slaveAddrsToModuleName;
    byte psuIndex;
    int psuSet = 2;
    byte[] availablePsuIndexs;
    public boolean isUseOEMPsuCmd;
    public boolean isShowPWSFullStatus;
    public boolean isSimpleStatus;
    public byte[] slaveAddrsFRU = new byte[]{112, 114, 116, 118, -96, -94, -92, -90, -88, -86};
    byte[] availableSlaveAddrsFRU;
    byte slaveAddrFRU;
    HashMap slaveAddrsFruToModuleName;
    public byte[] slaveAddrsFRUBBP = new byte[]{112, 114, 116, 118};
    byte[] availableSlaveAddrsFRUBBP;
    byte slaveAddrFRUBBP;
    HashMap slaveAddrsFruBBPToModuleName;
    public PSUBootLoader bootLoader;
    String[] noneStandardSMCPowerSupplies = new String[]{"PWS-721P", "PWS-703P", "PWS-704P", "PWS-1K41P", "PWS-1K41F", "PWS-1K21P", "PWS-1K62P", "PWS-504P-RR", "PWS-920P-1R", "PWS-1K11P"};

    public IPMII2CPMBusCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
        this.slaveAddrsToModuleName = new HashMap();
        this.slaveAddrsFruToModuleName = new HashMap();
        this.slaveAddrsFruBBPToModuleName = new HashMap();
        this.slaveAddrsToModuleName.put(new Byte(-80), "PS 1");
        this.slaveAddrsToModuleName.put(new Byte(-78), "PS 2");
        this.slaveAddrsToModuleName.put(new Byte(-76), "PS 3");
        this.slaveAddrsToModuleName.put(new Byte(-74), "PS 4");
        this.slaveAddrsToModuleName.put(new Byte(120), "PS 1");
        this.slaveAddrsToModuleName.put(new Byte(122), "PS 2");
        this.slaveAddrsToModuleName.put(new Byte(124), "PS 3");
        this.slaveAddrsToModuleName.put(new Byte(126), "PS 4");
        this.slaveAddrsFruToModuleName.put(new Byte(112), "PS 1");
        this.slaveAddrsFruToModuleName.put(new Byte(114), "PS 2");
        this.slaveAddrsFruToModuleName.put(new Byte(116), "PS 3");
        this.slaveAddrsFruToModuleName.put(new Byte(118), "PS 4");
        this.slaveAddrsFruToModuleName.put(new Byte(-96), "PS 1");
        this.slaveAddrsFruToModuleName.put(new Byte(-94), "PS 2");
        this.slaveAddrsFruToModuleName.put(new Byte(-92), "PS 3");
        this.slaveAddrsFruToModuleName.put(new Byte(-90), "PS 4");
        this.slaveAddrsFruBBPToModuleName.put(new Byte(112), "BBP 1");
        this.slaveAddrsFruBBPToModuleName.put(new Byte(114), "BBP 2");
        this.slaveAddrsFruBBPToModuleName.put(new Byte(116), "BBP 3");
        this.slaveAddrsFruBBPToModuleName.put(new Byte(118), "BBP 4");
    }

    @Override
    public void setIPMIInterface(IPMIInterface ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiMessageCommand.setIPMIInterface(ipmiInterface);
    }

    public IPMII2CPMBusCommand(IPMIInterface ipmiInterface, byte busID, byte slaveAddr, byte psuIndex) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
        this.busID = busID;
        this.slaveAddr = slaveAddr;
        this.psuIndex = psuIndex;
    }

    public byte[] getAvailablePsuIndexs() {
        return this.availablePsuIndexs;
    }

    public void setPsuIndex(byte psuIndex) {
        this.psuIndex = psuIndex;
    }

    public IPMII2CPMBusCommand(IPMIInterface ipmiInterface, byte busID, byte slaveAddr) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
        this.busID = busID;
        this.slaveAddr = slaveAddr;
        this.bootLoader = new PSUBootLoader(slaveAddr);
    }

    public byte[] sendPMBusCommand(byte readCount, byte[] dataToWrite) throws Exception {
        return this.sendPMBusCommand(readCount, dataToWrite, false);
    }

    public byte[] sendPMBusCommand(byte readCount, byte[] dataToWrite, boolean retry) throws Exception {
        block5: {
            IPMIMessage resMessage;
            int count = 0;
            while (true) {
                resMessage = null;
                resMessage = this.isUseOEMPsuCmd ? this.ipmiMessageCommand.getOEMGetPSUInfoCommand(this.psuIndex, this.busID, this.slaveAddr, readCount, dataToWrite) : this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddr, readCount, dataToWrite);
                if (resMessage == null) break block5;
                if (resMessage.completionCode == 0) {
                    return resMessage.data;
                }
                if (resMessage.completionCode != -125 || !retry) break;
                if (++count >= 3) {
                    throw new IPMIException("Call MasterWriteReadCommand failed (PMBus)");
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (PMBus)");
    }

    public boolean checkOEMGetPSUInfoCommand(byte readCount, byte[] dataToWrite) throws Exception {
        block13: {
            IPMIMessage resMessage;
            int count = 0;
            while (true) {
                resMessage = null;
                byte psuInx = 1;
                byte slaveAddress = 120;
                resMessage = this.ipmiMessageCommand.getOEMGetPSUInfoCommand(psuInx, this.busID, slaveAddress, readCount, dataToWrite);
                if (resMessage == null) break block13;
                if (resMessage.completionCode == 0) {
                    return true;
                }
                if (resMessage.completionCode == -125) {
                    if (++count >= 3) {
                        return true;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (resMessage.completionCode == -52) {
                    if (++count >= 3) {
                        return false;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (resMessage.completionCode != -63) break;
                if (++count >= 3) {
                    return false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call CheckOEMGetPSUInfoCommand failed (PMBus)");
    }

    public byte[] sendFRUCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddrFRU, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (FRU)");
    }

    public byte[] sendFRUBBPCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddrFRUBBP, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (BBP)");
    }

    public byte[] sendVRMUpdateCommandByStep(byte readCount, byte[] dataToWrite) throws Exception {
        byte result = -125;
        for (int count = 0; count < 3; ++count) {
            IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddr, readCount, dataToWrite);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    return resMessage.data;
                }
                if (resMessage.completionCode == 131) {
                    result = resMessage.completionCode;
                    continue;
                }
                System.out.println("255 = update/verify failed to complete (hex code 0xff: error 38 cause early exit)");
                throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
            throw new IPMIException("Call MasterWriteReadCommand failed (VRM)");
        }
        System.out.println("255 = update/verify failed to complete (hex code 0xff: error 38 cause early exit)");
        throw new IPMIException(GlobalDefine.getCompletionCodeString(result));
    }

    public byte detectBusID() {
        byte[] guid = this.ipmiMessageCommand.getSystemGUID();
        if (IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid)) {
            this.busID = (byte)5;
        } else if (IPMIMessagingCommand.isCB3GUID(guid)) {
            this.busID = (byte)3;
        } else if (IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
            this.busID = (byte)23;
        } else if (IPMIMessagingCommand.isX13AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isG1AST2600ROT20LegoGUID(guid)) {
            this.busID = (byte)17;
            IPMIOEMCommand ipmioemCommand = new IPMIOEMCommand(this.ipmiInterface);
            String boardModel = ipmioemCommand.getBoardModel();
            if (boardModel.contains("G1SMH")) {
                this.busID = (byte)27;
            } else if (boardModel.contains("G2DMH-GI")) {
                this.busID = (byte)13;
            }
        } else {
            this.busID = (byte)7;
        }
        return this.busID;
    }

    public boolean checkIfPMBusSlaveAddrWorks(byte slaveAddr) {
        boolean isWork = false;
        this.detectBusID();
        byte backupSlaveAddr = this.slaveAddr;
        this.slaveAddr = slaveAddr;
        try {
            byte result = this.getVOUT_MODE();
            if (result != -1) {
                isWork = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.slaveAddr = backupSlaveAddr;
        return isWork;
    }

    public void detectSlaveAddress() {
        int i;
        if (this.busID == 0) {
            return;
        }
        Vector<Byte> temp = new Vector<Byte>();
        for (i = 0; i < this.slaveAddrs.length; ++i) {
            this.slaveAddr = this.slaveAddrs[i];
            try {
                byte result = this.getVOUT_MODE();
                if (result == -1) continue;
                if (this.slaveAddr >= 120 && this.slaveAddr <= 126) {
                    this.slaveAddr = (byte)(this.slaveAddr - 8);
                    try {
                        result = this.getPSUPresentStatusbyFRU();
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
                temp.add(new Byte(this.slaveAddrs[i]));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (temp.size() == 0) {
            for (i = 0; i < this.slaveAddrs.length; ++i) {
                this.slaveAddr = this.slaveAddrs[i];
                if (this.slaveAddr < 120 || this.slaveAddr > 126) continue;
                try {
                    byte result = this.getVOUT_MODE();
                    if (result == -1) continue;
                    temp.add(new Byte(this.slaveAddrs[i]));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (temp.size() != 0) {
            this.availableSlaveAddrs = new byte[temp.size()];
            for (i = 0; i < temp.size(); ++i) {
                this.availableSlaveAddrs[i] = (Byte)temp.get(i);
            }
        }
    }

    public Byte matchPsuIndex(int psuSet, byte slaveAddr) {
        Byte psuIndexVal = null;
        switch (slaveAddr) {
            case -80: {
                if (psuSet == 0) {
                    psuIndexVal = 1;
                    break;
                }
                if (psuSet != 1) break;
                psuIndexVal = 5;
                break;
            }
            case -78: {
                if (psuSet == 0) {
                    psuIndexVal = 2;
                    break;
                }
                if (psuSet != 1) break;
                psuIndexVal = 6;
                break;
            }
            case -76: {
                if (psuSet == 0) {
                    psuIndexVal = 3;
                    break;
                }
                if (psuSet != 1) break;
                psuIndexVal = 7;
                break;
            }
            case -74: {
                if (psuSet == 0) {
                    psuIndexVal = 4;
                    break;
                }
                if (psuSet != 1) break;
                psuIndexVal = 8;
                break;
            }
            case 120: {
                if (psuSet == 0) {
                    psuIndexVal = 1;
                    break;
                }
                if (psuSet != 1) break;
                psuIndexVal = 5;
                break;
            }
            case 122: {
                if (psuSet == 0) {
                    psuIndexVal = 2;
                    break;
                }
                if (psuSet != 1) break;
                psuIndexVal = 6;
                break;
            }
            case 124: {
                if (psuSet == 0) {
                    psuIndexVal = 3;
                    break;
                }
                if (psuSet != 1) break;
                psuIndexVal = 7;
                break;
            }
            case 126: {
                if (psuSet == 0) {
                    psuIndexVal = 4;
                    break;
                }
                if (psuSet != 1) break;
                psuIndexVal = 8;
            }
        }
        return psuIndexVal;
    }

    public void detectSlaveAddressWithPsuIndex() {
        if (this.busID == 0) {
            return;
        }
        Vector<Byte> temp = new Vector<Byte>();
        Vector<Byte> temp1 = new Vector<Byte>();
        for (int x = 0; x < this.psuSet; ++x) {
            for (int i = 0; i < this.slaveAddrs.length; ++i) {
                Byte psuIndexVal = this.matchPsuIndex(x, this.slaveAddrs[i]);
                if (psuIndexVal == null) continue;
                this.slaveAddr = this.slaveAddrs[i];
                this.psuIndex = psuIndexVal;
                try {
                    byte result = this.getVOUT_MODE();
                    if (result == -1) continue;
                    temp.add(new Byte(this.slaveAddrs[i]));
                    temp1.add(new Byte(this.psuIndex));
                    continue;
                }
                catch (Exception ex) {
                    try {
                        Thread.sleep(500L);
                        byte result = this.getVOUT_MODE();
                        if (result == -1) continue;
                        temp.add(new Byte(this.slaveAddrs[i]));
                        temp1.add(new Byte(this.psuIndex));
                        continue;
                    }
                    catch (Exception ex1) {
                        // empty catch block
                    }
                }
            }
        }
        if (temp.size() != 0) {
            this.availableSlaveAddrs = new byte[temp.size()];
            this.availablePsuIndexs = new byte[temp1.size()];
            for (int i = 0; i < temp.size(); ++i) {
                this.availableSlaveAddrs[i] = (Byte)temp.get(i);
                this.availablePsuIndexs[i] = (Byte)temp1.get(i);
            }
        }
    }

    public boolean checkOEMGetPSUInfoCommand() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{32};
        boolean result = this.checkOEMGetPSUInfoCommand(readCount, dataToWrite);
        return result;
    }

    public byte getVOUT_MODE() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{32};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte getStatusByte() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{120};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte getStatusHighByte() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{121};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        return result[1];
    }

    public byte getStatusDetail(byte readCount, byte cmdCode, int returnIndex) throws Exception {
        byte[] dataToWrite = new byte[]{cmdCode};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        return result[returnIndex];
    }

    public byte[] readACInputVoltage() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-120};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readACInputCurrent() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-119};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readDC12VOutputVoltage() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-117};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readDC12VOutputCurrent() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-116};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readTemperature1() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-115};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readTemperature2() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-114};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readFan1() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-112};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readFan2() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-111};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readDC12VOutputPower() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-106};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readACInputPower() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-105};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] getPMBusRevision() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-104};
        return this.sendPMBusCommand(readCount, dataToWrite, true);
    }

    public byte[] getPWSSerialNumber() throws Exception {
        if (this.isUseOEMPsuCmd) {
            return this.getPWSSerialNumberUseOEMCmd();
        }
        if (this.isB0Addr()) {
            return null;
        }
        byte[] commands = new byte[]{-48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34};
        byte readCount = 1;
        byte[] result = new byte[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            byte[] dataToWrite = new byte[]{commands[i]};
            byte[] r = this.sendPMBusCommand(readCount, dataToWrite, true);
            if (r[0] == -1 || r[0] == 0 || r.length == 0) continue;
            result[i] = r[0];
        }
        return result;
    }

    public byte[] getPWSModuleNumber() throws Exception {
        if (this.isUseOEMPsuCmd) {
            return this.getPWSModuleNumberUseOEMCmd();
        }
        if (this.isB0Addr()) {
            return null;
        }
        byte[] commands = new byte[]{-32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20};
        byte readCount = 1;
        byte[] result = new byte[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            byte[] r;
            byte[] dataToWrite = new byte[]{commands[i]};
            try {
                r = this.sendPMBusCommand(readCount, dataToWrite, true);
            }
            catch (Exception e) {
                if (dataToWrite[0] == -20) continue;
                throw e;
            }
            if (r[0] == -1 || r[0] == 0 || r.length == 0) continue;
            result[i] = r[0];
        }
        return result;
    }

    public byte[] getPWSRevision() throws Exception {
        if (this.isUseOEMPsuCmd) {
            return this.getPWSRevisionUseOEMCmd();
        }
        if (this.isB0Addr()) {
            return null;
        }
        byte[] commands = new byte[]{-13, -12, -11};
        byte readCount = 1;
        byte[] result = new byte[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            byte[] dataToWrite = new byte[]{commands[i]};
            byte[] r = this.sendPMBusCommand(readCount, dataToWrite);
            if (r[0] == -1 || r[0] == 0 || r.length == 0) continue;
            result[i] = r[0];
        }
        return result;
    }

    public byte getPSUPresentStatusbyFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{12};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte[] getPWSSerialNumberUseOEMCmd() throws Exception {
        byte readCount = 15;
        byte[] dataToWrite = new byte[]{-48};
        return this.sendPMBusCommand(readCount, dataToWrite, true);
    }

    public byte[] getPWSModuleNumberUseOEMCmd() throws Exception {
        byte readCount = 13;
        byte[] dataToWrite = new byte[]{-32};
        return this.sendPMBusCommand(readCount, dataToWrite, true);
    }

    public byte[] getPWSRevisionUseOEMCmd() throws Exception {
        byte readCount = 6;
        byte[] dataToWrite = new byte[]{-16};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite, true);
        byte[] newResult = ByteUtility.arrayTrimZero(result);
        return newResult;
    }

    public byte getInputTypeFlag() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-4};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte[] getMFR_HW_COMPATIBILITY() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{this.bootLoader.getMFR_HW_COMPATIBILITY()};
        byte[] pecSource = new byte[dataToWrite.length + 1];
        pecSource[0] = this.slaveAddr;
        System.arraycopy(dataToWrite, 0, pecSource, 1, dataToWrite.length);
        byte pec = CRC8.crc8(pecSource);
        System.arraycopy(dataToWrite, 0, pecSource, 0, dataToWrite.length);
        pecSource[pecSource.length - 1] = pec;
        byte[] result = this.sendPMBusCommand(readCount, pecSource);
        return result;
    }

    public byte getMFR_FWUPLOAD_CAPABILITY() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{this.bootLoader.getMFR_FWUPLOAD_CAPABILITY()};
        byte[] pecSource = new byte[dataToWrite.length + 1];
        pecSource[0] = this.slaveAddr;
        System.arraycopy(dataToWrite, 0, pecSource, 1, dataToWrite.length);
        byte pec = CRC8.crc8(pecSource);
        System.arraycopy(dataToWrite, 0, pecSource, 0, dataToWrite.length);
        pecSource[pecSource.length - 1] = pec;
        byte[] result = this.sendPMBusCommand(readCount, pecSource);
        return result[0];
    }

    public void enterFWUpdateMode() throws Exception {
        this.setMFR_FWUPLOAD_MODE((byte)1);
    }

    public void exitFWUpdateMode() throws Exception {
        this.setMFR_FWUPLOAD_MODE((byte)0);
    }

    public void setMFR_FWUPLOAD_MODE(byte mode) throws Exception {
        byte readCount = 0;
        byte[] dataToWrite = new byte[]{this.bootLoader.getMFR_FWUPLOAD_MODE(), mode};
        byte[] pecSource = new byte[dataToWrite.length + 1];
        pecSource[0] = this.slaveAddr;
        System.arraycopy(dataToWrite, 0, pecSource, 1, dataToWrite.length);
        byte pec = CRC8.crc8(pecSource);
        System.arraycopy(dataToWrite, 0, pecSource, 0, dataToWrite.length);
        pecSource[pecSource.length - 1] = pec;
        this.sendPMBusCommand(readCount, pecSource);
    }

    public byte getMFR_FWUPLOAD_MODE() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{this.bootLoader.getMFR_FWUPLOAD_MODE()};
        byte[] pecSource = new byte[dataToWrite.length + 1];
        pecSource[0] = this.slaveAddr;
        System.arraycopy(dataToWrite, 0, pecSource, 1, dataToWrite.length);
        byte pec = CRC8.crc8(pecSource);
        System.arraycopy(dataToWrite, 0, pecSource, 0, dataToWrite.length);
        pecSource[pecSource.length - 1] = pec;
        byte[] result = this.sendPMBusCommand(readCount, pecSource);
        return result[0];
    }

    public void setMFR_FWUPLOAD(byte[] data) throws Exception {
        byte readCount = 0;
        byte[] dataToWrite = new byte[data.length + 1];
        dataToWrite[0] = this.bootLoader.getMFR_FWUPLOAD();
        System.arraycopy(data, 0, dataToWrite, 1, data.length);
        byte[] pecSource = new byte[dataToWrite.length + 1];
        pecSource[0] = this.slaveAddr;
        System.arraycopy(dataToWrite, 0, pecSource, 1, dataToWrite.length);
        byte pec = CRC8.crc8(pecSource);
        System.arraycopy(dataToWrite, 0, pecSource, 0, dataToWrite.length);
        pecSource[pecSource.length - 1] = pec;
        this.sendPMBusCommand(readCount, pecSource);
    }

    public byte getMFR_FWUPLOAD_STATUS() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{this.bootLoader.getMFR_FWUPLOAD_STATUS()};
        byte[] pecSource = new byte[dataToWrite.length + 1];
        pecSource[0] = this.slaveAddr;
        System.arraycopy(dataToWrite, 0, pecSource, 1, dataToWrite.length);
        byte pec = CRC8.crc8(pecSource);
        System.arraycopy(dataToWrite, 0, pecSource, 0, dataToWrite.length);
        pecSource[pecSource.length - 1] = pec;
        byte[] result = this.sendPMBusCommand(readCount, pecSource);
        return result[0];
    }

    public byte[] getMFR_FW_REVISION() throws Exception {
        byte readCount = 5;
        byte[] dataToWrite = new byte[]{this.bootLoader.getMFR_FW_REVISION()};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        byte[] r = new byte[readCount - 2];
        System.arraycopy(result, 1, r, 0, r.length);
        return r;
    }

    public byte[] getMFR_MODEL() throws Exception {
        byte readCount = 15;
        byte[] dataToWrite = new byte[]{this.bootLoader.getMFR_MODEL()};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        byte[] r = new byte[readCount - 2];
        if (result[0] <= 13) {
            System.arraycopy(result, 1, r, 0, result[0]);
        } else {
            System.arraycopy(result, 1, r, 0, r.length);
        }
        return r;
    }

    public byte[] getMFR_REVISION() throws Exception {
        byte readCount = 8;
        byte[] dataToWrite = new byte[]{-101};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        byte[] r = new byte[readCount - 2];
        System.arraycopy(result, 1, r, 0, r.length);
        return r;
    }

    public PMBusHealth getAll() throws Exception {
        byte[] numberBytes;
        PMBusHealth pmBusHealth = new PMBusHealth();
        try {
            pmBusHealth.VOUT_MODE = this.getVOUT_MODE();
            pmBusHealth.isVOUT_MODE = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.statusByte = this.getStatusByte();
            pmBusHealth.isStatusByte = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.statusHighByte = this.getStatusHighByte();
            pmBusHealth.isStatusHighByte = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.acInputVoltage = this.readACInputVoltage();
            pmBusHealth.isAcInputVoltage = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.acInputCurrent = this.readACInputCurrent();
            pmBusHealth.isAcInputCurrent = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.dc12VOutputVoltage = this.readDC12VOutputVoltage();
            pmBusHealth.isDc12VOutputVoltage = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.dc12VOutputCurrent = this.readDC12VOutputCurrent();
            pmBusHealth.isDc12VOutputCurrent = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.temperature1 = this.readTemperature1();
            pmBusHealth.isTemperature1 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.temperature2 = this.readTemperature2();
            pmBusHealth.isTemperature2 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.fan1 = this.readFan1();
            pmBusHealth.isFan1 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.fan2 = this.readFan2();
            pmBusHealth.isFan2 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.dc12VOutputPower = this.readDC12VOutputPower();
            pmBusHealth.isDc12VOutputPower = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.acInputPower = this.readACInputPower();
            pmBusHealth.isAcInputPower = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.pmBusRevision = this.getPMBusRevision();
            pmBusHealth.isPmBusRevision = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.pwsSerialNumber = this.getPWSSerialNumber();
            pmBusHealth.isPwsSerialNumber = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.pwsModuleNumber = this.getPWSModuleNumber();
            pmBusHealth.isPwsModuleNumber = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.pwsRevision = this.getPWSRevision();
            pmBusHealth.isPwsRevision = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.inputType = this.getInputTypeFlag();
            pmBusHealth.isInputType = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.statusInsts = pmBusHealth.statusManager.getAllStatusFromPMBus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isB0Addr() && !this.isUseOEMPsuCmd) {
            try {
                this.replaceMODULE_SN_REVISION_fromFRU(pmBusHealth);
            }
            catch (Exception e) {
                pmBusHealth.isPwsModuleNumber = false;
                pmBusHealth.isPwsSerialNumber = false;
                pmBusHealth.isPwsRevision = false;
            }
        }
        if (!this.isB0Addr() && pmBusHealth.isPwsModuleNumber && !this.isUseOEMPsuCmd && (numberBytes = pmBusHealth.pwsModuleNumber) != null && new String(pmBusHealth.pwsModuleNumber).indexOf("PWS") == -1) {
            this.checkFRU(pmBusHealth);
        }
        if (pmBusHealth.isPwsModuleNumber && new String(pmBusHealth.pwsModuleNumber).indexOf("1K62P") != -1) {
            pmBusHealth.statusByte = pmBusHealth.getDC12VOutputVoltage() > 10.0 ? (byte)1 : 0;
        }
        return pmBusHealth;
    }

    public void delay() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isB0Addr() {
        if (this.slaveAddr == -80 || this.slaveAddr == -78 || this.slaveAddr == -76 || this.slaveAddr == -74 || this.slaveAddr == -72 || this.slaveAddr == -70) {
            this.slaveAddrFRU = (byte)(this.slaveAddr - 16);
            try {
                byte b = this.readStatusByFRU();
                if ((byte)(b & 0x80) != -128) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void replaceMODULE_SN_REVISION_fromFRU(PMBusHealth pmbusHealth) throws Exception {
        this.slaveAddrFRU = (byte)(this.slaveAddr - 16);
        byte[] fruRaw = new byte[256];
        byte readCount = 1;
        for (int i = 0; i < 217 / readCount; ++i) {
            byte[] dataToWrite = new byte[]{(byte)(i * readCount)};
            byte[] tempRaw = this.sendFRUCommand(readCount, dataToWrite);
            System.arraycopy(tempRaw, 0, fruRaw, i * readCount, readCount);
        }
        BBPHealth fruData = new BBPHealth();
        fruData.fromRaw(fruRaw);
        if (fruData.fruInfo == null) {
            byte[] temp = new String("PSU FRU Error").getBytes();
            pmbusHealth.pwsModuleNumber = temp;
            pmbusHealth.pwsSerialNumber = temp;
            pmbusHealth.pwsRevision = temp;
            return;
        }
        pmbusHealth.pwsModuleNumber = fruData.fruInfo.fru.product.productName;
        pmbusHealth.pwsSerialNumber = fruData.fruInfo.fru.product.productSerialNumber;
        pmbusHealth.pwsRevision = fruData.fruInfo.fru.product.productVersion;
    }

    public void checkFRU(PMBusHealth pmbusHealth) throws Exception {
        this.slaveAddrFRU = (byte)(this.slaveAddr - 8);
        byte[] fruRaw = new byte[256];
        byte readCount = 1;
        try {
            for (int i = 0; i < 196 / readCount; ++i) {
                byte[] dataToWrite = new byte[]{(byte)(i * readCount)};
                byte[] tempRaw = this.sendFRUCommand(readCount, dataToWrite);
                System.arraycopy(tempRaw, 0, fruRaw, i * readCount, readCount);
            }
        }
        catch (IPMIException e) {
            return;
        }
        BBPHealth fruData = new BBPHealth();
        try {
            fruData.fromRaw(fruRaw);
        }
        catch (Exception e) {
            return;
        }
        if (fruData.fruInfo == null) {
            return;
        }
        pmbusHealth.pwsModuleNumber = fruData.fruInfo.fru.product.productName;
        pmbusHealth.pwsSerialNumber = fruData.fruInfo.fru.product.productSerialNumber;
        pmbusHealth.pwsRevision = fruData.fruInfo.fru.product.productVersion;
        if (new String(pmbusHealth.pwsModuleNumber).length() != 0) {
            pmbusHealth.isPwsModuleNumber = true;
        }
        if (new String(pmbusHealth.pwsSerialNumber).length() != 0) {
            pmbusHealth.isPwsSerialNumber = true;
        }
        if (new String(pmbusHealth.pwsRevision).length() != 0) {
            pmbusHealth.isPwsRevision = true;
        }
    }

    public void detectSlaveAddressFRU() {
        int i;
        if (this.busID == 0) {
            return;
        }
        Vector<Byte> temp = new Vector<Byte>();
        for (i = 0; i < this.slaveAddrsFRU.length; ++i) {
            this.slaveAddrFRU = this.slaveAddrsFRU[i];
            try {
                byte b = this.readStatusByFRU();
                if ((byte)(b & 0x80) == -128) continue;
                temp.add(new Byte(this.slaveAddrsFRU[i]));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (temp.size() != 0) {
            this.availableSlaveAddrsFRU = new byte[temp.size()];
            for (i = 0; i < temp.size(); ++i) {
                this.availableSlaveAddrsFRU[i] = (Byte)temp.get(i);
            }
        }
    }

    public byte readStatusByFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{12};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte readTemperatureByFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{9};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte readFan1ByFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{10};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte readFan2ByFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{11};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result[0];
    }

    public FRUHealth getAllFRU() throws Exception {
        FRUHealth fruHealth = new FRUHealth();
        try {
            fruHealth.statusByte = this.readStatusByFRU();
            fruHealth.isStatusByte = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            fruHealth.temperature = this.readTemperatureByFRU();
            fruHealth.isTemperature = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            fruHealth.fan1 = this.readFan1ByFRU();
            fruHealth.isFan1 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        try {
            fruHealth.fan2 = this.readFan2ByFRU();
            fruHealth.isFan2 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        return fruHealth;
    }

    public byte[] readSerialNumberFRU() throws Exception {
        byte readCount = 15;
        byte[] dataToWrite = new byte[]{69};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] readModuleNumberFRU() throws Exception {
        byte readCount = 12;
        byte[] dataToWrite = new byte[]{39};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] readRevisionFRU() throws Exception {
        byte readCount = 3;
        byte[] dataToWrite = new byte[]{65};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result;
    }

    public boolean isA0Addr() {
        if (this.slaveAddrFRU == -96 || this.slaveAddrFRU == -94 || this.slaveAddrFRU == -92 || this.slaveAddrFRU == -90) {
            this.slaveAddr = (byte)(this.slaveAddrFRU + 16);
            try {
                this.getVOUT_MODE();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void detectSlaveAddressFRUBBP() {
        int i;
        if (this.busID == 0) {
            return;
        }
        Vector<Byte> tempVector = new Vector<Byte>();
        for (i = 0; i < this.slaveAddrsFRUBBP.length; ++i) {
            this.slaveAddrFRUBBP = this.slaveAddrsFRUBBP[i];
            try {
                byte status = this.readStatusByFRUBBP();
                if ((status & 0xFFFFFF80) == -128 || (status & 0x40) == 64) {
                    tempVector.add(new Byte(this.slaveAddrsFRUBBP[i]));
                    continue;
                }
                if ((status & 0x40) != 64) continue;
                tempVector.add(new Byte(this.slaveAddrsFRUBBP[i]));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (tempVector.size() != 0) {
            this.availableSlaveAddrsFRUBBP = new byte[tempVector.size()];
            for (i = 0; i < tempVector.size(); ++i) {
                this.availableSlaveAddrsFRUBBP[i] = (Byte)tempVector.get(i);
            }
        }
    }

    public BBPHealth getAllBBP() throws Exception {
        byte[] BBPFRURaw = new byte[256];
        for (int i = 0; i < 8; ++i) {
            byte[] tempRaw = this.read32bytesFRUBBP((byte)(i * 32));
            System.arraycopy(tempRaw, 0, BBPFRURaw, i * 32, 32);
        }
        BBPHealth bbpHealth = new BBPHealth();
        bbpHealth.fromRaw(BBPFRURaw);
        return bbpHealth;
    }

    public byte readStatusByFRUBBP() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{12};
        byte[] result = this.sendFRUBBPCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte[] read32bytesFRUBBP(byte offset) throws Exception {
        byte readCount = 32;
        byte[] dataToWrite = new byte[]{offset};
        byte[] result = this.sendFRUBBPCommand(readCount, dataToWrite);
        return result;
    }

    public void setAutoDischargeCommand(byte day) throws Exception {
        byte readCount = 0;
        byte value = (byte)(0xFFFFFF80 | day);
        byte[] dataToWrite = new byte[]{-22, value};
        this.sendFRUBBPCommand(readCount, dataToWrite);
    }

    public void setUserDischargeCommand() throws Exception {
        byte readCount = 0;
        byte day = this.read0xE9Offset();
        day = (byte)(day & 0x3F);
        byte value = (byte)(0x40 | day);
        byte[] dataToWrite = new byte[]{-22, value};
        this.sendFRUBBPCommand(readCount, dataToWrite);
    }

    public byte read0xE9Offset() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-23};
        byte[] result = this.sendFRUBBPCommand(readCount, dataToWrite);
        return result[0];
    }

    public void setBBPCommand(byte offset, byte data) throws Exception {
        byte readCount = 0;
        byte[] dataToWrite = new byte[]{offset, data};
        this.sendFRUBBPCommand(readCount, dataToWrite);
    }

    public IPMIMessage getBBPThrottleStatusCommand(byte cmmType) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        boolean CMM_TYPE3 = false;
        boolean CMM_TYPE6 = true;
        int CMM_TYPE3_LEN = 5;
        int CMM_TYPE6_LEN = 6;
        byte[] data = new byte[cmmType == 0 ? 5 : 6];
        data[0] = -17;
        if (cmmType == 0) {
            data[1] = 13;
            data[2] = -120;
            data[3] = 1;
            data[4] = 1;
        } else if (cmmType == 1) {
            data[1] = 0;
            data[2] = 13;
            data[3] = -120;
            data[4] = 1;
            data[5] = 1;
        }
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBBPThrottleStatusCommand(byte cmmType, byte status) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        boolean CMM_TYPE3 = false;
        boolean CMM_TYPE6 = true;
        int CMM_TYPE3_LEN = 6;
        int CMM_TYPE6_LEN = 7;
        byte[] data = new byte[cmmType == 0 ? 6 : 7];
        data[0] = -17;
        if (cmmType == 0) {
            data[1] = 13;
            data[2] = -120;
            data[3] = 0;
            data[4] = 1;
            data[5] = status;
        } else if (cmmType == 1) {
            data[1] = 0;
            data[2] = 13;
            data[3] = -120;
            data[4] = 0;
            data[5] = 1;
            data[6] = status;
        }
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void updateVRMdataCommand(byte[] data) throws Exception {
        byte readCount = 0;
        this.sendVRMUpdateCommandByStep(readCount, data);
    }

    public byte[] checkVRMdata(byte offset) throws Exception {
        byte readCount = 2;
        byte[] data = new byte[]{offset};
        byte[] result = this.sendVRMUpdateCommandByStep(readCount, data);
        return result;
    }

    public void enableConfigurationMode() throws Exception {
        byte readCount = 0;
        byte[] data = new byte[]{116, 8, 0};
        this.sendPMBusCommand(readCount, data);
    }

    public boolean checkLCMCDeviceID() throws Exception {
        byte readCount = 4;
        byte[] data = new byte[]{-32, 0, 0, 0};
        byte[] result = this.sendPMBusCommand(readCount, data);
        return result[0] == 1 && result[1] == 43 && result[2] == -48 && result[3] == 67;
    }

    public void CFGFlashErase() throws Exception {
        byte readCount = 0;
        byte[] data = new byte[]{14, 4, 0, 0};
        this.sendPMBusCommand(readCount, data);
    }

    public boolean checkLCMCBusy() throws Exception {
        byte readCount = 1;
        byte[] data = new byte[]{-16, 0, 0, 0};
        byte[] result = this.sendPMBusCommand(readCount, data);
        return (result[0] & 0xFFFFFF80) == -128;
    }

    public void disableConfigurationModeAndBypass() throws Exception {
        byte readCount = 0;
        byte[] data = new byte[]{38, 0, 0};
        this.sendPMBusCommand(readCount, data);
        data = new byte[]{-1};
        this.sendPMBusCommand(readCount, data);
    }

    public boolean CFGFlashWrite(String fileName) throws Exception {
        String s;
        FileReader fr = new FileReader(fileName);
        BufferedReader br = new BufferedReader(fr);
        byte readCount = 0;
        while (br.ready() && (s = br.readLine()) != null) {
            byte[] pageContent = ByteUtility.hexToBytes(s);
            byte[] data = new byte[4 + pageContent.length];
            readCount = 0;
            data[0] = 112;
            data[1] = 0;
            data[2] = 0;
            data[3] = 1;
            System.arraycopy(pageContent, 0, data, 4, pageContent.length);
            this.sendPMBusCommand(readCount, data, true);
            while (this.checkLCMCBusy()) {
            }
            readCount = 4;
            data = new byte[]{60, 0, 0, 0};
            byte[] result = this.sendPMBusCommand(readCount, data, true);
            if ((result[1] & 0x20) != 32) continue;
            br.close();
            fr.close();
            return false;
        }
        br.close();
        fr.close();
        return true;
    }

    public void resetCFGAddress() throws Exception {
        byte readCount = 0;
        byte[] data = new byte[]{70, 0, 0, 0};
        this.sendPMBusCommand(readCount, data);
    }

    public boolean CFGFlashCompare(String fileName) throws Exception {
        String s;
        FileReader fr = new FileReader(fileName);
        BufferedReader br = new BufferedReader(fr);
        byte readCount = 16;
        while (br.ready() && (s = br.readLine()) != null) {
            byte[] pageContent = ByteUtility.hexToBytes(s);
            byte[] data = new byte[]{115, 0, 0, 1};
            byte[] result = this.sendPMBusCommand(readCount, data, true);
            for (int i = 0; i < pageContent.length; ++i) {
                if (pageContent[i] == result[i]) continue;
                br.close();
                fr.close();
                return false;
            }
        }
        br.close();
        fr.close();
        return true;
    }

    public void programCFGDone() throws Exception {
        byte readCount = 0;
        byte[] data = new byte[]{94, 0, 0, 0};
        this.sendPMBusCommand(readCount, data);
    }

    public void deviceRefresh() throws Exception {
        byte readCount = 0;
        byte[] data = new byte[]{121, 0, 0};
        this.sendPMBusCommand(readCount, data);
    }

    public void test() {
        PMBusHealth pmBusHealth = new PMBusHealth();
        byte[] b = new byte[]{0, 4};
        double d = pmBusHealth.linearDataFormat(b);
        System.out.println("d =" + d);
    }

    public static void main(String[] args) {
        IPMII2CPMBusCommand iii = new IPMII2CPMBusCommand(null);
        iii.test();
    }

    public byte getBusID() {
        return this.busID;
    }

    public byte getSlaveAddr() {
        return this.slaveAddr;
    }

    public byte[] getAvailableSlaveAddrs() {
        return this.availableSlaveAddrs;
    }

    public ArrayList getAvailableSlaveAddrsName() {
        ArrayList list = new ArrayList();
        if (this.availableSlaveAddrs == null) {
            return list;
        }
        for (int i = 0; i < this.availableSlaveAddrs.length; ++i) {
            Byte b = new Byte(this.availableSlaveAddrs[i]);
            list.add(this.slaveAddrsToModuleName.get(b));
        }
        return list;
    }

    public byte getSlaveAddrFRU() {
        return this.slaveAddrFRU;
    }

    public byte[] getAvailableSlaveAddrsFRU() {
        return this.availableSlaveAddrsFRU;
    }

    public ArrayList getAvailableSlaveAddrsFRUName() {
        ArrayList list = new ArrayList();
        if (this.availableSlaveAddrsFRU == null) {
            return list;
        }
        for (int i = 0; i < this.availableSlaveAddrsFRU.length; ++i) {
            Byte b = new Byte(this.availableSlaveAddrsFRU[i]);
            list.add(this.slaveAddrsFruToModuleName.get(b));
        }
        return list;
    }

    public byte[] getAvailableSlaveAddrsFRUBBP() {
        return this.availableSlaveAddrsFRUBBP;
    }

    public ArrayList getAvailableSlaveAddrsFRUBBPName() {
        ArrayList list = new ArrayList();
        if (this.availableSlaveAddrsFRUBBP == null) {
            return list;
        }
        for (int i = 0; i < this.availableSlaveAddrsFRUBBP.length; ++i) {
            Byte b = new Byte(this.availableSlaveAddrsFRUBBP[i]);
            list.add(this.slaveAddrsFruBBPToModuleName.get(b));
        }
        return list;
    }

    public void setBusID(byte busID) {
        this.busID = busID;
    }

    public void setSlaveAddr(byte slaveAddr) {
        this.slaveAddr = slaveAddr;
    }

    public void setSlaveAddrFRU(byte slaveAddrFRU) {
        this.slaveAddrFRU = slaveAddrFRU;
    }

    public void setSlaveAddrFRUBBP(byte slaveAddrFRUBBP) {
        this.slaveAddrFRUBBP = slaveAddrFRUBBP;
    }

    public int getModule(byte aSlaveAddr) {
        if (aSlaveAddr == 120) {
            return 1;
        }
        if (aSlaveAddr == 122) {
            return 2;
        }
        if (aSlaveAddr == 124) {
            return 3;
        }
        if (aSlaveAddr == 126) {
            return 4;
        }
        if (aSlaveAddr == -80) {
            return 1;
        }
        if (aSlaveAddr == -78) {
            return 2;
        }
        if (aSlaveAddr == -76) {
            return 3;
        }
        if (aSlaveAddr == -74) {
            return 4;
        }
        if (aSlaveAddr == -72) {
            return 5;
        }
        if (aSlaveAddr == -70) {
            return 6;
        }
        return 0;
    }

    public int getModuleByFRU(byte aSlaveAddrFRU) {
        if (aSlaveAddrFRU == 112) {
            return 1;
        }
        if (aSlaveAddrFRU == 114) {
            return 2;
        }
        if (aSlaveAddrFRU == 116) {
            return 3;
        }
        if (aSlaveAddrFRU == 118) {
            return 4;
        }
        if (aSlaveAddrFRU == -96) {
            return 1;
        }
        if (aSlaveAddrFRU == -94) {
            return 2;
        }
        if (aSlaveAddrFRU == -92) {
            return 3;
        }
        if (aSlaveAddrFRU == -90) {
            return 4;
        }
        if (aSlaveAddrFRU == -88) {
            return 5;
        }
        if (aSlaveAddrFRU == -86) {
            return 6;
        }
        return 0;
    }

    public int getModuleByFRUBBP(byte aSlaveAddrFRUBBP) {
        if (aSlaveAddrFRUBBP == 112) {
            return 1;
        }
        if (aSlaveAddrFRUBBP == 114) {
            return 2;
        }
        if (aSlaveAddrFRUBBP == 116) {
            return 3;
        }
        if (aSlaveAddrFRUBBP == 118) {
            return 4;
        }
        return 0;
    }

    public String getCPLDversion() {
        this.busID = (byte)3;
        this.slaveAddr = (byte)114;
        byte[] cpld = new byte[3];
        byte[] data = new byte[1];
        for (int i = 0; i < 3; ++i) {
            data[0] = (byte)i;
            try {
                byte[] result = this.sendPMBusCommand((byte)1, data);
                cpld[i] = result[0];
                continue;
            }
            catch (Exception ex) {
                return null;
            }
        }
        String s = ByteUtility.byteToHex(cpld[2]) + "." + ByteUtility.byteToHex(cpld[1]) + "." + ByteUtility.byteToHex(cpld[0]);
        s = s.toLowerCase();
        return s;
    }

    public String getHGICarrierBoardCPLDVersion() {
        byte[] result;
        this.busID = (byte)5;
        this.slaveAddr = (byte)-124;
        byte[] data = new byte[]{5};
        try {
            result = this.sendPMBusCommand((byte)3, data);
        }
        catch (Exception ex) {
            return null;
        }
        String s = ByteUtility.byteToHex(result[2]) + "." + ByteUtility.byteToHex(result[1]) + "." + ByteUtility.byteToHex(result[0]);
        return s;
    }

    public String getTatlowCPLDVersion() {
        this.busID = (byte)21;
        this.slaveAddr = (byte)112;
        byte[] cpld = new byte[3];
        byte[] data = new byte[1];
        for (int i = 0; i < 3; ++i) {
            data[0] = (byte)(i + 5);
            try {
                byte[] result = this.sendPMBusCommand((byte)1, data);
                cpld[i] = result[0];
                continue;
            }
            catch (Exception ex) {
                return null;
            }
        }
        String s = ByteUtility.byteToHex(cpld[2]) + "." + ByteUtility.byteToHex(cpld[1]) + "." + ByteUtility.byteToHex(cpld[0]);
        return s;
    }

    public String getPLLDversion2500() {
        this.busID = (byte)3;
        this.slaveAddr = (byte)112;
        byte[] cpld = new byte[3];
        byte[] data = new byte[1];
        for (int i = 0; i < 3; ++i) {
            data[0] = (byte)(i + 5);
            try {
                byte[] result = this.sendPMBusCommand((byte)1, data);
                cpld[i] = result[0];
                continue;
            }
            catch (Exception ex) {
                return null;
            }
        }
        String s = ByteUtility.byteToHex(cpld[2]) + "." + ByteUtility.byteToHex(cpld[1]) + "." + ByteUtility.byteToHex(cpld[0]);
        s = s.toLowerCase();
        return s;
    }

    public byte getBBPThrottleStatus(byte type) {
        IPMIMessage resMessage = this.getBBPThrottleStatusCommand(type);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data != null) {
                    return resMessage.data[0];
                }
                MessageCenter.getInstance().put(this, (Object)"resMessage data is empty");
                return 0;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute getBBPThrottleStatus.");
        return 0;
    }

    public boolean setBBPThrottleStatus(byte type, byte status) {
        IPMIMessage resMessage = this.setBBPThrottleStatusCommand(type, status);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute setBBPThrottleStatus");
        return false;
    }

    public class PSUBootLoader {
        byte slave;
        byte MFR_MODEL;
        byte MFR_HW_COMPATIBILITY;
        byte MFR_FWUPLOAD_CAPABILITY;
        byte MFR_FWUPLOAD_MODE;
        byte MFR_FWUPLOAD;
        byte MFR_FWUPLOAD_STATUS;
        byte MFR_FW_REVISION;
        byte[] slave7X = new byte[]{120, 122, 124, 126};
        byte[] slaveBX = new byte[]{-80, -78, -76, -74};
        boolean isSlave7X = false;

        public PSUBootLoader(byte slave_address) {
            this.slave = slave_address;
            for (int i = 0; i < this.slave7X.length; ++i) {
                if (this.slave != this.slave7X[i]) continue;
                this.isSlave7X = true;
                break;
            }
            if (this.isSlave7X) {
                this.MFR_MODEL = (byte)-102;
                this.MFR_HW_COMPATIBILITY = (byte)-10;
                this.MFR_FWUPLOAD_CAPABILITY = (byte)-9;
                this.MFR_FWUPLOAD_MODE = (byte)-8;
                this.MFR_FWUPLOAD = (byte)-7;
                this.MFR_FWUPLOAD_STATUS = (byte)-6;
                this.MFR_FW_REVISION = (byte)-5;
            } else {
                this.MFR_MODEL = (byte)-102;
                this.MFR_HW_COMPATIBILITY = (byte)-44;
                this.MFR_FWUPLOAD_CAPABILITY = (byte)-43;
                this.MFR_FWUPLOAD_MODE = (byte)-42;
                this.MFR_FWUPLOAD = (byte)-41;
                this.MFR_FWUPLOAD_STATUS = (byte)-40;
                this.MFR_FW_REVISION = (byte)-39;
            }
        }

        public byte getMFR_MODEL() {
            return this.MFR_MODEL;
        }

        public byte getMFR_HW_COMPATIBILITY() {
            return this.MFR_HW_COMPATIBILITY;
        }

        public byte getMFR_FWUPLOAD_CAPABILITY() {
            return this.MFR_FWUPLOAD_CAPABILITY;
        }

        public byte getMFR_FWUPLOAD_MODE() {
            return this.MFR_FWUPLOAD_MODE;
        }

        public byte getMFR_FWUPLOAD() {
            return this.MFR_FWUPLOAD;
        }

        public byte getMFR_FWUPLOAD_STATUS() {
            return this.MFR_FWUPLOAD_STATUS;
        }

        public byte getMFR_FW_REVISION() {
            return this.MFR_FW_REVISION;
        }
    }

    public class PMBusHealth {
        public byte VOUT_MODE;
        public byte statusByte;
        public byte statusHighByte;
        public byte[] acInputVoltage;
        public byte[] acInputCurrent;
        public byte[] dc12VOutputVoltage;
        public byte[] dc12VOutputCurrent;
        public byte[] temperature1;
        public byte[] temperature2;
        public byte[] fan1;
        public byte[] fan2;
        public byte[] dc12VOutputPower;
        public byte[] acInputPower;
        public byte[] pmBusRevision;
        public byte[] pwsSerialNumber;
        public byte[] pwsModuleNumber;
        public byte[] pwsRevision;
        public byte inputType;
        public boolean isVOUT_MODE;
        public boolean isStatusByte;
        public boolean isStatusHighByte;
        public boolean isAcInputVoltage;
        public boolean isAcInputCurrent;
        public boolean isDc12VOutputVoltage;
        public boolean isDc12VOutputCurrent;
        public boolean isTemperature1;
        public boolean isTemperature2;
        public boolean isFan1;
        public boolean isFan2;
        public boolean isDc12VOutputPower;
        public boolean isAcInputPower;
        public boolean isPmBusRevision;
        public boolean isPwsSerialNumber;
        public boolean isPwsModuleNumber;
        public boolean isPwsRevision;
        public boolean isInputType;
        public StatusManager statusManager = new StatusManager(this);
        public Map<String, Status> statusInsts;

        public double getACInputVoltage() {
            byte[] temp = new byte[]{this.acInputVoltage[0], this.acInputVoltage[1]};
            double returnValue = this.linearDataFormat(temp);
            return returnValue;
        }

        public double getACInputCurrent() {
            byte[] temp = new byte[]{this.acInputCurrent[0], this.acInputCurrent[1]};
            double returnValue = this.linearDataFormat(temp);
            return returnValue;
        }

        public double getDC12VOutputVoltage() {
            byte[] temp = new byte[]{this.dc12VOutputVoltage[0], this.dc12VOutputVoltage[1]};
            double returnValue = 0.0;
            if (this.VOUT_MODE == 0) {
                returnValue = this.linearDataFormat(temp);
            } else {
                double factor = (this.VOUT_MODE & 0x10) == 16 ? Math.pow(2.0, (byte)(this.VOUT_MODE | 0xE0)) : Math.pow(2.0, this.VOUT_MODE & 0x1F);
                int reading = ByteUtility.twoBytesToIntLSB(temp);
                returnValue = (double)reading * factor;
            }
            return returnValue;
        }

        public double getDC12VOutputCurrent() {
            byte[] temp = new byte[]{this.dc12VOutputCurrent[0], this.dc12VOutputCurrent[1]};
            double returnValue = this.linearDataFormat(temp);
            return returnValue;
        }

        public int getTemperature1() {
            byte[] temp = new byte[]{this.temperature1[0], this.temperature1[1]};
            int reading = (int)this.linearDataFormat(temp);
            return reading;
        }

        public int getTemperature2() {
            byte[] temp = new byte[]{this.temperature2[0], this.temperature2[1]};
            int reading = (int)this.linearDataFormat(temp);
            return reading;
        }

        public double getFan1() {
            byte[] temp = new byte[]{this.fan1[0], this.fan1[1]};
            double returnValue = 0.0;
            if (this.isSMCOldPower()) {
                temp[1] = (byte)(temp[1] & 0x3F);
                int reading = ByteUtility.twoBytesToIntLSB(temp);
                returnValue = (double)(reading * 30) / 0.262;
            } else {
                returnValue = this.linearDataFormat(temp);
            }
            return returnValue;
        }

        public double getFan2() {
            byte[] temp = new byte[]{this.fan2[0], this.fan2[1]};
            double returnValue = 0.0;
            if (this.isSMCOldPower()) {
                temp[1] = (byte)(temp[1] & 0x3F);
                int reading = ByteUtility.twoBytesToIntLSB(temp);
                returnValue = (double)(reading * 30) / 0.262;
            } else {
                returnValue = this.linearDataFormat(temp);
            }
            return returnValue;
        }

        public int getDC12VOutputPower() {
            byte[] temp = new byte[]{this.dc12VOutputPower[0], this.dc12VOutputPower[1]};
            int reading = (int)this.unsignedLinearDataFormat(temp);
            return reading;
        }

        public int getACInputPower() {
            byte[] temp = new byte[]{this.acInputPower[0], this.acInputPower[1]};
            int reading = (int)this.unsignedLinearDataFormat(temp);
            return reading;
        }

        public String getPMBusRevision() {
            return "0x" + ByteUtility.byteToHex(this.pmBusRevision[0]);
        }

        public String getPWSSerialNumber() {
            return new String(this.pwsSerialNumber).trim();
        }

        public String getPWSModuleNumber() {
            return new String(this.pwsModuleNumber).trim();
        }

        public String getPWSRevision() {
            return new String(this.pwsRevision).trim();
        }

        public String getStatus() {
            String str = "";
            str = this.checkNoneStandardSMCPowerSupplies() ? this.getStatus_old_PS() : (IPMII2CPMBusCommand.this.isB0Addr() ? this.getStatus_B0Addr_PM1_2() : this.getStatus_PM1_2());
            return str;
        }

        public boolean getSimpleStatus() {
            if (this.checkNoneStandardSMCPowerSupplies()) {
                return (this.statusByte & 1) == 1;
            }
            if (IPMII2CPMBusCommand.this.isB0Addr()) {
                if ((this.statusByte & 0x40) == 64) {
                    return false;
                }
                return this.isStatusOK(this.statusManager.getStatusDescription(true));
            }
            if ((this.statusByte & 0x40) == 64) {
                return false;
            }
            return this.isStatusOK(this.statusManager.getStatusDescription(true));
        }

        public boolean checkNoneStandardSMCPowerSupplies() {
            if (!this.isPwsModuleNumber) {
                return false;
            }
            String model = this.getPWSModuleNumber();
            for (int i = 0; i < IPMII2CPMBusCommand.this.noneStandardSMCPowerSupplies.length; ++i) {
                if (model.indexOf(IPMII2CPMBusCommand.this.noneStandardSMCPowerSupplies[i]) == -1) continue;
                return !model.endsWith("2");
            }
            return false;
        }

        public String getStatus_B0Addr_PM1_2() {
            String str = "";
            if ((this.statusHighByte & 8) != 8) {
                str = str + "OK";
                return str;
            }
            str = str + "[OFF]";
            str = str + " (" + ByteUtility.byteToHex(this.statusHighByte) + " " + ByteUtility.byteToHex(this.statusByte) + ")";
            return str;
        }

        public String getStatus_PM1_2() {
            String str = "";
            if ((this.statusByte & 1) == 1) {
                str = str + "OK";
                return str;
            }
            if ((this.statusByte & 2) == 2 && (this.statusByte & 0x40) != 64) {
                str = str + "OK";
                return str;
            }
            if ((this.statusByte & 4) == 4) {
                str = str + "[TEMPERATURE FAULT OR WARNING]";
            }
            if ((this.statusByte & 8) == 8) {
                str = str + "[VIN_UV_FAULT]";
            }
            if ((this.statusByte & 0x10) == 16) {
                str = str + "[IOUT_OC_FAULT]";
            }
            if ((this.statusByte & 0x20) == 32) {
                str = str + "[VOUT_OV_FAULT]";
            }
            if ((this.statusByte & 0x40) == 64) {
                str = str + "[UNIT IS OFF]";
            }
            if ((this.statusByte & 0x80) == 128) {
                str = str + "[UNIT WAS BUSY]";
            }
            if (this.statusByte == 0) {
                str = str + "OK";
                return str;
            }
            str = str + " (" + ByteUtility.byteToHex(this.statusByte) + "h)";
            return str;
        }

        public String getStatus_old_PS() {
            String str = "";
            if ((this.statusByte & 1) == 1) {
                str = str + "OK";
                return str;
            }
            if ((this.statusByte & 2) == 2) {
                str = str + "[Over Temperature Fault]";
            }
            if ((this.statusByte & 4) == 4) {
                str = str + "[Under Voltage Fault]";
            }
            if ((this.statusByte & 8) == 8) {
                str = str + "[Over Current Fault]";
            }
            if ((this.statusByte & 0x10) == 16) {
                str = str + "[Over Voltage Fault]";
            }
            if ((this.statusByte & 0x40) == 64) {
                str = str + "[UNIT IS OFF]";
            }
            str = str + " (" + ByteUtility.byteToHex(this.statusByte) + "h)";
            return str;
        }

        public boolean isDCInput() {
            return this.isInputType && ByteUtility.checkBit(this.inputType, 7) == 1 & ByteUtility.checkBit(this.inputType, 6) == 1 & ByteUtility.checkBit(this.inputType, 5) == 0;
        }

        public String toString() {
            String str = "";
            str = str + "VOUT_MODE = " + ByteUtility.byteToHex(this.VOUT_MODE) + "\n";
            str = str + "statusByte = " + ByteUtility.byteToHex(this.statusByte) + "\n";
            str = str + "acInputVoltage = " + ByteUtility.bytesToHex(this.acInputVoltage) + "\n";
            str = str + "acInputCurrent = " + ByteUtility.bytesToHex(this.acInputCurrent) + "\n";
            str = str + "dc12VOutputVoltage = " + ByteUtility.bytesToHex(this.dc12VOutputVoltage) + "\n";
            str = str + "dc12VOutputCurrent = " + ByteUtility.bytesToHex(this.dc12VOutputCurrent) + "\n";
            str = str + "temperature1 = " + ByteUtility.bytesToHex(this.temperature1) + "\n";
            str = str + "temperature2 = " + ByteUtility.bytesToHex(this.temperature2) + "\n";
            str = str + "fan1 = " + ByteUtility.bytesToHex(this.fan1) + "\n";
            str = str + "fan2 = " + ByteUtility.bytesToHex(this.fan2) + "\n";
            str = str + "dc12VOutputPower = " + ByteUtility.bytesToHex(this.dc12VOutputPower) + "\n";
            str = str + "acInputPower = " + ByteUtility.bytesToHex(this.acInputPower) + "\n";
            str = str + "pmBusRevision = " + ByteUtility.bytesToHex(this.pmBusRevision) + "\n";
            str = str + "pwsSerialNumber = " + ByteUtility.bytesToHex(this.pwsSerialNumber) + "\n";
            str = str + "-------------------------------------------------------------\n";
            str = str + "acInputVoltage(F) = " + this.getACInputVoltage() + "\n";
            str = str + "acInputCurrent(F) = " + this.getACInputCurrent() + "\n";
            str = str + "dc12vOutputVoltage(F) = " + this.getDC12VOutputVoltage() + "\n";
            str = str + "dc12vOutputCurrent(F) = " + this.getDC12VOutputCurrent() + "\n";
            str = str + "temperature1(F) = " + this.getTemperature1() + "\n";
            str = str + "temperature2(F) = " + this.getTemperature2() + "\n";
            str = str + "fan1(F) = " + this.getFan1() + "\n";
            str = str + "fan2(F) = " + this.getFan2() + "\n";
            str = str + "dc12VOutputPower(F) = " + this.getDC12VOutputPower() + "\n";
            str = str + "acInputPower(F) = " + this.getACInputPower() + "\n";
            str = str + "pmBusRevision(F) = " + this.getPMBusRevision() + "\n";
            str = str + "PWS Serial Number(F) = " + this.getPWSSerialNumber() + "\n";
            str = str + "PWS Module Number(F) = " + this.getPWSModuleNumber() + "\n";
            str = str + "PWS Revision(F) = " + this.getPWSRevision() + "\n";
            return str;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %30s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f = " %-30s | %30s \n";
            StringBuffer fStr = new StringBuffer();
            String inputTypeString = this.isDCInput() ? " (DC)" : "";
            fStr.append(String.format(f, "Status", this.isStatusByte ? this.getStatus() : "N/A"));
            fStr.append(String.format(f, "Input Voltage" + inputTypeString, this.isAcInputVoltage ? this.doubleToString(this.getACInputVoltage()) + " V" : "N/A"));
            fStr.append(String.format(f, "Input Current" + inputTypeString, this.isAcInputCurrent ? this.doubleToString(this.getACInputCurrent()) + " A" : "N/A"));
            fStr.append(String.format(f, "Main Output Voltage", this.isDc12VOutputVoltage ? this.doubleToString(this.getDC12VOutputVoltage()) + " V" : "N/A"));
            fStr.append(String.format(f, "Main Output Current", this.isDc12VOutputCurrent ? this.doubleToString(this.getDC12VOutputCurrent()) + " A" : "N/A"));
            fStr.append(String.format(f, "Temperature 1", this.isTemperature1 ? this.showCandF(this.getTemperature1()) : "N/A"));
            fStr.append(String.format(f, "Temperature 2", this.isTemperature2 ? this.showCandF(this.getTemperature2()) : "N/A"));
            fStr.append(String.format(f, "Fan 1", this.isFan1 ? "" + (int)this.getFan1() + " RPM" : "N/A"));
            if (this.isPwsModuleNumber && this.getPWSModuleNumber().indexOf("721") == -1) {
                fStr.append(String.format(f, "Fan 2", this.isFan2 ? "" + (int)this.getFan2() + " RPM" : "N/A"));
            }
            fStr.append(String.format(f, "Main Output Power", this.isDc12VOutputPower ? "" + this.getDC12VOutputPower() + " W" : "N/A"));
            fStr.append(String.format(f, "Input Power" + inputTypeString, this.isAcInputPower ? "" + this.getACInputPower() + " W" : "N/A"));
            fStr.append(String.format(f, "PMBus Revision", this.isPmBusRevision ? this.getPMBusRevision() : "N/A"));
            fStr.append(String.format(f, "PWS Serial Number", this.isPwsSerialNumber ? this.getPWSSerialNumber() : "N/A"));
            fStr.append(String.format(f, "PWS Module Number", this.isPwsModuleNumber ? this.getPWSModuleNumber() : "N/A"));
            fStr.append(String.format(f, "PWS Revision", this.isPwsRevision ? this.getPWSRevision() : "N/A"));
            if (IPMII2CPMBusCommand.this.isShowPWSFullStatus) {
                fStr.append(this.getStatusDescription(IPMII2CPMBusCommand.this.isSimpleStatus));
            }
            return fStr.toString();
        }

        public String uiGetStatus() {
            return this.isStatusByte ? this.getStatus() : "N/A";
        }

        public String uiGetACInputVoltage() {
            return this.isAcInputVoltage ? this.doubleToString(this.getACInputVoltage()) + " V" : "N/A";
        }

        public String uiGetACInputCurrent() {
            return this.isAcInputCurrent ? this.doubleToString(this.getACInputCurrent()) + " A" : "N/A";
        }

        public String uiGetDC12VOutputVoltage() {
            return this.isDc12VOutputVoltage ? this.doubleToString(this.getDC12VOutputVoltage()) + " V" : "N/A";
        }

        public String uiGetDC12VOutputCurrent() {
            return this.isDc12VOutputCurrent ? this.doubleToString(this.getDC12VOutputCurrent()) + " A" : "N/A";
        }

        public String uiGetTemperature1() {
            return this.isTemperature1 ? this.showCandF(this.getTemperature1()) : "N/A";
        }

        public String uiGetTemperature2() {
            return this.isTemperature2 ? this.showCandF(this.getTemperature2()) : "N/A";
        }

        public String uiGetFan1() {
            return this.isFan1 ? "" + (int)this.getFan1() + " RPM" : "N/A";
        }

        public String uiGetFan2() {
            return this.isFan2 ? "" + (int)this.getFan2() + " RPM" : "N/A";
        }

        public String uiGetDC12VOutputPower() {
            return this.isDc12VOutputPower ? "" + this.getDC12VOutputPower() + " W" : "N/A";
        }

        public String uiGetACInputPower() {
            return this.isAcInputPower ? "" + this.getACInputPower() + " W" : "N/A";
        }

        public String uiGetPMBusRevision() {
            return this.isPmBusRevision ? this.getPMBusRevision() : "N/A";
        }

        public String uiGetPWSSerialNumber() {
            return this.isPwsSerialNumber ? this.getPWSSerialNumber() : "N/A";
        }

        public String uiGetPWSModuleNumber() {
            return this.isPwsModuleNumber ? this.getPWSModuleNumber() : "N/A";
        }

        public String uiGetPWSRevision() {
            return this.isPwsRevision ? this.getPWSRevision() : "N/A";
        }

        public String showCandF(int c) {
            if (c == 0) {
                return "N/A";
            }
            long f = Math.round(1.8 * (double)c + 32.0);
            return c + "C/" + f + "F";
        }

        public String doubleToString(double value) {
            int temp = (int)(value * 100.0);
            double d = (double)temp / 100.0;
            return "" + d;
        }

        public double linearDataFormat(byte[] temp) {
            double factor = 0.0;
            factor = (temp[1] & 0x80) == 128 ? Math.pow(2.0, (byte)(temp[1] >> 3 | 0xE0)) : Math.pow(2.0, temp[1] >> 3);
            temp[1] = (byte)(temp[1] & 7);
            int reading = ByteUtility.twoBytesToIntLSB(temp);
            if (reading >= 1024) {
                reading -= 2048;
            }
            double returnValue = (double)reading * factor;
            return returnValue;
        }

        public double unsignedLinearDataFormat(byte[] temp) {
            double factor = 0.0;
            factor = (temp[1] & 0x80) == 128 ? Math.pow(2.0, (byte)(temp[1] >> 3 | 0xE0)) : Math.pow(2.0, temp[1] >> 3);
            temp[1] = (byte)(temp[1] & 7);
            int reading = ByteUtility.twoBytesToIntLSB(temp);
            double returnValue = (double)reading * factor;
            return returnValue;
        }

        public boolean isSMCOldPower() {
            if (!this.isPwsModuleNumber) {
                return false;
            }
            String moduleNumber = new String(this.pwsModuleNumber);
            return moduleNumber.indexOf("721") != -1;
        }

        public byte getStatusDetailByte(byte readCount, byte cmdCode, int returnIndex) throws Exception {
            return IPMII2CPMBusCommand.this.getStatusDetail(readCount, cmdCode, returnIndex);
        }

        public String getStatusDescription(boolean isSimple) {
            Map<String, Map<Integer, String>> statusMsgs = this.statusManager.getStatusDescription(isSimple);
            String f = " %-30s | %30s \n";
            StringBuffer fStr = new StringBuffer();
            if (this.isStatusOK(statusMsgs)) {
                fStr.append(String.format(f, "Status", "OK"));
            } else {
                for (String key : statusMsgs.keySet()) {
                    for (String msg : statusMsgs.get(key).values()) {
                        fStr.append(String.format(f, key, msg));
                    }
                }
            }
            return fStr.toString();
        }

        private boolean isStatusOK(Map<String, Map<Integer, String>> statusMsgs) {
            if (statusMsgs == null || statusMsgs.isEmpty()) {
                return true;
            }
            if (statusMsgs.size() == 1 && statusMsgs.containsKey("Status CML")) {
                return true;
            }
            for (String key : statusMsgs.keySet()) {
                for (String msg : statusMsgs.get(key).values()) {
                    if (msg == null || msg.trim().equals("") || msg.isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public class FRUHealth {
        public byte statusByte;
        public byte temperature;
        public byte fan1;
        public byte fan2;
        public byte[] pwsSerialNumber;
        public byte[] pwsModuleNumber;
        public boolean isStatusByte;
        public boolean isTemperature;
        public boolean isFan1;
        public boolean isFan2;
        public boolean isPwsSerialNumber;
        public boolean isPwsModuleNumber;

        public byte getStatus() {
            return this.statusByte;
        }

        public byte getTemperature() {
            return this.temperature;
        }

        public double getFan1() {
            return 114.50381679389312 * (double)(this.fan1 & 0xFF);
        }

        public double getFan2() {
            return 114.50381679389312 * (double)(this.fan2 & 0xFF);
        }

        public String toString() {
            String str = "";
            str = str + "statusByte = " + ByteUtility.byteToHex(this.statusByte) + "\n";
            str = str + "temperature = " + ByteUtility.byteToHex(this.temperature) + "\n";
            str = str + "fan1 = " + ByteUtility.byteToHex(this.fan1) + "\n";
            str = str + "fan2 = " + ByteUtility.byteToHex(this.fan2) + "\n";
            str = str + "-------------------------------------------------------------\n";
            str = str + "statusByte(F) = " + (this.statusByte == 0 ? "off" : "on") + "\n";
            str = str + "temperature1(F) = " + this.getTemperature() + "\n";
            str = str + "fan1(F) = " + this.getFan1() + "\n";
            str = str + "fan2(F) = " + this.getFan2() + "\n";
            return str;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f = " %-30s | %20s \n";
            StringBuffer fStr = new StringBuffer();
            if (this.isStatusByte) {
                fStr.append(String.format(f, "Status", this.statusByte == 0 ? "Off" : "On"));
            } else {
                fStr.append(String.format(f, "Status", "N/A"));
            }
            fStr.append(String.format(f, "Temperature", this.statusByte == 0 ? "N/A" : this.showCandF(this.getTemperature())));
            fStr.append(String.format(f, "Fan 1", this.isFan1 ? "" + (int)this.getFan1() + " RPM" : "N/A"));
            if (this.getFan2() != 0.0) {
                fStr.append(String.format(f, "Fan 2", this.isFan2 ? "" + (int)this.getFan2() + " RPM" : "N/A"));
            }
            return fStr.toString();
        }

        public String uiGetTemperature() {
            return this.statusByte == 0 ? "N/A" : this.showCandF(this.getTemperature());
        }

        public String uiGetFan() {
            return this.isFan1 ? "" + (int)this.getFan1() + " RPM" : "N/A";
        }

        protected String showCandF(int c) {
            if (c == 0) {
                return "N/A";
            }
            long f = Math.round(1.8 * (double)c + 32.0);
            return c + "C/" + f + "F";
        }

        public String doubleToString(double value) {
            int temp = (int)(value * 100.0);
            double d = (double)temp / 100.0;
            return "" + d;
        }
    }

    public class BBPHealth {
        FRUInfo fruInfo;
        byte[] orgRaw;

        public void fromRaw(byte[] raw) {
            FRU_Internal.fixedInternalAreaSize = 16;
            this.fruInfo = FRUInfo.fromRaw(raw);
            FRU_Internal.fixedInternalAreaSize = 8;
            this.orgRaw = raw;
        }

        public byte getBatteryPackTemperature() {
            String product = this.getProductName();
            if (product.equals("PWS-1K01B-1R")) {
                return this.orgRaw[239];
            }
            return this.fruInfo.fru.internal.useData[0];
        }

        public String getBatteryPackTemperatureDisplay() {
            if (this.getBatteryPackTemperature() == 0 || this.getBatteryPackTemperature() < 0) {
                return "N/A";
            }
            return this.showCandF(this.getBatteryPackTemperature());
        }

        public byte getBatteryPowerStatus() {
            return this.fruInfo.fru.internal.useData[3];
        }

        public String getBatteryPowerStatusDisplay() {
            if ((this.getBatteryPowerStatus() & 1) == 1) {
                return "Normal";
            }
            return "Not Operational";
        }

        public byte getBatteryPackTemperatureLimit() {
            return this.fruInfo.fru.internal.useData[4];
        }

        public byte getFirmwareVersion() {
            return this.fruInfo.fru.internal.useData[13];
        }

        public String getFirmwareVersionDisplay() {
            if (this.getFirmwareVersion() < 32) {
                return "1.0";
            }
            String v = "" + (this.getFirmwareVersion() > 4) + "." + (this.getFirmwareVersion() & 0xF);
            return v;
        }

        public byte getFRUFileRevision() {
            return this.fruInfo.fru.internal.useData[14];
        }

        public String getProductManufacturer() {
            return new String(this.fruInfo.fru.product.productManufacturerName);
        }

        public String getProductName() {
            return new String(this.fruInfo.fru.product.productName);
        }

        public String getProductVersion() {
            return new String(this.fruInfo.fru.product.productVersion);
        }

        public String getProductSerialNumber() {
            return new String(this.fruInfo.fru.product.productSerialNumber);
        }

        public byte getRemainingRelativeBatteryEnergy() {
            return this.orgRaw[224];
        }

        public String getRemainingRelativeBatteryEnergyDisplay() {
            return this.getRemainingRelativeBatteryEnergy() + "%";
        }

        public int getBatteryVoltage() {
            byte[] b = new byte[]{this.orgRaw[225], this.orgRaw[226]};
            return ByteUtility.twoBytesToIntLSB(b);
        }

        public String getBatteryVoltageDisplay() {
            if (this.getBatteryVoltage() > 1000) {
                double v = (double)this.getBatteryVoltage() / 1000.0;
                return "" + this.doubleToString(v) + " V";
            }
            return "" + this.getBatteryVoltage() + " mV";
        }

        public int getBatteryCurrent() {
            byte[] b = new byte[]{this.orgRaw[227], this.orgRaw[228]};
            return ByteUtility.twoBytesToIntLSBSigned(b);
        }

        public String getBatteryCurrentDisplay() {
            if (this.getBatteryCurrent() > 100) {
                double v = (double)this.getBatteryCurrent() / 100.0;
                return "" + this.doubleToString(v) + " A";
            }
            if (this.getBatteryCurrent() < -100) {
                double v = (double)this.getBatteryCurrent() / 100.0;
                return "" + this.doubleToString(v) + " A";
            }
            return "" + this.getBatteryCurrent() * 10 + " mA";
        }

        public int getBatteryStatus() {
            byte[] b = new byte[]{this.orgRaw[229], this.orgRaw[230]};
            return ByteUtility.twoBytesToIntLSB(b);
        }

        public ArrayList getBatteryStatusDisplay() {
            int bitMask = 1;
            int status = this.getBatteryStatus();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 1; i <= 16; ++i) {
                String message;
                if ((status & bitMask) == bitMask && (message = this.getBatteryStatusDescription(bitMask)) != null) {
                    list.add(message);
                }
                bitMask = 1 << i;
            }
            return list;
        }

        public int getCycleCount() {
            byte[] b = new byte[]{this.orgRaw[231], this.orgRaw[232]};
            return ByteUtility.twoBytesToIntLSB(b);
        }

        public String getCycleCountDisplay() {
            if (this.getCycleCount() < 0) {
                return "0";
            }
            return "" + this.getCycleCount();
        }

        public byte getBatteryDischargeTimerResponse() {
            return this.orgRaw[233];
        }

        public byte getBatteryDischargeTimerCommand() {
            return this.orgRaw[234];
        }

        public String getBatteryDischargeSettingDisplay() {
            boolean isAutoDischarge = (byte)(this.getBatteryDischargeTimerCommand() & 0x80) == -128;
            int dischargeDay = this.getBatteryDischargeTimerCommand() & 0x3F;
            if (isAutoDischarge) {
                return "Auto (" + dischargeDay + " days)";
            }
            return "User";
        }

        public String getBatteryDischargeRemainingDaysDisplay() {
            boolean isAutoDischarge = (byte)(this.getBatteryDischargeTimerCommand() & 0x80) == -128;
            int remainingDay = this.getBatteryDischargeTimerResponse() & 0x3F;
            if (isAutoDischarge) {
                return remainingDay + " days";
            }
            return remainingDay + " days";
        }

        public String getBatteryDischargeStatusDisplay() {
            if ((byte)(this.getBatteryDischargeTimerResponse() & 0x80) == -128) {
                return "Discharging (auto)";
            }
            if ((byte)(this.getBatteryDischargeTimerResponse() & 0x40) == 64) {
                return "Discharging (user)";
            }
            return "None";
        }

        public byte getBoardTemperature() {
            return this.orgRaw[239];
        }

        public String getBoardTemperatureDisplay() {
            if (this.getBoardTemperature() == 0 || this.getBoardTemperature() < 0) {
                return "N/A";
            }
            return this.showCandF(this.getBoardTemperature());
        }

        public int getBatteryOutputWattage() {
            byte[] b = new byte[]{this.orgRaw[242], this.orgRaw[243]};
            return ByteUtility.twoBytesToIntLSB(b);
        }

        public String getBatteryOutputWattageDisplay() {
            return "" + this.getBatteryOutputWattage() + " W";
        }

        public String getBatteryStatusNumberDisplay() {
            return "0x" + ByteUtility.byteToHex(this.orgRaw[230]) + ByteUtility.byteToHex(this.orgRaw[229]);
        }

        public String getBatteryStatusDescriptionsDisplay() {
            String desc = "";
            ArrayList list = this.getBatteryStatusDisplay();
            if (list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    desc = desc + list.get(i);
                }
            } else {
                desc = desc + "None";
            }
            return desc;
        }

        public String getBatteryStatusDescription(int index) {
            switch (index) {
                case 16384: {
                    return "[TERMINATE CHARGE]";
                }
                case 4096: {
                    return "[OVER TEMP]";
                }
                case 2048: {
                    return "[TERMINATE DISCHARGE]";
                }
                case 512: {
                    return "[REMAINING CAPACITY]";
                }
                case 256: {
                    return "[REMAINING TIME]";
                }
                case 64: {
                    return "[DISCHARGING]";
                }
                case 32: {
                    return "[FULLY CHARGED]";
                }
                case 16: {
                    return "[FULLY DISCHARGED]";
                }
            }
            return null;
        }

        public String toString() {
            String str = "";
            return str;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f = " %-30s | %20s \n";
            StringBuffer fStr = new StringBuffer();
            fStr.append(String.format(f, "Manufacturer", this.getProductManufacturer()));
            fStr.append(String.format(f, "Model Name", this.getProductName()));
            fStr.append(String.format(f, "Serial Number", this.getProductSerialNumber()));
            fStr.append(String.format(f, "Product Version", this.getProductVersion()));
            fStr.append(String.format(f, "Firmware version", this.getFirmwareVersionDisplay()));
            fStr.append(String.format(f, "-----", ""));
            fStr.append(String.format(f, "Battery Voltage", this.getBatteryVoltageDisplay()));
            fStr.append(String.format(f, "Battery Current", this.getBatteryCurrentDisplay()));
            fStr.append(String.format(f, "Battery Pack Temp", this.getBatteryPackTemperatureDisplay()));
            if (this.getBoardTemperature() > 0 && !this.getProductName().equals("PWS-1K01B-1R")) {
                fStr.append(String.format(f, "Board Temp", this.getBoardTemperatureDisplay()));
            }
            fStr.append(String.format(f, "Power Wattage", this.getBatteryOutputWattageDisplay()));
            fStr.append(String.format(f, "Cycle Count", this.getCycleCountDisplay()));
            fStr.append(String.format(f, "-----", ""));
            fStr.append(String.format(f, "Battery Power Status", this.getBatteryPowerStatusDisplay()));
            fStr.append(String.format(f, "Remaining Energy", this.getRemainingRelativeBatteryEnergyDisplay()));
            fStr.append(String.format(f, "Discharge Status", this.getBatteryDischargeStatusDisplay()));
            fStr.append(String.format(f, "Discharge Setting", this.getBatteryDischargeSettingDisplay()));
            fStr.append(String.format(f, "Discharge Remaining Days", this.getBatteryDischargeRemainingDaysDisplay()));
            fStr.append(String.format(f, "Battery Status", this.getBatteryStatusNumberDisplay()));
            ArrayList list = this.getBatteryStatusDisplay();
            if (list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    fStr.append(String.format(f, "", list.get(i)));
                }
            } else {
                fStr.append(String.format(f, "", "None"));
            }
            return fStr.toString();
        }

        public String showCandF(int c) {
            if (c == 0) {
                return "N/A";
            }
            long f = Math.round(1.8 * (double)c + 32.0);
            return c + "C/" + f + "F";
        }

        public String doubleToString(double value) {
            int temp = (int)(value * 100.0);
            double d = (double)temp / 100.0;
            return "" + d;
        }
    }
}

