/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IIPMIMessage;

public class IPMIMessage
implements IIPMIMessage {
    public static final byte REQUEST = 0;
    public static final byte RESPONSE = 1;
    public byte rsSA = (byte)32;
    public byte netFnLun;
    public byte checkSum1;
    public byte rqSA = (byte)65;
    public byte rqSeqLun;
    public byte cmd;
    public byte[] data;
    public byte checkSum2;
    public byte completionCode = 0;
    public byte direction = 0;

    public void setRequest() {
        this.direction = 0;
    }

    public void setResponse() {
        this.direction = 1;
    }

    public void setCommandAndData(byte netFn, byte cmd, byte[] bytes) {
        this.setCommand(netFn, cmd);
        this.setData(bytes);
    }

    public void setCommandAndData(byte netFn, byte cmd, byte rqSa, byte[] bytes) {
        this.setCommand(netFn, cmd, rqSa);
        this.setData(bytes);
    }

    public void setCommand(byte netFn, byte cmd, byte rqSa) {
        this.netFnLun = netFn;
        this.checkSum1 = this.calcCheckSum1();
        this.rqSA = rqSa;
        this.rqSeqLun = 0;
        this.cmd = cmd;
    }

    public void setCommand(byte netFn, byte cmd) {
        this.netFnLun = netFn;
        this.checkSum1 = this.calcCheckSum1();
        this.rqSeqLun = 0;
        this.cmd = cmd;
    }

    public void setData(byte[] bytes) {
        this.data = bytes == null ? new byte[0] : bytes;
        this.checkSum2 = this.calcCheckSum2();
    }

    public byte calcCheckSum1() {
        byte value = 0;
        if (this.direction == 0) {
            value = (byte)(256 - (this.rsSA + this.netFnLun));
        } else if (this.direction == 1) {
            value = (byte)(256 - (this.rqSA + this.netFnLun));
        }
        return value;
    }

    public byte calcCheckSum2() {
        byte csum = 0;
        if (this.direction == 0) {
            csum = (byte)(this.rqSA + this.rqSeqLun + this.cmd);
        } else if (this.direction == 1) {
            csum = (byte)(this.rsSA + this.rqSeqLun + this.cmd + this.completionCode);
        }
        for (int i = 0; i < this.data.length; ++i) {
            csum = (byte)(csum + this.data[i]);
        }
        return -csum;
    }

    public int size() {
        int size = 0;
        if (this.direction == 0) {
            size = 7 + this.data.length;
        } else if (this.direction == 1) {
            size = 8 + this.data.length;
        }
        return size;
    }

    @Override
    public byte[] raw() {
        byte[] bytes = new byte[this.size()];
        if (this.direction == 0) {
            bytes[0] = this.rsSA;
            bytes[1] = this.netFnLun;
            bytes[2] = this.checkSum1;
            bytes[3] = this.rqSA;
            bytes[4] = this.rqSeqLun;
            bytes[5] = this.cmd;
            System.arraycopy(this.data, 0, bytes, 6, this.data.length);
            bytes[this.size() - 1] = this.checkSum2;
        } else if (this.direction == 1) {
            bytes[0] = this.rqSA;
            bytes[1] = this.netFnLun;
            bytes[2] = this.checkSum1;
            bytes[3] = this.rsSA;
            bytes[4] = this.rqSeqLun;
            bytes[5] = this.cmd;
            bytes[6] = this.completionCode;
            System.arraycopy(this.data, 0, bytes, 7, this.data.length);
            bytes[this.size() - 1] = this.checkSum2;
        }
        return bytes;
    }

    @Override
    public byte[] humanReadRaw() {
        byte[] raw = new byte[]{};
        if (this.direction == 0) {
            raw = new byte[2 + this.data.length];
            raw[0] = (byte)((this.netFnLun & 0xFF) >> 2);
            raw[1] = this.cmd;
            System.arraycopy(this.data, 0, raw, 2, this.data.length);
        } else if (this.direction == 1) {
            raw = new byte[1 + this.data.length];
            raw[0] = this.completionCode;
            System.arraycopy(this.data, 0, raw, 1, this.data.length);
        }
        return raw;
    }

    public static IPMIMessage fromRaw(byte[] bytes) {
        IPMIMessage msg = new IPMIMessage();
        msg.direction = 1;
        msg.rqSA = bytes[0];
        msg.netFnLun = bytes[1];
        msg.checkSum1 = bytes[2];
        msg.rsSA = bytes[3];
        msg.rqSeqLun = bytes[4];
        msg.cmd = bytes[5];
        msg.completionCode = bytes[6];
        msg.data = new byte[bytes.length >= 8 ? bytes.length - 8 : 0];
        System.arraycopy(bytes, 7, msg.data, 0, msg.data.length);
        msg.checkSum2 = bytes[bytes.length - 1];
        return msg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.direction == 0) {
            sb.append("===================\n");
            sb.append("Direction = Request\n");
            sb.append("rsSA      = " + ByteUtility.byteToHex(this.rsSA) + "\n");
            sb.append("netFnLun  = " + ByteUtility.byteToHex(this.netFnLun) + "\n");
            sb.append("checkSum1 = " + ByteUtility.byteToHex(this.checkSum1) + "\n");
            sb.append("rqSA      = " + ByteUtility.byteToHex(this.rqSA) + "\n");
            sb.append("rqSeqLun  = " + ByteUtility.byteToHex(this.rqSeqLun) + "\n");
            sb.append("cmd       = " + ByteUtility.byteToHex(this.cmd) + "\n");
            sb.append("data      = " + ByteUtility.bytesToHex(this.data) + "\n");
            sb.append("checkSum2 = " + ByteUtility.byteToHex(this.checkSum2) + "\n");
            sb.append("Msg Size  = " + this.size() + "(int)\n");
            sb.append("To Array  = " + ByteUtility.bytesToHex(this.raw()) + "\n");
            sb.append("===================\n");
        } else if (this.direction == 1) {
            sb.append("====================\n");
            sb.append("Direction = Response\n");
            sb.append("rqSA           = " + ByteUtility.byteToHex(this.rqSA) + "\n");
            sb.append("netFnLun       = " + ByteUtility.byteToHex(this.netFnLun) + "\n");
            sb.append("checkSum1      = " + ByteUtility.byteToHex(this.checkSum1) + "\n");
            sb.append("rsSA           = " + ByteUtility.byteToHex(this.rsSA) + "\n");
            sb.append("rqSeqLun       = " + ByteUtility.byteToHex(this.rqSeqLun) + "\n");
            sb.append("cmd            = " + ByteUtility.byteToHex(this.cmd) + "\n");
            sb.append("completionCode = " + ByteUtility.byteToHex(this.completionCode) + "\n");
            sb.append("data           = " + ByteUtility.bytesToHex(this.data) + "\n");
            sb.append("checkSum2      = " + ByteUtility.byteToHex(this.checkSum2) + "\n");
            sb.append("Msg Size       = " + this.size() + "(int)\n");
            sb.append("To Array       = " + ByteUtility.bytesToHex(this.raw()) + "\n");
            sb.append("===================\n");
        } else {
            sb.append("direction = none define\n");
        }
        return sb.toString();
    }

    public void printCompletionCode() {
        System.out.println("Completion code = " + ByteUtility.byteToHex(this.completionCode) + "h");
    }

    public void printData() {
        System.out.println("Data = " + ByteUtility.bytesToHex(this.data));
    }

    public static void main(String[] args) {
        IPMIMessage msg = new IPMIMessage();
        msg.setRequest();
        byte[] data = new byte[]{4};
        msg.setCommandAndData((byte)24, (byte)59, (byte)65, data);
        System.out.println(msg.toString());
        byte[] raw = new byte[]{65, 28, -93, 32, 0, 59, 0, 4, -95};
        msg = IPMIMessage.fromRaw(raw);
        System.out.println("Raw Data =" + ByteUtility.bytesToHex(raw));
        System.out.println(msg.toString());
        System.out.println("calculate checksum1 and checksum2");
        System.out.println("msg.checkSum1 =" + ByteUtility.byteToHex(msg.calcCheckSum1()));
        System.out.println("msg.checkSum2 =" + ByteUtility.byteToHex(msg.calcCheckSum2()));
    }
}

