/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIOEMCommand;
import java.util.ArrayList;

public class IPMINVMECommand
extends IPMICommand {
    int aocSize = 2;
    int slotSize = 12;
    int groupSize = 4;
    boolean groupingWithCPU = false;

    public IPMINVMECommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getPCIeSSDParameterCommand(byte aoc, byte slot, byte action, byte group) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{108, 0, aoc, slot, action, group, 0, 114};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPCIeSSDParameterCommand(byte aoc, byte slot, byte action, byte group) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{108, 1, aoc, slot, action, group};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getEjectFlagCommand(byte aoc, byte group) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{108, 0, aoc, 0, 2, group};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNVMEVPDCommand(byte opcode, byte device, byte group, byte slot) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-43, 1, opcode, device, group, slot};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setFWUploadArgumentCommand(byte device, byte group, byte slot, byte controller) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-43, 1, -60, device, group, slot, controller};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFWUploadStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-127, 6};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage commitFWUpdateCommand(byte device, byte group, byte slot, byte controller) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[23];
        data[0] = -43;
        data[1] = 2;
        data[2] = 16;
        data[3] = device;
        data[4] = group;
        data[5] = slot;
        data[6] = controller;
        for (int i = 7; i < 23; ++i) {
            data[i] = i == 19 ? 10 : 0;
        }
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public byte[] getNVMeSubsystemHealth(byte device, byte group, byte slot) throws IPMIException {
        IPMIMessage resMessage = this.getNVMEVPDCommand((byte)1, device, group, slot);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getNVMEVPDCommand failed");
    }

    public boolean assignVPDparameters(byte device, byte group, byte slot) throws IPMIException {
        IPMIMessage resMessage = this.getNVMEVPDCommand((byte)-63, device, group, slot);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getNVMEVPDCommand failed");
    }

    public byte[] getControllerHealth(byte device, byte group, byte slot) throws IPMIException {
        IPMIMessage resMessage = this.getNVMEVPDCommand((byte)2, device, group, slot);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getNVMEVPDCommand failed");
    }

    public boolean setFWUploadArgument(byte device, byte group, byte slot, byte controller) {
        IPMIMessage resMessage = this.setFWUploadArgumentCommand(device, group, slot, controller);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public byte getFWUploadStatus() throws IPMIException {
        IPMIMessage resMessage = this.getFWUploadStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getFWUploadStatusCommand failed");
    }

    public boolean commitFWUpdate(byte device, byte group, byte slot, byte controller) throws IPMIException {
        IPMIMessage resMessage = this.commitFWUpdateCommand(device, group, slot, controller);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call commitFWUpdate failed");
    }

    public byte[] getEjectFlagArray(byte aoc, byte group) throws IPMIException {
        IPMIMessage resMessage = this.getEjectFlagCommand(aoc, group);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getEjectFlagCommand failed (NVME)");
    }

    public byte[] getNVMEAOCMetaData(byte aoc, byte group) throws IPMIException {
        IPMIMessage resMessage = this.getPCIeSSDParameterCommand(aoc, (byte)0, (byte)0, group);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getPCIeSSDParameterCommand failed (NVME)");
    }

    public byte[] getNVMERaw(byte aoc, byte slot, byte group) throws IPMIException {
        IPMIMessage resMessage = this.getPCIeSSDParameterCommand(aoc, slot, (byte)1, group);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getPCIeSSDParameterCommand failed (NVME)");
    }

    public byte[] setLocate(byte aoc, byte slot, byte action, byte group) throws IPMIException {
        IPMIMessage resMessage = this.setPCIeSSDParameterCommand(aoc, slot, action, group);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setPCIeSSDParameterCommand failed (NVME)");
    }

    public boolean isEjected(int slot, byte[] ejectArray, boolean nonGroup) {
        long ejectStatus = 0L;
        if (!nonGroup) {
            if (ejectArray.length <= 8) {
                ejectStatus = ByteUtility.twoBytesToIntLSB(ejectArray, 4);
            } else {
                byte[] temp = new byte[]{ejectArray[4], ejectArray[5], ejectArray[12], ejectArray[13]};
                ejectStatus = ByteUtility.fourBytesToLongByLSBFirst(temp);
            }
        } else {
            byte[] temp = new byte[8];
            System.arraycopy(ejectArray, 18, temp, 0, temp.length);
            ejectStatus = ByteUtility.eightBytesToLongByLSBFirst(temp);
        }
        return (ejectStatus & (long)(1 << slot)) >= 1L;
    }

    public byte getNVMEVPDWriteStatus() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = -43;
        data[1] = 1;
        data[2] = -61;
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getNVMEVPDWriteStatusCommand failed (NVME)");
    }

    public byte[] getDropGroupStatus() throws IPMIException {
        IPMIMessage resMessage = this.getPCIeSSDParameterCommand((byte)0, (byte)0, (byte)3, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setPCIeSSDParameterCommand failed (NVME)");
    }

    public ArrayList<NVMEAOCInfo> getAll() throws IPMIException {
        int maxSlot;
        byte[] aocRaw;
        ArrayList<NVMEAOCInfo> nvmeAOCInfos = new ArrayList<NVMEAOCInfo>();
        boolean isdropGroup = false;
        try {
            aocRaw = this.getNVMEAOCMetaData((byte)0, (byte)0);
            NVMEAOCInfo nvmeAOCInfo = new NVMEAOCInfo();
            nvmeAOCInfo.fromRaw((byte)0, aocRaw);
            if (aocRaw != null && aocRaw.length < 18) {
                maxSlot = 12;
            } else if (nvmeAOCInfo.firmwareInfo[0] == 61 && nvmeAOCInfo.firmwareInfo[1] == 0 || nvmeAOCInfo.firmwareInfo[0] == 62 && nvmeAOCInfo.firmwareInfo[1] == 0 || nvmeAOCInfo.firmwareInfo[0] == 84 && nvmeAOCInfo.firmwareInfo[1] == 16 || nvmeAOCInfo.firmwareInfo[0] == 48 && nvmeAOCInfo.firmwareInfo[1] == 2 || nvmeAOCInfo.firmwareInfo[0] == 48 && nvmeAOCInfo.firmwareInfo[1] == 21) {
                maxSlot = 24;
            } else if (nvmeAOCInfo.firmwareInfo[0] == 19 && nvmeAOCInfo.firmwareInfo[1] == 4) {
                maxSlot = 8;
                this.aocSize = 4;
            } else {
                maxSlot = this.slotSize;
            }
        }
        catch (Exception e) {
            return null;
        }
        byte[] dropGroupStatus = null;
        try {
            dropGroupStatus = this.getDropGroupStatus();
            if (dropGroupStatus[0] == 1) {
                maxSlot = dropGroupStatus[1];
                isdropGroup = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiOEMCommand.setIPMIInterface(this.ipmiInterface);
        byte[] productID = ipmiOEMCommand.getProductID();
        if (IPMIOEMCommand.getBoardModel(productID).contains("X11OP")) {
            this.groupingWithCPU = true;
            this.aocSize = 1;
            this.groupSize = 8;
            this.slotSize = 4;
        } else if (IPMIOEMCommand.getBoardModel(productID).contains("H12SSW-iNR")) {
            maxSlot = 12;
        }
        if (isdropGroup) {
            NVMEAOCInfo nvmeAOCInfo = new NVMEAOCInfo();
            nvmeAOCInfo.fromRaw((byte)0, aocRaw);
            AOCGroupInfo aocGroupInfo = new AOCGroupInfo();
            try {
                byte[] raw = this.getNVMEAOCMetaData((byte)-1, (byte)-1);
                aocGroupInfo.fromRawNoGroup(dropGroupStatus);
                aocGroupInfo.group = 0;
                nvmeAOCInfo.aocGroups.add(aocGroupInfo);
            }
            catch (IPMIException raw) {
                // empty catch block
            }
            for (int j = 0; j < maxSlot; ++j) {
                try {
                    byte[] nvmeRaw = this.getNVMERaw((byte)-1, (byte)j, (byte)-1);
                    aocGroupInfo.addVDP((byte)j, nvmeRaw);
                    continue;
                }
                catch (IPMIException e) {
                    // empty catch block
                }
            }
            nvmeAOCInfos.add(nvmeAOCInfo);
        } else {
            for (int i = 0; i < this.aocSize; ++i) {
                byte[] raw = this.getNVMEAOCMetaData((byte)i, (byte)0);
                if (!this.checkIfCardPresentedFromRawData(raw)) continue;
                NVMEAOCInfo nvmeAOCInfo = new NVMEAOCInfo();
                nvmeAOCInfo.fromRaw((byte)i, raw);
                for (int k = 0; k < this.groupSize; ++k) {
                    try {
                        raw = this.getNVMEAOCMetaData((byte)i, (byte)k);
                    }
                    catch (IPMIException e) {
                        continue;
                    }
                    AOCGroupInfo aocGroupInfo = new AOCGroupInfo();
                    aocGroupInfo.slotPerGroup = maxSlot;
                    aocGroupInfo.fromRaw(raw);
                    aocGroupInfo.group = (byte)k;
                    nvmeAOCInfo.aocGroups.add(aocGroupInfo);
                    for (int j = 0; j < maxSlot; ++j) {
                        try {
                            byte[] nvmeRaw = this.getNVMERaw((byte)i, (byte)j, (byte)k);
                            aocGroupInfo.addVDP((byte)j, nvmeRaw);
                            continue;
                        }
                        catch (IPMIException e) {
                            // empty catch block
                        }
                    }
                }
                nvmeAOCInfos.add(nvmeAOCInfo);
            }
        }
        return nvmeAOCInfos;
    }

    private boolean checkIfCardPresentedFromRawData(byte[] raw) {
        return raw[1] == 1;
    }

    public boolean isGroupingWithCPU() {
        return this.groupingWithCPU;
    }

    public class VPD {
        byte group;
        byte slot;
        int slotPerGroup;
        long locateStatus;
        long ssdPresentStatus;
        byte totalDataLength;
        byte data2;
        byte[] classCode = new byte[3];
        byte[] id = new byte[2];
        byte[] serialNumber = new byte[20];
        byte[] modelNumber = new byte[40];
        byte pciePort0MaxLinkSpeed;
        byte pciePort0MaxLinkWidth;
        byte pciePort1MaxLinkSpeed;
        byte pciePort1MaxLinkWidth;
        byte iniPower;
        byte maxPower;
        byte ssdTemp;
        byte[] capListPointer = new byte[2];

        public boolean isPresented() {
            return (this.ssdPresentStatus & (long)(1 << this.slot)) >= 1L;
        }

        public boolean isLocated() {
            return (this.locateStatus & (long)(1 << this.slot)) >= 1L;
        }

        public String indexLinkSpeed(byte index) {
            if (index == 1) {
                return "2.5 GT/s";
            }
            if (index == 2) {
                return "5.0 GT/s";
            }
            if (index == 3) {
                return "8.0 GT/s";
            }
            if (index == 4) {
                return "16.0 GT/s";
            }
            if (index == 5) {
                return "32.0 GT/s";
            }
            return "N/A";
        }

        public String indexLinkSpeed_old(byte index) {
            int value = 0;
            for (int i = 7; i >= 0; --i) {
                if ((index & (byte)(1 << i)) <= 0) continue;
                value = (byte)(1 << i);
                break;
            }
            if (value == 1) {
                return "2.5 GT/s";
            }
            if (value == 2) {
                return "5.0 GT/s";
            }
            if (value == 4) {
                return "8.0 GT/s";
            }
            return "Unknown";
        }

        public String indexLinkWidth(byte index) {
            if (index == 1) {
                return "x1";
            }
            if (index == 2) {
                return "x2";
            }
            if (index == 4) {
                return "x4";
            }
            if (index == 8) {
                return "x8";
            }
            return "Unknown";
        }

        public void fromRaw(byte aSlot, long locateStatus, long ssdPresentStatus, int slotPerGroup, byte[] raw) {
            int index = 0;
            this.slot = aSlot;
            this.locateStatus = locateStatus;
            this.ssdPresentStatus = ssdPresentStatus;
            this.slotPerGroup = slotPerGroup;
            this.totalDataLength = raw[index];
            System.arraycopy(raw, ++index, this.classCode, 0, this.classCode.length);
            System.arraycopy(raw, index += this.classCode.length, this.id, 0, this.id.length);
            System.arraycopy(raw, index += this.id.length, this.serialNumber, 0, this.serialNumber.length);
            System.arraycopy(raw, index += this.serialNumber.length, this.modelNumber, 0, this.modelNumber.length);
            this.pciePort0MaxLinkSpeed = raw[index += this.modelNumber.length];
            this.pciePort0MaxLinkWidth = raw[++index];
            this.pciePort1MaxLinkSpeed = raw[++index];
            this.pciePort1MaxLinkWidth = raw[++index];
            this.iniPower = raw[++index];
            this.maxPower = raw[index += 3];
            System.arraycopy(raw, index += 3, this.capListPointer, 0, this.capListPointer.length);
            index += this.capListPointer.length;
            this.ssdTemp = raw[103];
            byte temp = this.id[0];
            this.id[0] = this.id[1];
            this.id[1] = temp;
        }

        public byte getSlot() {
            return this.slot;
        }

        public int getRealSlot() {
            return this.group * this.slotPerGroup + this.slot;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %25s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public byte[] getClassCode() {
            return this.classCode;
        }

        public byte[] getId() {
            return this.id;
        }

        public byte[] getSerialNumber() {
            return this.serialNumber;
        }

        public byte[] getModelNumber() {
            return this.modelNumber;
        }

        public byte getPciePort0MaxLinkSpeed() {
            return this.pciePort0MaxLinkSpeed;
        }

        public byte getPciePort0MaxLinkWidth() {
            return this.pciePort0MaxLinkWidth;
        }

        public byte getPciePort1MaxLinkSpeed() {
            return this.pciePort1MaxLinkSpeed;
        }

        public byte getPciePort1MaxLinkWidth() {
            return this.pciePort1MaxLinkWidth;
        }

        public byte getIniPower() {
            return this.iniPower;
        }

        public byte getMaxPower() {
            return this.maxPower;
        }

        public byte getSsdTemp() {
            return this.ssdTemp;
        }

        public String toFormatedString() {
            String f = " %-30s | %25s \n";
            StringBuffer fStr = new StringBuffer();
            if (IPMINVMECommand.this.groupingWithCPU) {
                fStr.append(String.format(f, "Slot", this.getSlot()));
            } else {
                fStr.append(String.format(f, "Slot", this.getRealSlot()));
            }
            fStr.append(String.format(f, "Located", this.isLocated() ? "Yes" : "No"));
            fStr.append(String.format(f, "OOB Temp.", this.ssdTemp + " C"));
            fStr.append(String.format(f, "Class Code", ByteUtility.bytesToHex(this.classCode).trim()));
            fStr.append(String.format(f, "ID", ByteUtility.bytesToHex(this.id).trim()));
            fStr.append(String.format(f, "Serial Number", new String(this.serialNumber).trim()));
            fStr.append(String.format(f, "Model Number", new String(this.modelNumber).trim()));
            fStr.append(String.format(f, "Port0 Max Link Speed", this.indexLinkSpeed(this.pciePort0MaxLinkSpeed)));
            fStr.append(String.format(f, "Port0 Max Link Width", this.indexLinkWidth(this.pciePort0MaxLinkWidth)));
            fStr.append(String.format(f, "Port1 Max Link Speed", this.indexLinkSpeed(this.pciePort1MaxLinkSpeed)));
            fStr.append(String.format(f, "Port1 Max Link Width", this.indexLinkWidth(this.pciePort1MaxLinkWidth)));
            fStr.append(String.format(f, "Init Power Requirement", this.iniPower + " Watts"));
            fStr.append(String.format(f, "Max  Power Requirement", this.maxPower + " Watts"));
            return fStr.toString();
        }
    }

    public class NVMEAOCInfo {
        public byte aoc;
        public byte i2c;
        public byte isCardPresented;
        public byte[] firmwareInfo = new byte[11];
        public ArrayList<AOCGroupInfo> aocGroups = new ArrayList();

        public boolean isCardPresented() {
            return this.isCardPresented > 0;
        }

        public void fromRaw(byte aoc, byte[] raw) {
            this.aoc = aoc;
            this.i2c = raw[0];
            this.isCardPresented = raw[1];
            System.arraycopy(raw, 6, this.firmwareInfo, 0, 11);
        }

        public String toString() {
            boolean nongroup = false;
            byte[] dropGroupStatus = null;
            try {
                dropGroupStatus = IPMINVMECommand.this.getDropGroupStatus();
                if (dropGroupStatus[0] == 1) {
                    nongroup = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String result = "";
            if (!nongroup) {
                result = IPMINVMECommand.this.groupingWithCPU ? result + "[Device Number:" + this.aoc + "] " : result + "[AOC Number:" + this.aoc + "] ";
            }
            result = result + "[Firmware Info:" + ByteUtility.byteToHex(this.firmwareInfo[0]) + " " + ByteUtility.byteToHex(this.firmwareInfo[1]) + "] ";
            result = result + "[Rev:" + ByteUtility.byteToHex(this.firmwareInfo[2]) + "]";
            for (int k = 0; k < this.aocGroups.size(); ++k) {
                boolean emptyData = true;
                ArrayList<VPD> vpds = this.aocGroups.get((int)k).vpds;
                for (int i = 0; i < vpds.size(); ++i) {
                    if (nongroup) {
                        if (!vpds.get(i).isPresented() || IPMINVMECommand.this.isEjected(vpds.get((int)i).slot, dropGroupStatus, nongroup)) continue;
                        result = result + "\n";
                        result = result + vpds.get(i).toFormatedHeader();
                        result = result + vpds.get(i).toFormatedString();
                        emptyData = false;
                        continue;
                    }
                    try {
                        byte[] raw = IPMINVMECommand.this.getEjectFlagArray(this.aoc, (byte)k);
                        if (!vpds.get(i).isPresented() || IPMINVMECommand.this.isEjected(vpds.get((int)i).slot, raw, nongroup)) continue;
                        result = result + "\n";
                        result = result + vpds.get(i).toFormatedHeader();
                        result = result + vpds.get(i).toFormatedString();
                        emptyData = false;
                        continue;
                    }
                    catch (IPMIException e) {
                        e.printStackTrace();
                    }
                }
                if (emptyData || nongroup) continue;
                result = IPMINVMECommand.this.groupingWithCPU ? result + "--------------------------End of CPU " + (k + 1) + "-------------------\n" : result + "--------------------------End of Group " + k + "-------------------\n";
            }
            return result;
        }
    }

    public class AOCGroupInfo {
        public int slotPerGroup = 24;
        public byte group;
        public long locateStatus;
        public long ssdPresentStatus;
        public ArrayList<VPD> vpds = new ArrayList();

        public void fromRaw(byte[] raw) {
            if (raw.length <= 17) {
                this.slotPerGroup = 12;
            }
            if (this.slotPerGroup == 12) {
                this.locateStatus = ByteUtility.twoBytesToIntLSB(raw, 2);
                this.ssdPresentStatus = ByteUtility.twoBytesToIntLSB(raw, 4);
            } else {
                byte[] temp = new byte[]{raw[2], raw[3], raw[17], raw[18]};
                this.locateStatus = ByteUtility.fourBytesToLongByLSBFirst(temp);
                temp[0] = raw[4];
                temp[1] = raw[5];
                temp[2] = raw[19];
                temp[3] = raw[20];
                this.ssdPresentStatus = ByteUtility.fourBytesToLongByLSBFirst(temp);
            }
        }

        public void fromRawNoGroup(byte[] raw) {
            this.slotPerGroup = raw[1];
            byte[] temp = new byte[8];
            System.arraycopy(raw, 2, temp, 0, 8);
            this.locateStatus = ByteUtility.eightBytesToLongByLSBFirst(temp);
            System.arraycopy(raw, 10, temp, 0, 8);
            this.ssdPresentStatus = ByteUtility.eightBytesToLongByLSBFirst(temp);
        }

        public void addVDP(byte slot, byte[] raw) {
            VPD vpd = new VPD();
            vpd.fromRaw(slot, this.locateStatus, this.ssdPresentStatus, this.slotPerGroup, raw);
            vpd.group = this.group;
            this.vpds.add(vpd);
        }

        public boolean isMatchSerialNumber(String serial) {
            String serial2 = new String(serial);
            for (int i = 0; i < this.vpds.size(); ++i) {
                String s;
                if (!this.vpds.get(i).isPresented()) continue;
                if (serial.charAt(0) == 'S' && serial.charAt(4) == 'N') {
                    char[] data = serial.toCharArray();
                    if (data[3] == '0') {
                        data[3] = 79;
                    }
                    serial = new String(data);
                }
                if (!(s = new String(this.vpds.get((int)i).serialNumber).trim()).equals(serial) && !s.equals(serial2)) continue;
                return true;
            }
            return false;
        }

        public VPD getMatchVPD(String serial) {
            String serial2 = new String(serial);
            for (int i = 0; i < this.vpds.size(); ++i) {
                String s;
                if (!this.vpds.get(i).isPresented()) continue;
                if (serial.charAt(0) == 'S' && serial.charAt(4) == 'N') {
                    char[] data = serial.toCharArray();
                    if (data[3] == '0') {
                        data[3] = 79;
                    }
                    serial = new String(data);
                }
                if (!(s = new String(this.vpds.get((int)i).serialNumber).trim()).equals(serial) && !s.equals(serial2)) continue;
                return this.vpds.get(i);
            }
            return null;
        }

        public int getOOBSlot(String serial) {
            String serial2 = new String(serial);
            for (int i = 0; i < this.vpds.size(); ++i) {
                String s;
                if (!this.vpds.get(i).isPresented()) continue;
                if (serial.charAt(0) == 'S' && serial.charAt(4) == 'N') {
                    char[] data = serial.toCharArray();
                    if (data[3] == '0') {
                        data[3] = 79;
                    }
                    serial = new String(data);
                }
                if (!(s = new String(this.vpds.get((int)i).serialNumber).trim()).equals(serial) && !s.equals(serial2)) continue;
                return i;
            }
            return -1;
        }
    }
}

