/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;

public class IPMITwinProCommand
extends IPMICommand {
    public static final int TWINPRO = 0;
    public static final int MICROCLOUD = 1;
    public static final int BIGTWIN = 2;
    public static final int FATTWIN = 3;
    public static final int H12SSG = 4;
    public static final int GRANDTWIN = 5;
    IPMIMessagingCommand ipmiMessageCommand;
    byte busID = (byte)7;
    byte slaveAddr80h = (byte)-128;
    byte slaveAddr82h = (byte)-126;
    byte slaveAddr84h = (byte)-124;
    byte slaveAddr86h = (byte)-122;
    int deviceType = 0;

    public IPMITwinProCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
    }

    @Override
    public void setIPMIInterface(IPMIInterface ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiMessageCommand.setIPMIInterface(ipmiInterface);
    }

    public byte[] sendTwinPro80hCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddr80h, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (TwinPro)");
    }

    public byte[] sendTwinPro82hCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddr82h, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (TwinPro)");
    }

    public byte[] sendTwinPro84hCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddr84h, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (TwinPro)");
    }

    public byte[] sendTwinPro86hCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddr86h, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (TwinPro)");
    }

    public boolean isSupportTwinProCommand() throws Exception {
        byte[] result;
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-3};
        try {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        }
        catch (Exception e) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        if (result[0] == -91) {
            this.deviceType = 0;
            return true;
        }
        if (result[0] == -89 || result[0] == -90 || result[0] == -88 || result[0] == -78) {
            this.deviceType = 2;
            return true;
        }
        if (result[0] == -79) {
            this.deviceType = 3;
            return true;
        }
        if (result[0] == -84) {
            this.deviceType = 1;
            return true;
        }
        if (result[0] == -64) {
            this.deviceType = 4;
            return true;
        }
        if (result[0] == -77) {
            this.deviceType = 5;
            return true;
        }
        return false;
    }

    public byte getNodeID() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{0};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result != null ? Byte.valueOf(result[0]) : null;
    }

    public int getNodePresent() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{1};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result != null ? ByteUtility.twoBytesToIntLSB(result) : 0;
    }

    public int getNodePSOn() throws Exception {
        byte readCount = 4;
        byte[] dataToWrite = new byte[]{17};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result != null ? ByteUtility.fourBytesToIntByLSBFirst(result) : 0;
    }

    public byte getNode12V() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{33};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result != null ? Byte.valueOf(result[0]) : null;
    }

    public byte[] getUserDefineSystemName() throws Exception {
        byte readCount = 20;
        byte[] dataToWrite = new byte[]{41};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getSystemPN() throws Exception {
        byte readCount = 24;
        byte[] dataToWrite = new byte[]{65};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getSystemSN() throws Exception {
        byte readCount = 24;
        byte[] dataToWrite = new byte[]{97};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getChassisPN() throws Exception {
        byte readCount = 24;
        byte[] dataToWrite = new byte[]{-127};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getChassisSN() throws Exception {
        byte readCount = 24;
        byte[] dataToWrite = new byte[]{-95};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getBackplanPN() throws Exception {
        byte readCount = 24;
        byte[] dataToWrite = new byte[]{-63};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getBackplanSN() throws Exception {
        byte readCount = 24;
        byte[] dataToWrite = new byte[]{-31};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getNodeIPv6IP(byte nodeIndex) throws Exception {
        byte readCount = 16;
        byte[] dataToWrite = new byte[]{(byte)(0 + nodeIndex * 64)};
        byte[] result = null;
        result = this.sendTwinPro84hCommand(readCount, dataToWrite);
        return result;
    }

    public void setGeneralValue(String value, int length, byte startAddress) throws Exception {
        byte[] valueBytes = value.getBytes();
        int copyLength = valueBytes.length >= length ? length : valueBytes.length;
        byte readCount = 0;
        byte[] dataToWrite = new byte[length + 1];
        dataToWrite[0] = startAddress;
        System.arraycopy(valueBytes, 0, dataToWrite, 1, copyLength);
        if (this.deviceType == 0) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{(byte)(startAddress - 1), (byte)(startAddress - 1)};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 2) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 3) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 1};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 4) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 11};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 5) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            Thread.sleep(1500L);
            byte[] dataToWrite2 = new byte[]{63, 10};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 1) {
            this.sendTwinPro86hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 0};
            this.sendTwinPro86hCommand(readCount, dataToWrite2);
        }
    }

    public void setUserDefineSystemName(String value) throws Exception {
        this.setGeneralValue(value, 20, (byte)41);
    }

    public void setSystemPN(String value) throws Exception {
        this.setGeneralValue(value, 24, (byte)65);
    }

    public void setSystemSN(String value) throws Exception {
        this.setGeneralValue(value, 24, (byte)97);
    }

    public void setChassisPN(String value) throws Exception {
        this.setGeneralValue(value, 24, (byte)-127);
    }

    public void setChassisSN(String value) throws Exception {
        this.setGeneralValue(value, 24, (byte)-95);
    }

    public void setBackplanePN(String value) throws Exception {
        this.setGeneralValue(value, 24, (byte)-63);
    }

    public void setBackplaneSN(String value) throws Exception {
        this.setGeneralValue(value, 24, (byte)-31);
    }

    public void setChassisLocation(byte[] chassisLocation) throws Exception {
        byte readCount = 0;
        byte[] dataToWrite = new byte[2];
        for (int i = 0; i < chassisLocation.length; ++i) {
            dataToWrite[0] = (byte)(-69 + (byte)i);
            dataToWrite[1] = chassisLocation[i];
            if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
                this.sendTwinPro80hCommand(readCount, dataToWrite);
                continue;
            }
            if (this.deviceType != 1) continue;
            this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
    }

    public byte[] getChassisLocation() throws Exception {
        byte readCount = 5;
        byte[] dataToWrite = new byte[]{-69};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte getBPLocation() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-5};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        } else {
            throw new Exception("Unknown device type");
        }
        return result[0];
    }

    public void setBPLocation(byte bpLocation) throws Exception {
        byte readCount = 0;
        byte[] dataToWrite = new byte[]{-5, bpLocation};
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
    }

    public byte getConfigID() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-4};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        } else {
            throw new Exception("Unknown device type");
        }
        return result[0];
    }

    public void setConfigID(int configID) throws Exception {
        byte readCount = 0;
        byte[] dataToWrite = new byte[]{-4, (byte)configID};
        if (this.deviceType == 0) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 3) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 1};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 2) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 11};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 4) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 11};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 5) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            Thread.sleep(1500L);
            byte[] dataToWrite2 = new byte[]{63, 10};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 1) {
            this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
    }

    public byte getBPNID() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{122};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result != null ? Byte.valueOf(result[0]) : null;
    }

    public byte[] getBPNRevision() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{123};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getNodePN(byte nodeIndex) throws Exception {
        byte readCount = 24;
        byte[] dataToWrite = new byte[]{(byte)(0 + nodeIndex * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] getNodePNbyPage(byte nodeIndex) throws Exception {
        byte readCount = 24;
        byte page = (byte)(nodeIndex / 4);
        byte[] dataToWrite = new byte[]{page, (byte)(0 + nodeIndex % 4 * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public void setNodePN(byte nodeIndex, String value) throws Exception {
        byte[] valueBytes = value.getBytes();
        int copyLength = valueBytes.length >= 24 ? 24 : valueBytes.length;
        byte readCount = 0;
        byte[] dataToWrite = new byte[25];
        dataToWrite[0] = (byte)(0 + nodeIndex * 64);
        System.arraycopy(valueBytes, 0, dataToWrite, 1, copyLength);
        this.sendTwinPro82hCommand(readCount, dataToWrite);
    }

    public void setNodePN(String value) throws Exception {
        byte[] valueBytes = value.getBytes();
        int copyLength = valueBytes.length >= 24 ? 24 : valueBytes.length;
        byte readCount = 0;
        byte[] dataToWrite = new byte[25];
        dataToWrite[0] = 0;
        System.arraycopy(valueBytes, 0, dataToWrite, 1, copyLength);
        this.sendTwinPro82hCommand(readCount, dataToWrite);
    }

    public byte[] getNodeSN(byte nodeIndex) throws Exception {
        byte readCount = 24;
        byte[] dataToWrite = new byte[]{(byte)(24 + nodeIndex * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] getNodeSNbyPage(byte nodeIndex) throws Exception {
        byte readCount = 24;
        byte page = (byte)(nodeIndex / 4);
        byte[] dataToWrite = new byte[]{page, (byte)(24 + nodeIndex % 4 * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public void setNodeSN(byte nodeIndex, String value) throws Exception {
        byte[] valueBytes = value.getBytes();
        int copyLength = valueBytes.length >= 24 ? 24 : valueBytes.length;
        byte readCount = 0;
        byte[] dataToWrite = new byte[25];
        dataToWrite[0] = (byte)(24 + nodeIndex * 64);
        System.arraycopy(valueBytes, 0, dataToWrite, 1, copyLength);
        this.sendTwinPro82hCommand(readCount, dataToWrite);
    }

    public void setNodeSN(String value) throws Exception {
        byte[] valueBytes = value.getBytes();
        int copyLength = valueBytes.length >= 24 ? 24 : valueBytes.length;
        byte readCount = 0;
        byte[] dataToWrite = new byte[25];
        dataToWrite[0] = 24;
        System.arraycopy(valueBytes, 0, dataToWrite, 1, copyLength);
        this.sendTwinPro82hCommand(readCount, dataToWrite);
    }

    public byte[] getNodeIP(byte nodeIndex) throws Exception {
        byte readCount = 4;
        byte[] dataToWrite = new byte[]{(byte)(48 + nodeIndex * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] getNodeIPbyPage(byte nodeIndex) throws Exception {
        byte readCount = 4;
        byte page = (byte)(nodeIndex / 4);
        byte[] dataToWrite = new byte[]{page, (byte)(48 + nodeIndex % 4 * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] getNodePower(byte nodeIndex) throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{(byte)(52 + nodeIndex * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] getNodePowerbyPage(byte nodeIndex) throws Exception {
        byte readCount = 2;
        byte page = (byte)(nodeIndex / 4);
        byte[] dataToWrite = new byte[]{page, (byte)(52 + nodeIndex % 4 * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] getNodeCurrent(byte nodeIndex) throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{(byte)(54 + nodeIndex * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] getNodeCurrentbyPage(byte nodeIndex) throws Exception {
        byte readCount = 2;
        byte page = (byte)(nodeIndex / 4);
        byte[] dataToWrite = new byte[]{page, (byte)(54 + nodeIndex % 4 * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result;
    }

    public byte getNodeCPU1Temp(byte nodeIndex) throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{(byte)(56 + nodeIndex * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte getNodeCPU1TempbyPage(byte nodeIndex) throws Exception {
        byte readCount = 1;
        byte page = (byte)(nodeIndex / 4);
        byte[] dataToWrite = new byte[]{page, (byte)(56 + nodeIndex % 4 * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte getNodeCPU2Temp(byte nodeIndex) throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{(byte)(57 + nodeIndex * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte getNodeCPU2TempbyPage(byte nodeIndex) throws Exception {
        byte readCount = 1;
        byte page = (byte)(nodeIndex / 4);
        byte[] dataToWrite = new byte[]{page, (byte)(57 + nodeIndex % 4 * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte getNodeSystemTemp(byte nodeIndex) throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{(byte)(58 + nodeIndex * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte getNodeSystemTempbyPage(byte nodeIndex) throws Exception {
        byte readCount = 1;
        byte page = (byte)(nodeIndex / 4);
        byte[] dataToWrite = new byte[]{page, (byte)(58 + nodeIndex % 4 * 64)};
        byte[] result = this.sendTwinPro82hCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte[] getChassisName() throws Exception {
        byte readCount = 20;
        byte[] dataToWrite = new byte[]{-31};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public void setChassisName(String name) throws Exception {
        byte[] nameBytes = name.getBytes();
        int copyLength = nameBytes.length >= 20 ? 20 : nameBytes.length;
        byte readCount = 0;
        byte[] dataToWrite = new byte[21];
        dataToWrite[0] = -31;
        System.arraycopy(nameBytes, 0, dataToWrite, 1, copyLength);
        if (this.deviceType == 0) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{-32, -32};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 2) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 11};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 3) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 1};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 4) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 11};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 5) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            Thread.sleep(1500L);
            byte[] dataToWrite2 = new byte[]{63, 10};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 1) {
            this.sendTwinPro86hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 0};
            this.sendTwinPro86hCommand(readCount, dataToWrite2);
        }
    }

    public byte[] getMCUVersion() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-2};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public byte[] getNodeSize() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-4};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public void setNodeSize(int size) throws Exception {
        byte readCount = 0;
        byte[] dataToWrite = new byte[]{-4, (byte)size};
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
    }

    public byte[] getBackPlaneModelNumber() throws Exception {
        byte readCount = 20;
        byte[] dataToWrite = new byte[]{41};
        byte[] result = null;
        if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
            result = this.sendTwinPro80hCommand(readCount, dataToWrite);
        } else if (this.deviceType == 1) {
            result = this.sendTwinPro86hCommand(readCount, dataToWrite);
        }
        return result;
    }

    public void setBackPlaneModelNumber(String value) throws Exception {
        byte[] valueBytes = value.getBytes();
        int copyLength = valueBytes.length >= 20 ? 20 : valueBytes.length;
        byte readCount = 0;
        byte[] dataToWrite = new byte[21];
        dataToWrite[0] = 41;
        System.arraycopy(valueBytes, 0, dataToWrite, 1, copyLength);
        if (this.deviceType == 0) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{40, 40};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 2) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 11};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 3) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 1};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 4) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 11};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 5) {
            this.sendTwinPro80hCommand(readCount, dataToWrite);
            Thread.sleep(1500L);
            byte[] dataToWrite2 = new byte[]{63, 10};
            this.sendTwinPro80hCommand(readCount, dataToWrite2);
        } else if (this.deviceType == 1) {
            this.sendTwinPro86hCommand(readCount, dataToWrite);
            byte[] dataToWrite2 = new byte[]{63, 0};
            this.sendTwinPro86hCommand(readCount, dataToWrite2);
        }
    }

    public TwinProMCU getTwinProMCU() throws Exception {
        byte configID;
        try {
            if (!this.isSupportTwinProCommand()) {
                throw new Exception("Not supported device");
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot get MCU Info");
        }
        try {
            configID = this.getConfigID();
        }
        catch (IPMIException e1) {
            throw new Exception("Cannot get config ID");
        }
        TwinProMCU twinProMCU = new TwinProMCU(configID);
        twinProMCU.nodeID = this.getNodeID();
        twinProMCU.present = this.getNodePresent();
        if (twinProMCU.nodeID > 1 && (twinProMCU.configID == 2 || twinProMCU.configID == 5 || twinProMCU.configID == 33)) {
            twinProMCU.nodeID = (byte)(twinProMCU.nodeID - 1);
        }
        twinProMCU.pson = this.getNodePSOn();
        if (twinProMCU.configID != 12) {
            twinProMCU.p12v = this.getNode12V();
        }
        twinProMCU.chassisLocation = this.getChassisLocation();
        twinProMCU.bpLocation = this.getBPLocation();
        twinProMCU.userDefineSystemName = this.getUserDefineSystemName();
        twinProMCU.systemPN = this.getSystemPN();
        twinProMCU.systemSN = this.getSystemSN();
        twinProMCU.chassisPN = this.getChassisPN();
        twinProMCU.chassisSN = this.getChassisSN();
        twinProMCU.backplanePN = this.getBackplanPN();
        twinProMCU.backplaneSN = this.getBackplanSN();
        twinProMCU.bpnID = this.getBPNID();
        twinProMCU.bpnRevision = this.getBPNRevision();
        for (int i = 0; i < twinProMCU.nodeSize; ++i) {
            int offset = i;
            if (i > 0 && (twinProMCU.configID == 2 || twinProMCU.configID == 5 || twinProMCU.configID == 33)) {
                ++offset;
            }
            if (this.deviceType == 0 || this.deviceType == 2 || this.deviceType == 3 || this.deviceType == 4 || this.deviceType == 5) {
                twinProMCU.nodePN[i] = this.getNodePN((byte)offset);
                twinProMCU.nodeSN[i] = this.getNodeSN((byte)offset);
                twinProMCU.ip[i] = this.getNodeIP((byte)offset);
                twinProMCU.power[i] = this.getNodePower((byte)offset);
                twinProMCU.current[i] = this.getNodeCurrent((byte)offset);
                twinProMCU.cpu1Temp[i] = this.getNodeCPU1Temp((byte)offset);
                twinProMCU.cpu2Temp[i] = this.getNodeCPU2Temp((byte)offset);
                twinProMCU.systemTemp[i] = this.getNodeSystemTemp((byte)offset);
                continue;
            }
            if (this.deviceType != 1) continue;
            twinProMCU.nodePN[i] = this.getNodePNbyPage((byte)offset);
            twinProMCU.nodeSN[i] = this.getNodeSNbyPage((byte)offset);
            twinProMCU.ip[i] = this.getNodeIPbyPage((byte)offset);
            twinProMCU.power[i] = this.getNodePowerbyPage((byte)offset);
            twinProMCU.current[i] = this.getNodeCurrentbyPage((byte)offset);
            twinProMCU.cpu1Temp[i] = this.getNodeCPU1TempbyPage((byte)offset);
            twinProMCU.cpu2Temp[i] = this.getNodeCPU2TempbyPage((byte)offset);
            twinProMCU.systemTemp[i] = this.getNodeSystemTempbyPage((byte)offset);
            twinProMCU.ipv6[i] = this.getNodeIPv6IP((byte)offset);
        }
        twinProMCU.backPlaneModelNumber = this.getBackPlaneModelNumber();
        twinProMCU.chassisName = this.getChassisName();
        twinProMCU.mcuVersion = this.getMCUVersion();
        return twinProMCU;
    }

    public static void main(String[] args) {
    }

    public class TwinProMCU {
        public static final int TWIN_PRO_2_NODE = 0;
        public static final int ULTRA_TWIN_2_NODE = 1;
        public int twoNodeType = 0;
        public int configID;
        public int nodeSize;
        public byte nodeID;
        public int present;
        public int pson;
        public byte p12v;
        public byte[] userDefineSystemName;
        public byte[] systemPN;
        public byte[] systemSN;
        public byte[] chassisPN;
        public byte[] chassisSN;
        public byte[] backplanePN;
        public byte[] backplaneSN;
        public byte[] mcuVersion;
        public byte[] chassisLocation;
        public byte bpLocation;
        public byte bpnID;
        public byte[] bpnRevision;
        public byte[][] nodePN;
        public byte[][] nodeSN;
        public byte[][] ip;
        public byte[][] power;
        public byte[][] current;
        public byte[] cpu1Temp;
        public byte[] cpu2Temp;
        public byte[] systemTemp;
        public byte[] chassisName;
        public byte[] backPlaneModelNumber;
        public byte[][] ipv6;
        String formatTemplate = "%5s | %-8s | %-15s | %5s | %7s | %4s | %4s | %6s\n";
        String nodeFormatTemplate = "%5s | %-25s | %-25s \n";
        String nodeFormatTemplateMicroCloud = "%5s | %-20s | %-20s | %-40s \n";

        public String presentNodeID(int nodeID) {
            int nodeSize = this.getNodeSize((byte)this.configID);
            if (this.configID == 12 || this.configID == 8) {
                return String.valueOf(nodeID);
            }
            if (this.bpLocation == 1) {
                if (nodeSize == 1) {
                    return String.valueOf(nodeID + 1);
                }
                if (nodeSize == 2) {
                    if (this.configID == 33) {
                        return String.format("%c", 64 + (nodeID + 2));
                    }
                    return String.valueOf(nodeID + 2);
                }
                if (nodeSize == 4) {
                    if (this.configID == 65) {
                        return String.format("%c", 64 + (nodeID + 4));
                    }
                    return String.valueOf(nodeID + 4);
                }
                return String.valueOf(nodeID);
            }
            if (this.bpLocation == 16) {
                if (this.configID == 33 || this.configID == 65) {
                    return String.format("%c", 64 + nodeID);
                }
                return String.valueOf(nodeID);
            }
            return String.format("%c", 64 + nodeID);
        }

        private int getNodeSize(byte config) {
            switch (this.configID) {
                case 1: {
                    return 1;
                }
                case 2: 
                case 33: {
                    return 2;
                }
                case 3: {
                    return 2;
                }
                case 4: 
                case 65: {
                    return 4;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 4;
                }
                case 7: {
                    return 3;
                }
                case 8: {
                    return 8;
                }
                case 12: {
                    return 12;
                }
            }
            return 0;
        }

        public TwinProMCU(int configID) {
            this.configID = configID;
            switch (configID) {
                case 1: {
                    this.nodeSize = 1;
                    break;
                }
                case 2: {
                    this.nodeSize = 2;
                    break;
                }
                case 3: {
                    this.nodeSize = 2;
                    break;
                }
                case 4: {
                    this.nodeSize = 4;
                    break;
                }
                case 5: {
                    this.nodeSize = 2;
                    break;
                }
                case 6: {
                    this.nodeSize = 4;
                    break;
                }
                case 7: {
                    this.nodeSize = 3;
                    break;
                }
                case 8: {
                    this.nodeSize = 8;
                    break;
                }
                case 12: {
                    this.nodeSize = 12;
                    break;
                }
                case 33: {
                    this.nodeSize = 2;
                    break;
                }
                case 65: {
                    this.nodeSize = 4;
                    break;
                }
                default: {
                    this.nodeSize = 0;
                }
            }
            this.nodePN = new byte[this.nodeSize][];
            this.nodeSN = new byte[this.nodeSize][];
            this.ip = new byte[this.nodeSize][];
            this.power = new byte[this.nodeSize][];
            this.current = new byte[this.nodeSize][];
            this.cpu1Temp = new byte[this.nodeSize];
            this.cpu2Temp = new byte[this.nodeSize];
            this.systemTemp = new byte[this.nodeSize];
            this.ipv6 = new byte[this.nodeSize][];
        }

        public String displayConfigID(int configID) {
            if (configID == 33 || configID == 65) {
                return ByteUtility.byteToHex((byte)configID);
            }
            return Integer.toString(configID);
        }

        public String displayIsPresent(byte nodeIndex) {
            if (nodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                nodeIndex = (byte)(nodeIndex + 1);
            }
            if ((this.present & 1 << nodeIndex) == 0) {
                return "";
            }
            return "Present";
        }

        public String displayPsonString(byte nodeIndex) {
            if (nodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                nodeIndex = (byte)(nodeIndex + 1);
            }
            if ((this.present & 1 << nodeIndex) == 0) {
                return "";
            }
            if ((this.pson & 1 << nodeIndex) > 0) {
                return "Active";
            }
            return "Inactive";
        }

        public String displayP12vString(byte nodeIndex) {
            if (nodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                nodeIndex = (byte)(nodeIndex + 1);
            }
            if (this.configID == 12) {
                return "N/A";
            }
            if ((this.present & 1 << nodeIndex) == 0) {
                return "";
            }
            if ((this.p12v & 1 << nodeIndex) > 0) {
                return "Active";
            }
            return "Inactive";
        }

        public String displayIP(byte nodeIndex) {
            int aNodeIndex = nodeIndex;
            if (aNodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                ++aNodeIndex;
            }
            if ((this.present & 1 << aNodeIndex) == 0) {
                return "";
            }
            String ipString = (this.ip[nodeIndex][0] & 0xFF) + "." + (this.ip[nodeIndex][1] & 0xFF) + "." + (this.ip[nodeIndex][2] & 0xFF) + "." + (this.ip[nodeIndex][3] & 0xFF);
            return ipString;
        }

        public String displayWatts(byte nodeIndex) {
            int aNodeIndex = nodeIndex;
            if (aNodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                ++aNodeIndex;
            }
            if ((this.present & 1 << aNodeIndex) == 0) {
                return "";
            }
            if ((this.pson & 1 << aNodeIndex) == 0) {
                return "N/A";
            }
            if (this.power[nodeIndex][0] == -1 && this.power[nodeIndex][1] == -1) {
                return "N/A";
            }
            if (ByteUtility.twoBytesToInt(this.power[nodeIndex]) < 0) {
                return "N/A";
            }
            return "" + ByteUtility.twoBytesToInt(this.power[nodeIndex]) + "W";
        }

        public String displayCurrent(byte nodeIndex) {
            int aNodeIndex = nodeIndex;
            if (aNodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                ++aNodeIndex;
            }
            if ((this.present & 1 << aNodeIndex) == 0) {
                return "";
            }
            if ((this.pson & 1 << aNodeIndex) == 0) {
                return "N/A";
            }
            if (this.current[nodeIndex][0] == -1 && this.current[nodeIndex][1] == -1) {
                return "N/A";
            }
            if ((float)ByteUtility.twoBytesToInt(this.current[nodeIndex]) / 10.0f < 0.0f) {
                return "N/A";
            }
            String fString = String.format("%3.1f", Float.valueOf((float)ByteUtility.twoBytesToInt(this.current[nodeIndex]) / 10.0f));
            return fString + "A";
        }

        public String displayCPU1Temp(byte nodeIndex) {
            int aNodeIndex = nodeIndex;
            if (aNodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                ++aNodeIndex;
            }
            if ((this.present & 1 << aNodeIndex) == 0) {
                return "";
            }
            if ((this.pson & 1 << aNodeIndex) == 0) {
                return "N/A";
            }
            if (this.cpu1Temp[nodeIndex] == -1) {
                return "N/A";
            }
            if (this.cpu1Temp[nodeIndex] <= 0) {
                return "N/A";
            }
            long f = Math.round(1.8 * (double)this.cpu1Temp[nodeIndex] + 32.0);
            return this.cpu1Temp[nodeIndex] + "C";
        }

        public String displayCPU2Temp(byte nodeIndex) {
            int aNodeIndex = nodeIndex;
            if (aNodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                ++aNodeIndex;
            }
            if ((this.present & 1 << aNodeIndex) == 0) {
                return "";
            }
            if ((this.pson & 1 << aNodeIndex) == 0) {
                return "N/A";
            }
            if (this.cpu2Temp[nodeIndex] == -1) {
                return "N/A";
            }
            if (this.cpu2Temp[nodeIndex] <= 0) {
                return "N/A";
            }
            long f = Math.round(1.8 * (double)this.cpu2Temp[nodeIndex] + 32.0);
            return this.cpu2Temp[nodeIndex] + "C";
        }

        public String displaySystemTemp(byte nodeIndex) {
            int aNodeIndex = nodeIndex;
            if (aNodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                ++aNodeIndex;
            }
            if ((this.present & 1 << aNodeIndex) == 0) {
                return "";
            }
            if ((this.pson & 1 << aNodeIndex) == 0) {
                return "N/A";
            }
            if (this.systemTemp[nodeIndex] == -1) {
                return "N/A";
            }
            if (this.systemTemp[nodeIndex] <= 0) {
                return "N/A";
            }
            long f = Math.round(1.8 * (double)this.systemTemp[nodeIndex] + 32.0);
            return this.systemTemp[nodeIndex] + "C";
        }

        public String displayBPLocation() {
            if (this.configID == 12 || this.configID == 8) {
                return ByteUtility.byteToHex(this.bpLocation);
            }
            if (this.bpLocation == 16) {
                return "Left";
            }
            if (this.bpLocation == 1) {
                return "Right";
            }
            return "N/A (" + ByteUtility.byteToHex(this.bpLocation) + "h)";
        }

        public String displayMCUVersion() {
            return this.mcuVersion[0] + "." + ByteUtility.byteToHex(this.mcuVersion[1]);
        }

        public String displayBPNID() {
            return Integer.toString(this.bpnID);
        }

        public String displayBPNRevision() {
            return this.bpnRevision[0] + "." + ByteUtility.byteToHex(this.bpnRevision[1]);
        }

        public String displayIPv6IP(byte nodeIndex) {
            if (IPMITwinProCommand.this.deviceType != 1) {
                return "";
            }
            int aNodeIndex = nodeIndex;
            if (aNodeIndex > 0 && (this.configID == 2 || this.configID == 5 || this.configID == 33)) {
                ++aNodeIndex;
            }
            if ((this.present & 1 << aNodeIndex) == 0) {
                return "";
            }
            String ipString = ByteUtility.byteToHex(this.ipv6[nodeIndex][0]) + ByteUtility.byteToHex(this.ipv6[nodeIndex][1]) + ":" + ByteUtility.byteToHex(this.ipv6[nodeIndex][2]) + ByteUtility.byteToHex(this.ipv6[nodeIndex][3]) + ":" + ByteUtility.byteToHex(this.ipv6[nodeIndex][4]) + ByteUtility.byteToHex(this.ipv6[nodeIndex][5]) + ":" + ByteUtility.byteToHex(this.ipv6[nodeIndex][6]) + ByteUtility.byteToHex(this.ipv6[nodeIndex][7]) + ":" + ByteUtility.byteToHex(this.ipv6[nodeIndex][8]) + ByteUtility.byteToHex(this.ipv6[nodeIndex][9]) + ":" + ByteUtility.byteToHex(this.ipv6[nodeIndex][10]) + ByteUtility.byteToHex(this.ipv6[nodeIndex][11]) + ":" + ByteUtility.byteToHex(this.ipv6[nodeIndex][12]) + ByteUtility.byteToHex(this.ipv6[nodeIndex][13]) + ":" + ByteUtility.byteToHex(this.ipv6[nodeIndex][14]) + ByteUtility.byteToHex(this.ipv6[nodeIndex][15]);
            return ipString;
        }

        public void checkTwoNodeType() {
            this.twoNodeType = this.nodeSize == 2 && (this.present & 4) > 0 ? 0 : (this.nodeSize == 2 && (this.present & 2) > 0 ? 1 : -1);
        }

        public int getTwoNodeType() {
            return this.twoNodeType;
        }

        public String toFormatedHeader() {
            StringBuffer formatedString = new StringBuffer();
            formatedString.append(String.format(this.formatTemplate, "Node", "Power", "IP", "Watts", "Current", "CPU1", "CPU2", "System"));
            formatedString.append(String.format(this.formatTemplate, "----", "--------", "--------------", "-----", "-------", "----", "----", "------"));
            return formatedString.toString();
        }

        public String toFormatedString() {
            StringBuffer formatedString = new StringBuffer();
            for (byte i = 0; i < this.nodeSize; i = (byte)(i + 1)) {
                formatedString.append(String.format(this.formatTemplate, this.presentNodeID(i + 1), this.displayPsonString(i), this.displayIP(i), this.displayWatts(i), this.displayCurrent(i), this.displayCPU1Temp(i), this.displayCPU2Temp(i), this.displaySystemTemp(i)));
            }
            return formatedString.toString();
        }

        public String toNodeFormatedHeader() {
            StringBuffer stringBuffer = new StringBuffer();
            if (IPMITwinProCommand.this.deviceType == 0 || IPMITwinProCommand.this.deviceType == 2 || IPMITwinProCommand.this.deviceType == 3 || IPMITwinProCommand.this.deviceType == 4 || IPMITwinProCommand.this.deviceType == 5) {
                stringBuffer.append(String.format(this.nodeFormatTemplate, "Node", "Node P/N", "Node S/N"));
                stringBuffer.append(String.format(this.nodeFormatTemplate, "----", "--------", "--------"));
            } else if (IPMITwinProCommand.this.deviceType == 1) {
                stringBuffer.append(String.format(this.nodeFormatTemplateMicroCloud, "Node", "Node P/N", "Node S/N", "IPv6"));
                stringBuffer.append(String.format(this.nodeFormatTemplateMicroCloud, "----", "--------", "--------", "----"));
            }
            return stringBuffer.toString();
        }

        public String toNodeFormatedString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (byte i = 0; i < this.nodeSize; i = (byte)(i + 1)) {
                if (IPMITwinProCommand.this.deviceType == 0 || IPMITwinProCommand.this.deviceType == 2 || IPMITwinProCommand.this.deviceType == 3 || IPMITwinProCommand.this.deviceType == 4 || IPMITwinProCommand.this.deviceType == 5) {
                    stringBuffer.append(String.format(this.nodeFormatTemplate, this.presentNodeID(i + 1), this.displayIsPresent(i).contains("Present") ? new String(this.replace0xFF(this.nodePN[i])).trim() : "", this.displayIsPresent(i).contains("Present") ? new String(this.replace0xFF(this.nodeSN[i])).trim() : ""));
                    continue;
                }
                if (IPMITwinProCommand.this.deviceType != 1) continue;
                stringBuffer.append(String.format(this.nodeFormatTemplateMicroCloud, this.presentNodeID(i + 1), new String(this.replace0xFF(this.nodePN[i])).trim(), new String(this.replace0xFF(this.nodeSN[i])).trim(), this.displayIPv6IP(i)));
            }
            return stringBuffer.toString();
        }

        public String toFieldString() {
            StringBuffer formatedString = new StringBuffer();
            formatedString.append("Configuration ID   : " + this.displayConfigID(this.configID) + "\n");
            formatedString.append("Current Node ID    : " + this.presentNodeID(this.nodeID) + "\n");
            formatedString.append("System Name        : " + (this.stringIs0xFF(this.userDefineSystemName) ? "(Empty)\n" : new String(this.replace0xFF(this.userDefineSystemName)).trim() + "\n"));
            formatedString.append("System P/N         : " + (this.stringIs0xFF(this.systemPN) ? "(Empty)\n" : new String(this.replace0xFF(this.systemPN)).trim() + "\n"));
            formatedString.append("System S/N         : " + (this.stringIs0xFF(this.systemSN) ? "(Empty)\n" : new String(this.replace0xFF(this.systemSN)).trim() + "\n"));
            formatedString.append("Chassis P/N        : " + (this.stringIs0xFF(this.chassisPN) ? "(Empty)\n" : new String(this.replace0xFF(this.chassisPN)).trim() + "\n"));
            formatedString.append("Chassis S/N        : " + (this.stringIs0xFF(this.chassisSN) ? "(Empty)\n" : new String(this.replace0xFF(this.chassisSN)).trim() + "\n"));
            formatedString.append("Backplane P/N      : " + (this.stringIs0xFF(this.backplanePN) ? "(Empty)\n" : new String(this.replace0xFF(this.backplanePN)).trim() + "\n"));
            formatedString.append("Backplane S/N      : " + (this.stringIs0xFF(this.backplaneSN) ? "(Empty)\n" : new String(this.replace0xFF(this.backplaneSN)).trim() + "\n"));
            formatedString.append("Chassis Location   : " + ByteUtility.bytesToHex(this.chassisLocation) + "\n");
            formatedString.append("BP Location        : " + this.displayBPLocation() + "\n");
            formatedString.append("MCU Version        : " + this.displayMCUVersion() + "\n");
            formatedString.append("BPN Revision       : " + this.displayBPNRevision());
            return formatedString.toString();
        }

        public boolean stringIs0xFF(byte[] strBytes) {
            return (strBytes[0] & 0xFF) == 255;
        }

        public byte[] replace0xFF(byte[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if ((stringArray[i] & 0xFF) != 255) continue;
                stringArray[i] = 0;
            }
            return stringArray;
        }
    }
}

