/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import java.util.HashMap;
import java.util.Map;

enum MCUType {
    Standard(32),
    EC(64),
    TwinProMCU(4),
    CPLD(-128);

    private byte value;
    private static final Map<Byte, MCUType> mucMap;

    private MCUType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static MCUType getMCUNameBytValue(byte value) {
        return mucMap.get(value);
    }

    static {
        mucMap = new HashMap<Byte, MCUType>();
        for (MCUType myEnum : MCUType.values()) {
            mucMap.put(myEnum.getValue(), myEnum);
        }
    }
}

