/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.SuperBladeTool;

public class MEFlash
implements IPMIDCMOEMCommand.Progress {
    String ip;
    String username;
    String password;
    String imageFile;
    int valueBak = -1;

    public MEFlash(String ip, String username, String password, String imageFile) {
        this.ip = ip;
        this.username = username;
        this.password = password;
        this.imageFile = imageFile;
    }

    public void ver() throws Exception {
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.username);
        config.setPassword(this.password);
        config.setPrivilege((byte)4);
        IPMIDCMOEMCommand ipmiDCMOEMCommand = new IPMIDCMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiDCMOEMCommand);
        if (sessionController == null) {
            throw new Exception("Connection failure");
        }
        IPMB ipmb = new IPMB(ipmiDCMOEMCommand.getIPMIInterface());
        ipmb.setAddress((byte)-120);
        ipmb.setChannel((byte)0);
        ipmiDCMOEMCommand.setIPMIInterface(ipmb);
        ipmiDCMOEMCommand.setProgress(this);
        IPMIDCMOEMCommand.FirmwareFile firmwareFile = ipmiDCMOEMCommand.createFirmwareFile(this.imageFile);
        firmwareFile.getAllHeader();
        ipmiDCMOEMCommand.printVersion(firmwareFile);
    }

    public void flash() throws Exception {
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.username);
        config.setPassword(this.password);
        config.setPrivilege((byte)4);
        IPMIDCMOEMCommand ipmiDCMOEMCommand = new IPMIDCMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiDCMOEMCommand);
        if (sessionController == null) {
            throw new Exception("Connection failure");
        }
        IPMB ipmb = new IPMB(ipmiDCMOEMCommand.getIPMIInterface());
        ipmb.setAddress((byte)-120);
        ipmb.setChannel((byte)0);
        ipmiDCMOEMCommand.setIPMIInterface(ipmb);
        ipmiDCMOEMCommand.setProgress(this);
        ipmiDCMOEMCommand.flashFlow(this.imageFile);
    }

    @Override
    public void setValue(int value) {
        if (this.valueBak != value) {
            System.out.print(".");
            this.valueBak = value;
            if (this.valueBak == 99) {
                System.out.println("");
            }
        }
    }

    @Override
    public void message(String message) {
        System.out.println(message);
    }

    @Override
    public void left(long diffMillis) {
    }

    public static void usage() {
        System.out.println("MEFlash Utility 1.01 (Buil 090109) - " + SuperBladeTool.companyName);
        System.out.println("Usage: MEFlash <Option> <IP> <Username> <Password> <Imagefile> ");
        System.out.println("Option:  ");
        System.out.println("    -v: Show ME and Image version  ");
        System.out.println("    -f: flash  ");
        System.out.println("");
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            MEFlash.usage();
            return;
        }
        String option = args[0];
        String ip = args[1];
        String username = args[2];
        String password = args[3];
        String imageFile = args[4];
        if (!IPMILanCommand.isIPAddress(ip)) {
            System.out.println("IP Address invalid !");
            return;
        }
        MEFlash meFlash = new MEFlash(ip, username, password, imageFile);
        try {
            if (option.equalsIgnoreCase("-f")) {
                MEFlash.flashJob(meFlash);
            } else if (option.equalsIgnoreCase("-v")) {
                meFlash.ver();
            } else {
                System.out.println("Unsupported option");
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void flashJob(MEFlash meFlash) throws Exception {
        int retryCount = 0;
        boolean isDone = false;
        do {
            try {
                meFlash.flash();
                isDone = true;
            }
            catch (Exception ex) {
                System.out.println();
                System.out.println("Recovery and retry :" + ++retryCount);
                if (retryCount <= 3) continue;
                throw ex;
            }
        } while (!isDone);
    }
}

