/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.junit;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.junit.TestSuiteForIPMI;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestIPMISDRCommand
extends TestCase {
    private IPMISDRCommand ipmiSDRCommand = null;
    ISessionController sessionController;

    public TestIPMISDRCommand(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.sessionController = TestSuiteForIPMI.getSessionController();
        IPMINetworkInterface ipmiInterface = this.sessionController.startup(TestSuiteForIPMI.getIPMIInterfaceConfig());
        this.ipmiSDRCommand = new IPMISDRCommand(ipmiInterface);
    }

    protected void tearDown() throws Exception {
        this.sessionController.closeSession();
    }

    public void testGetSDRRepositoryInfoModal() {
        SDRInfo sdrInfo = this.ipmiSDRCommand.getSDRRepositoryInfoModal();
        System.out.println(sdrInfo.toString());
        TestIPMISDRCommand.assertNotNull((Object)sdrInfo);
    }

    public void testGetSDRReservationID() {
        byte[] id = this.ipmiSDRCommand.getSDRReservationID();
        System.out.println(ByteUtility.bytesToHex(id));
        TestIPMISDRCommand.assertNotNull((Object)id);
    }

    public void testGetSDRs() {
        SDRInfo sdrInfo = this.ipmiSDRCommand.getSDRRepositoryInfoModal();
        ArrayList list = this.ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        TestIPMISDRCommand.assertEquals((int)list.size(), (int)sdrInfo.getRecordCount());
    }
}

