/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade.kvm;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.MicroBladeInfoManager;
import com.supermicro.ipmi.microblade.kvm.MicroBladeKVMButtons;
import com.supermicro.ipmi.microblade.kvm.MicroBladeKVMMediator;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class MicroBladeKVMButtonRows
extends JPanel
implements Observer {
    MicroBladeInfoManager infoManager;
    public static String[][] bladeLabels = new String[][]{{"A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10", "A11", "A12", "A13", "A14"}, {"B14", "B13", "B12", "B11", "B10", "B9", "B8", "B7", "B6", "B5", "B4", "B3", "B2", "B1"}};
    public static int[][] bladeIndex = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14}};
    int nodeSize = 4;
    int blockWidth = 40;
    int blockHeight = 85;
    MicroBladeKVMButtons[] buttonsArray;
    MicroBladeKVMMediator mediator;

    public MicroBladeKVMButtonRows(MicroBladeKVMMediator mediator, MicroBladeInfoManager infoManager, IPMIInterfaceConfig config) {
        this.infoManager = infoManager;
        IPMIMicroBladeOEMCommand ipmiMicrobladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiMicrobladeOEMCommand);
        int bladeSize = 28;
        try {
            bladeSize = ipmiMicrobladeOEMCommand.getBackPlaneBladeNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bladeSize == 20) {
            bladeLabels = new String[][]{{"A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10"}, {"B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "B10"}};
            bladeIndex = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {14, 15, 16, 17, 18, 19, 20, 21, 22, 23}};
        }
        if (bladeSize == 14) {
            bladeLabels = new String[][]{{"A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10", "A11", "A12", "A13", "A14"}};
            bladeIndex = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}};
        }
        if (bladeSize == 10) {
            bladeLabels = new String[][]{{"A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10"}};
            bladeIndex = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}};
        }
        try {
            sessionController.closeSession();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mediator = mediator;
        this.buttonsArray = new MicroBladeKVMButtons[bladeLabels.length * bladeLabels[0].length];
        this.setLayout(new GridLayout(bladeLabels.length, bladeLabels[0].length, 4, 10));
        for (int i = 0; i < bladeLabels.length; ++i) {
            for (int j = 0; j < bladeLabels[i].length; ++j) {
                this.buttonsArray[i * MicroBladeKVMButtonRows.bladeLabels[i].length + j] = new MicroBladeKVMButtons(mediator, bladeLabels[i][j], bladeIndex[i][j], this.nodeSize, this.blockWidth, this.blockHeight, infoManager);
                this.add(this.buttonsArray[i * bladeLabels[i].length + j]);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        for (int i = 0; i < this.buttonsArray.length; ++i) {
            this.buttonsArray[i].update(o, arg);
        }
    }
}

