/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.TurboRatio;
import java.util.HashMap;
import java.util.Map;

public class GetTurboSynchronizationRatio {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMINM20Command ipmiCommand;
    private byte socketNumber;
    private byte activeCoresConfig;

    public GetTurboSynchronizationRatio(IPMINM20Command ipmiCommand, byte socketNumber, byte activeCoresConfig) {
        this.ipmiCommand = ipmiCommand;
        this.socketNumber = socketNumber;
        this.activeCoresConfig = activeCoresConfig;
    }

    public TurboRatio execute() throws IPMIException {
        IPMIMessage resMessage = this.ipmiCommand.getTurboSynchronizationRatioCommand(this.socketNumber, this.activeCoresConfig);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new TurboRatio(resMessage.data);
            }
            throw Common.cCodeToException(completionCodeToString, resMessage);
        }
        throw new IPMIException("Call GetTurboSynchronizationRatio failed");
    }

    static {
        completionCodeToString.put("A1", "Wrong CPU socket number.");
        completionCodeToString.put("A2", "Command response timeout.");
        completionCodeToString.put("A4", "Bad read FSC in the response.");
        completionCodeToString.put("A5", "Bad write FCS field in the response.");
        completionCodeToString.put("AC", "CPU not present.");
        completionCodeToString.put("D5", "Platform not in S0/S1 state.");
        completionCodeToString.put("C9", "Incorrect active cores configuration. Unsupported number of active cores.");
        completionCodeToString.put("FF", "Other error encountered.");
    }
}

