/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import java.util.Arrays;

public class PolicyAlertThresholds {
    private static final int MIN_DATA_LENGTH = 4;
    private static final int MAX_DATA_LENGTH = 10;
    private static final int OFF_NUMBER_OF_THRESHOLD = 3;
    private static final int OFF_THRESHOLD = 4;
    private byte[] raw;
    public final int numOfThresholds;
    public final int[] thresholds = new int[3];

    public PolicyAlertThresholds(byte[] raw) throws IPMIException {
        if (raw.length > 10 || raw.length < 4) {
            throw new IPMIException("Invalid Length");
        }
        this.raw = raw;
        this.numOfThresholds = raw[3] & 0xFF;
        this.getThresholds();
    }

    private void getThresholds() {
        for (int i = 0; i < this.numOfThresholds; ++i) {
            this.thresholds[i] = ByteUtility.twoBytesToIntLSB(this.raw, 4 + i * 2);
        }
    }

    public void toReadableString() {
        System.out.println("Number of alert thresholds = " + this.numOfThresholds);
        for (int i = 0; i < this.numOfThresholds; ++i) {
            System.out.println("Threshold[" + i + "] = " + this.thresholds[i]);
        }
    }

    public String toString() {
        return "NodeManagerPolicyAlertThresholds [numOfThresholds=" + this.numOfThresholds + ", thresholds=" + Arrays.toString(this.thresholds) + "]";
    }
}

