/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import java.util.HashMap;
import java.util.Map;

public class SetNodeManagerPolicySuspendPeriods {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMINM20Command ipmiCommand;
    private byte domainId;
    private byte policyId;
    private int numOfPeriods;
    private byte[] periods;

    public SetNodeManagerPolicySuspendPeriods(IPMINM20Command ipmiCommand, byte domainId, byte policyId, int count, byte[] periods) {
        this.ipmiCommand = ipmiCommand;
        this.domainId = domainId;
        this.policyId = policyId;
        this.numOfPeriods = count;
        this.periods = periods;
    }

    public void execute() throws IPMIException {
        IPMIMessage resMessage = this.ipmiCommand.setNodeManagerPolicySuspendPeriodsCommand(this.domainId, this.policyId, (byte)this.numOfPeriods, this.periods);
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                throw Common.cCodeToException(completionCodeToString, resMessage);
            }
        } else {
            throw new IPMIException("Call SetNodeManagerPolicySuspendPeriods failed");
        }
    }

    public String toString() {
        return "SetNodeManagerPolicySuspendPeriods [domainId=" + this.domainId + ", policyId=" + this.policyId + ", numOfPeriods=" + this.numOfPeriods + ", periods=" + ByteUtility.bytesToHex(this.periods) + "]";
    }

    static {
        completionCodeToString.put("80", "Policy ID Invalid.");
        completionCodeToString.put("81", "Domain ID Invalid.");
        completionCodeToString.put("82", "Unknown or unsupported Policy Trigger Type.");
        completionCodeToString.put("85", "One of periods in the table is inconsistent.");
        completionCodeToString.put("87", "Number of policy suspend periods invalid");
        completionCodeToString.put("D4", "Insufficient privilege level due wrong responder LUN.");
    }
}

