/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.dcmi;

import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.nm.Common;
import java.util.HashMap;
import java.util.Map;

public class GetPowerReading {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMIDCMICommand dcmi;

    public GetPowerReading(IPMIDCMICommand dcmi) {
        this.dcmi = dcmi;
    }

    public IPMIDCMICommand.DCMIPowerReading execute(byte mode, byte attribute) throws IPMIException {
        IPMIMessage resMessage = this.dcmi.getPowerReadingCommand(mode, attribute, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                IPMIDCMICommand.DCMIPowerReading powerStatus = new IPMIDCMICommand.DCMIPowerReading();
                powerStatus.fromRaw(resMessage.data);
                return powerStatus;
            }
            throw Common.cCodeToException(completionCodeToString, resMessage);
        }
        throw new IPMIException("Call GetPowerReading failed");
    }

    static {
        completionCodeToString.put("C1", "Returned if DCMI mode is not present.");
    }
}

