/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class BatchCommand {
    ArrayList<ArrayList<String>> commandArrays = new ArrayList();
    public final String[] ACTIVATE_KEY_SET = new String[]{"bios", "setKey", "$PRODUCT_KEY"};
    public final String[] DEACTIVATE_KEY_SET = new String[]{"ipmi", "raw", "30", "70", "f2"};

    public void load(String filename) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while ((line = in.readLine()) != null) {
            if (line.length() == 0 || line.startsWith(";")) continue;
            ArrayList<String> command = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(line, " ");
            while (st.hasMoreTokens()) {
                command.add(st.nextToken().trim());
            }
            this.commandArrays.add(command);
        }
        in.close();
    }

    public boolean isContainsActivateKey() {
        boolean isContains = false;
        for (ArrayList<String> strArrList : this.commandArrays) {
            if (strArrList.size() == this.ACTIVATE_KEY_SET.length) {
                isContains = true;
                for (int index = 0; index < strArrList.size(); ++index) {
                    if (strArrList.get(index).equalsIgnoreCase(this.ACTIVATE_KEY_SET[index])) continue;
                    isContains = false;
                    break;
                }
            }
            if (!isContains) continue;
            break;
        }
        return isContains;
    }

    public boolean discardActivateKey() {
        return this.discardCommandSet(this.ACTIVATE_KEY_SET);
    }

    public boolean discardDeactivateKey() {
        return this.discardCommandSet(this.DEACTIVATE_KEY_SET);
    }

    private boolean discardCommandSet(String ... cmdSet) {
        List<String> cmdList = Arrays.asList(cmdSet);
        ArrayList<ArrayList<String>> discardSet = new ArrayList<ArrayList<String>>();
        for (ArrayList<String> strArrList : this.commandArrays) {
            Iterator<String> strIter = strArrList.iterator();
            Iterator<String> cmdIter = cmdList.iterator();
            while (strIter.hasNext() && strIter.next().equalsIgnoreCase(cmdIter.next())) {
            }
            if (strIter.hasNext()) continue;
            discardSet.add(strArrList);
        }
        return this.commandArrays.removeAll(discardSet);
    }

    public String[][] toStringArray() {
        String[][] commandArrayStrings = new String[this.commandArrays.size()][];
        for (int i = 0; i < this.commandArrays.size(); ++i) {
            commandArrayStrings[i] = new String[this.commandArrays.get(i).size()];
            for (int j = 0; j < this.commandArrays.get(i).size(); ++j) {
                commandArrayStrings[i][j] = this.commandArrays.get(i).get(j);
            }
        }
        return commandArrayStrings;
    }

    public void testPrint() {
        String[][] commandArrayStrings = this.toStringArray();
        for (int i = 0; i < this.commandArrays.size(); ++i) {
            for (int j = 0; j < this.commandArrays.get(i).size(); ++j) {
                System.out.print(commandArrayStrings[i][j] + " ");
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        BatchCommand script = new BatchCommand();
        script.load("C:\\workspace\\resources\\MBT_Config\\Redfish_ActivationTool_Test\\script\\222.cmd");
        if (script.discardActivateKey()) {
            System.out.println("discardActivateKey true");
        }
        if (script.discardDeactivateKey()) {
            System.out.println("discardDeactivateKey true");
        }
        script.testPrint();
    }
}

